<?php
/**
 * ACF options.
 *
 * @package King
 */

// Prevent direct script access.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
// Acf options.
if( function_exists('acf_add_local_field_group') ):

acf_add_local_field_group(array(
    'key' => 'group_5c9bedf97e739',
    'title' => 'Comments Reactions',
    'fields' => array(
        array(
            'key' => 'field_5c9bee01a519a',
            'label' => __('Comments Reactions' , 'king' ),
            'name' => 'comments_reactions',
            'type' => 'radio',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => 'king-reactions',
                'id' => '',
            ),
            'choices' => array(
                'like' => 'Like',
                'love' => 'Love',
                'haha' => 'Haha',
                'wow' => 'Wow',
                'sad' => 'Sad',
                'angry' => 'Angry',
            ),
            'allow_null' => 1,
            'other_choice' => 0,
            'default_value' => '',
            'layout' => 'horizontal',
            'return_format' => 'value',
            'save_other_choice' => 0,
        ),
    ),
    'location' => array(
        array(
            array(
                'param' => 'comment',
                'operator' => '==',
                'value' => 'post',
            ),
        ),
        array(
            array(
                'param' => 'comment',
                'operator' => '==',
                'value' => 'list',
            ),
        ),
        array(
            array(
                'param' => 'comment',
                'operator' => '==',
                'value' => 'poll',
            ),
        ),
        array(
            array(
                'param' => 'comment',
                'operator' => '==',
                'value' => 'trivia',
            ),
        ),
    ),
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => true,
    'description' => '',
    'show_in_rest' => false,
));

acf_add_local_field_group(array(
    'key' => 'group_58bc8b1eea4cf',
    'title' => 'Custom Style',
    'fields' => array(
        array(
            'key' => 'field_5803e16ce8443',
            'label' => __('Body' , 'king' ),
            'name' => '',
            'type' => 'tab',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'left',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_57f6b8674af4c',
            'label' => __('Select page Font family' , 'king' ),
            'name' => 'google_fonts',
            'type' => 'select',
            'instructions' => __('by <a href="https://fonts.google.com/" target="_blank">Google Fonts</a>', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array(
                'Roboto' => 'Roboto',
                'Quicksand' => 'Quicksand',
                'Varela+Round' => 'Varela Round',
                'Lato' => 'Lato',
                'Raleway' => 'Raleway',
                'Ubuntu' => 'Ubuntu',
                'Titillium+Web' => 'Titillium Web',
                'Dosis' => 'Dosis',
                'Open+Sans' => 'Open Sans',
                'Rubik' => 'Rubik',
                'Changa' => 'Changa',
                'Kanit' => 'Kanit',
                'Ek+Mukta' => 'Ek Mukta',
                'Prompt' => 'Prompt',
                'Mitr' => 'Mitr',
                'Quantico' => 'Quantico',
                'El+Messiri' => 'El Messiri',
                'Josefin+Sans' => 'Josefin Sans',
                'Hind+Guntur' => 'Hind Guntur',
                'Hind+Madurai' => 'Hind Madurai',
                'Source+Sans+Pro' => 'Source Sans Pro',
                'Heebo' => 'Heebo',
                'Poppins' => 'Poppins',
            ),
            'default_value' => false,
            'allow_null' => 1,
            'multiple' => 0,
            'ui' => 0,
            'return_format' => 'value',
            'ajax' => 0,
            'placeholder' => '',
        ),
        array(
            'key' => 'field_57c895309a899',
            'label' => __('Body Background' , 'king' ),
            'name' => 'body_background',
            'type' => 'color_picker',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_57fc0ca410dd7',
            'label' => __('Page Link Color' , 'king' ),
            'name' => 'page_link_color',
            'type' => 'color_picker',
            'instructions' => __('Select Site links color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_57fc0ed8b5f65',
            'label' => __('Page Link Hover Color' , 'king' ),
            'name' => 'page_link_hover_color',
            'type' => 'color_picker',
            'instructions' => __('Select Site links hover color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_58729141f3c04',
            'label' => __('Button Colors' , 'king' ),
            'name' => 'button_colors',
            'type' => 'color_picker',
            'instructions' => __('Select Site button colors', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5872921c0b902',
            'label' => __('Button Text Color' , 'king' ),
            'name' => 'button_text_color',
            'type' => 'color_picker',
            'instructions' => __('Select Site button text color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5c9bd6e067283',
            'label' => __('Follow Button Background' , 'king' ),
            'name' => 'follow_button_background',
            'type' => 'color_picker',
            'instructions' => __('Select Follow Button Background Color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5c9bd71167285',
            'label' => __('Follow Button Text Color' , 'king' ),
            'name' => 'follow_button_text_color',
            'type' => 'color_picker',
            'instructions' => __('Select Follow Button Text Color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5806785eb286e',
            'label' => __('Post Background' , 'king' ),
            'name' => 'post_background',
            'type' => 'color_picker',
            'instructions' => __('Posts box background color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5c9bd73367286',
            'label' => __('Post Title Color' , 'king' ),
            'name' => 'post_title_color',
            'type' => 'color_picker',
            'instructions' => __('Select post title color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5887f64af5e57',
            'label' => __('Post entry content color' , 'king' ),
            'name' => 'post_entry_content_color',
            'type' => 'color_picker',
            'instructions' => __('Post entry content text color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5863f58305007',
            'label' => __('Posts Meta Background' , 'king' ),
            'name' => 'posts_meta_background',
            'type' => 'color_picker',
            'instructions' => __('Posts box Meta background color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5863f5aa05008',
            'label' => __('Posts Meta Text Color' , 'king' ),
            'name' => 'posts_meta_color',
            'type' => 'color_picker',
            'instructions' => __('Posts box Meta Text Color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5c9bd76567287',
            'label' => __('Editors\' choice badge background' , 'king' ),
            'name' => 'editors_choice_badge_background',
            'type' => 'color_picker',
            'instructions' => __('Select editors\' choice badge background color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5c9bd78567288',
            'label' => __('Editors\' choice badge text' , 'king' ),
            'name' => 'editors_choice_badge_text',
            'type' => 'color_picker',
            'instructions' => __('Select editors\' choice badge text color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_57fc0fe5cbf75',
            'label' => __('Color For News' , 'king' ),
            'name' => 'color_for_news',
            'type' => 'color_picker',
            'instructions' => __('Select color for the News', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_57fc1018316d4',
            'label' => __('Color For Videos' , 'king' ),
            'name' => 'color_for_videos',
            'type' => 'color_picker',
            'instructions' => __('Select color for the Videos', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_57fc103b316d5',
            'label' => __('Color For Images' , 'king' ),
            'name' => 'color_for_images',
            'type' => 'color_picker',
            'instructions' => __('Select color for the Images', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5ef4eb809f545',
            'label' => __('Color For Music' , 'king' ),
            'name' => 'color_for_music',
            'type' => 'color_picker',
            'instructions' => __('Select color for the Musics', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_60c64b341e0a2',
            'label' => __('Color For List' , 'king' ),
            'name' => 'color_for_list',
            'type' => 'color_picker',
            'instructions' => __('Select color for the Lists', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_60c64b431e0a3',
            'label' => __('Color For Poll' , 'king' ),
            'name' => 'color_for_poll',
            'type' => 'color_picker',
            'instructions' => __('Select color for the Poll', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_60c64b4f1e0a4',
            'label' => __('Color For Trivia Quiz' , 'king' ),
            'name' => 'color_for_trivia_quiz',
            'type' => 'color_picker',
            'instructions' => __('Select color for the Trivia Quiz', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_58890c43f6bdc',
            'label' => __('Color For NSFW' , 'king' ),
            'name' => 'color_for_nsfw',
            'type' => 'color_picker',
            'instructions' => __('Select color for the NSFW posts', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_586695b184cca',
            'label' => __('Load More Button Background Color' , 'king' ),
            'name' => 'load_more_background',
            'type' => 'color_picker',
            'instructions' => __('Select color for the Load more button background', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5866961584ccb',
            'label' => __('Load More Button Text Color' , 'king' ),
            'name' => 'load_more_button_text_color',
            'type' => 'color_picker',
            'instructions' => __('Select color for the Load more button text', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5ea6ec9e0eb97',
            'label' => __('Alert Background Color' , 'king' ),
            'name' => 'alert_background_color',
            'type' => 'color_picker',
            'instructions' => __('Select background color for error message', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5ea6ecd50eb98',
            'label' => __('Alert Text Color' , 'king' ),
            'name' => 'alert_text_color',
            'type' => 'color_picker',
            'instructions' => __('Select text color for error message', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_584b139267219',
            'label' => __('Disable Custom Css' , 'king' ),
            'name' => 'disable_custom_css',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Disable Custom Css and Colors', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_5803e105e3ce4',
            'label' => __('Header' , 'king' ),
            'name' => '',
            'type' => 'tab',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'left',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_57c88ed8fba47',
            'label' => __('Header Background' , 'king' ),
            'name' => 'header_background',
            'type' => 'color_picker',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_57fc093cc31f2',
            'label' => __('Header Link Color' , 'king' ),
            'name' => 'header_link_color',
            'type' => 'color_picker',
            'instructions' => __('change the header link colors', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_57fc0a2cc9b37',
            'label' => __('Header Search Background' , 'king' ),
            'name' => 'header_search_background',
            'type' => 'color_picker',
            'instructions' => __('change the header search bar background color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5c9bd7e05e57c',
            'label' => __('Header Menu Background Color' , 'king' ),
            'name' => 'header_menu_background_color',
            'type' => 'color_picker',
            'instructions' => __('change the header menu background color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5c9bd7f55e57d',
            'label' => __('Header Menu Link Colors' , 'king' ),
            'name' => 'header_menu_link_colors',
            'type' => 'color_picker',
            'instructions' => __('change the header menu link colors', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5c9bd80b5e57e',
            'label' => __('Header Menu Link Hover Colors' , 'king' ),
            'name' => 'header_menu_link_hover_colors',
            'type' => 'color_picker',
            'instructions' => __('change the header menu link hover colors', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5cfa387973f7a',
            'label' => __('Notification Icon Background' , 'king' ),
            'name' => 'notification_icon_background',
            'type' => 'color_picker',
            'instructions' => __('change the Notification Icon Background color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5cfa389e73f7b',
            'label' => __('Notification Icon Color' , 'king' ),
            'name' => 'notification_icon_color',
            'type' => 'color_picker',
            'instructions' => __('change the Notification Icon color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5cfa38ae73f7c',
            'label' => __('Notification Box Background' , 'king' ),
            'name' => 'notification_box_background',
            'type' => 'color_picker',
            'instructions' => __('change the Notification Box Background color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5cfa38d073f7d',
            'label' => __('Notification Box Inside Background' , 'king' ),
            'name' => 'notification_box_inside_background',
            'type' => 'color_picker',
            'instructions' => __('change the Notification Box Inside Background color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5cfa391d73f7e',
            'label' => __('Notifications Text Color' , 'king' ),
            'name' => 'notifications_text_color',
            'type' => 'color_picker',
            'instructions' => __('change the Notifications Text Color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_58067a58ad696',
            'label' => __('Submit Button Background' , 'king' ),
            'name' => 'submit_background',
            'type' => 'color_picker',
            'instructions' => __('Select Submit Button Background color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_59249acf78b65',
            'label' => __('Submit Button Link Colors' , 'king' ),
            'name' => 'submit_button_link_colors',
            'type' => 'color_picker',
            'instructions' => __('Select Submit Button Link color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_58067a95f2787',
            'label' => __('Submit Button Icon Color' , 'king' ),
            'name' => 'submiticon_color',
            'type' => 'color_picker',
            'instructions' => __('Select Submit Button Icon color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5a63b13792977',
            'label' => __('Login and Register Buttons Background' , 'king' ),
            'name' => 'login_and_register_buttons_background',
            'type' => 'color_picker',
            'instructions' => __('Login and Register Buttons Background color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5ffdb52f1cbc0',
            'label' => __('Header Buttons Hover Background' , 'king' ),
            'name' => 'buttons_hover_background',
            'type' => 'color_picker',
            'instructions' => __('Login and Register Buttons Hover Background color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5945aa8244ab6',
            'label' => __('User points badge background' , 'king' ),
            'name' => 'user_points_badge_background',
            'type' => 'color_picker',
            'instructions' => __('Select User points badge background color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5945ab4244ab7',
            'label' => __('User points badge color' , 'king' ),
            'name' => 'user_points_badge_color',
            'type' => 'color_picker',
            'instructions' => __('Select User points badge text color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_57fc0857adad7',
            'label' => __('Navigation Background' , 'king' ),
            'name' => 'navigation_background',
            'type' => 'color_picker',
            'instructions' => __('change navigation background color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5806928fde018',
            'label' => __('Navigation Links Color' , 'king' ),
            'name' => 'navigation_links',
            'type' => 'color_picker',
            'instructions' => __('Navigation Links Color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_59249bdd7dd76',
            'label' => __('Navigation Links Active' , 'king' ),
            'name' => 'navigation_links_active',
            'type' => 'color_picker',
            'instructions' => __('Navigation Links Active Text Color & Border Color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5fff2c1e02b52',
            'label' => __('Small Navigation Background' , 'king' ),
            'name' => 'small_navigation_background',
            'type' => 'color_picker',
            'instructions' => __('Small navigation background color in profile , hot and reactions page', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5fff2c6502b53',
            'label' => __('Small Navigation Links' , 'king' ),
            'name' => 'small_navigation_links',
            'type' => 'color_picker',
            'instructions' => __('Small navigation links color in profile , hot and reactions page', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5fff2c7402b54',
            'label' => __('Small Navigation Links Hover' , 'king' ),
            'name' => 'small_navigation_links_hover',
            'type' => 'color_picker',
            'instructions' => __('Small navigation links hover color in profile , hot and reactions page', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5887f35a63c63',
            'label' => __('Page header background' , 'king' ),
            'name' => 'page_header_background',
            'type' => 'color_picker',
            'instructions' => __('Page header background Color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5887f44a63c64',
            'label' => __('Page header text color' , 'king' ),
            'name' => 'page_header_text_color',
            'type' => 'color_picker',
            'instructions' => __('Page header Text Color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5ecbc56daed99',
            'label' => __('Search v2 button background' , 'king' ),
            'name' => 'search_v2_button_background',
            'type' => 'color_picker',
            'instructions' => __('Select search v2 button background color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5ecbc591aed9a',
            'label' => __('Search v2 icon color' , 'king' ),
            'name' => 'search_v2_icon_color',
            'type' => 'color_picker',
            'instructions' => __('Select search v2 button icon color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5ecbc62dce687',
            'label' => __('Search v2 box background' , 'king' ),
            'name' => 'search_v2_box_background',
            'type' => 'color_picker',
            'instructions' => __('Select search v2 box background color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5ecbc642ce688',
            'label' => __('Search v2 input background' , 'king' ),
            'name' => 'search_v2_input_background',
            'type' => 'color_picker',
            'instructions' => __('Select search v2 box input background color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5fafbbaa31d6f',
            'label' => __('Bookmarks Icon Background' , 'king' ),
            'name' => 'bookmarks_icon_background',
            'type' => 'color_picker',
            'instructions' => __('Select bookmarks icon background color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5fafbbca31d70',
            'label' => __('Bookmarks Icon Color' , 'king' ),
            'name' => 'bookmarks_icon_color',
            'type' => 'color_picker',
            'instructions' => __('Select bookmarks icon color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5805367949bfd',
            'label' => __('Footer' , 'king' ),
            'name' => '',
            'type' => 'tab',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'left',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_5805368749bfe',
            'label' => __('Footer Background' , 'king' ),
            'name' => 'footer_background',
            'type' => 'color_picker',
            'instructions' => __('Select footer background color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5805375a5b9a4',
            'label' => __('Footer Widget Area Background' , 'king' ),
            'name' => 'fatfooter_background',
            'type' => 'color_picker',
            'instructions' => __('Select footer widget area background color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_58067be4a3470',
            'label' => __('Footer Widgets Title Background' , 'king' ),
            'name' => 'footer_widgets_title_background',
            'type' => 'color_picker',
            'instructions' => __('Select footer widgets title background color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_58067c33c8cda',
            'label' => __('Footer Widgets Title Color' , 'king' ),
            'name' => 'footer_widgets_title_color',
            'type' => 'color_picker',
            'instructions' => __('Select footer widgets title text color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_580538640ac50',
            'label' => __('Footer Text Color' , 'king' ),
            'name' => 'footer_text_color',
            'type' => 'color_picker',
            'instructions' => __('Select footer text color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_580539b0b8510',
            'label' => __('Footer links Color' , 'king' ),
            'name' => 'footer_link_color',
            'type' => 'color_picker',
            'instructions' => __('Select footer Links color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5ffdb1f80a7d8',
            'label' => __('Footer links hover' , 'king' ),
            'name' => 'footer_links_hover',
            'type' => 'color_picker',
            'instructions' => __('Select footer Links and Icons hover color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_58067d3fa81f9',
            'label' => __('Sidebar' , 'king' ),
            'name' => '',
            'type' => 'tab',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'left',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_58067d4ca81fa',
            'label' => __('Sidebar Widgets Title Background' , 'king' ),
            'name' => 'sidebar_widgets_title_background',
            'type' => 'color_picker',
            'instructions' => __('Select Sidebar Widgets Title Background Color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_58067d92a81fb',
            'label' => __('Sidebar Widgets Title Color' , 'king' ),
            'name' => 'sidebar_widgets_title_color',
            'type' => 'color_picker',
            'instructions' => __('Select Sidebar Widgets Title Text Color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5fb7a497408aa',
            'label' => __('Sidebar Posts Background' , 'king' ),
            'name' => 'sidebar_posts_background',
            'type' => 'color_picker',
            'instructions' => __('Select Sidebar Posts Background Color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5863f3a18f505',
            'label' => __('Sidebar Widgets Post Meta Text Color' , 'king' ),
            'name' => 'sidebar_widgets_post_meta_text_color',
            'type' => 'color_picker',
            'instructions' => __('Select Sidebar Widgets Post Meta Text Color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_58067db0a81fc',
            'label' => __('Sidebar Links Color' , 'king' ),
            'name' => 'sidebar_links',
            'type' => 'color_picker',
            'instructions' => __('Select Sidebar Links Color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_58067de5a81fd',
            'label' => __('Sidebar Text Color' , 'king' ),
            'name' => 'sidebar_text_color',
            'type' => 'color_picker',
            'instructions' => __('Select Sidebar Text Color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_581502c9f0f0b',
            'label' => __('Post Page' , 'king' ),
            'name' => '',
            'type' => 'tab',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'left',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_581502d4f0f0c',
            'label' => __('Post Content Background Color' , 'king' ),
            'name' => 'post_content_background_color',
            'type' => 'color_picker',
            'instructions' => __('Select post content background color in Post Page', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_581503a21d6cf',
            'label' => __('Post Content text color' , 'king' ),
            'name' => 'post_content_text_color',
            'type' => 'color_picker',
            'instructions' => __('Select post content text color in Post Page', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5872929b65c5d',
            'label' => __('Post favorite button background' , 'king' ),
            'name' => 'post_like_button_background',
            'type' => 'color_picker',
            'instructions' => __('Select post favorite button background color in Post Page', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_587292da65c5e',
            'label' => __('Post favorite button icon color' , 'king' ),
            'name' => 'post_like_button_icon_color',
            'type' => 'color_picker',
            'instructions' => __('Select post favorite button icon color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_60c651a050f2e',
            'label' => __('Post bookmark button background' , 'king' ),
            'name' => 'post_bookmark_button_background',
            'type' => 'color_picker',
            'instructions' => __('Select post bookmark button background color in Post Page', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_60c651a650f2f',
            'label' => __('Post bookmark button icon color' , 'king' ),
            'name' => 'post_bookmark_button_icon_color',
            'type' => 'color_picker',
            'instructions' => __('Select post bookmark button icon color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_60c65459946d7',
            'label' => __('Post share button background' , 'king' ),
            'name' => 'post_share_button_background',
            'type' => 'color_picker',
            'instructions' => __('Select post share button background color in Post Page', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_60c6545e946d8',
            'label' => __('Post share button icon color' , 'king' ),
            'name' => 'post_share_button_icon_color',
            'type' => 'color_picker',
            'instructions' => __('Select post share button icon color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_60c654fe946d9',
            'label' => __('Vote Count background' , 'king' ),
            'name' => 'vote_count_background',
            'type' => 'color_picker',
            'instructions' => __('Select Vote Count background color in Post Page', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_60c655bb946db',
            'label' => __('Vote count text color' , 'king' ),
            'name' => 'vote_count_text_color',
            'type' => 'color_picker',
            'instructions' => __('Select Vote Count text color in Post Page', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_60c65504946da',
            'label' => __('Vote icons color' , 'king' ),
            'name' => 'vote_icons_color',
            'type' => 'color_picker',
            'instructions' => __('Select post vote icons color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_60c6575143d43',
            'label' => __('Next-Prev posts bars background' , 'king' ),
            'name' => 'next-prev_posts_bars_background',
            'type' => 'color_picker',
            'instructions' => __('Select Next-Prev bar background color in post page', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_60c657b243d45',
            'label' => __('Next-Prev posts bars text color' , 'king' ),
            'name' => 'next-prev_posts_bars_text_color',
            'type' => 'color_picker',
            'instructions' => __('Select Next-Prev bars text color in post page', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5815057b54404',
            'label' => __('Post Author box background' , 'king' ),
            'name' => 'post_author_box_background',
            'type' => 'color_picker',
            'instructions' => __('Select post author box background color in post page', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5815061995480',
            'label' => __('Post Author box text color' , 'king' ),
            'name' => 'post_author_box_text_color',
            'type' => 'color_picker',
            'instructions' => __('Select post author box text color in post page', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_58164a8408681',
            'label' => __('Post Meta Background' , 'king' ),
            'name' => 'post_meta_background',
            'type' => 'color_picker',
            'instructions' => __('Select post meta background color in post page', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_58164ab1495b7',
            'label' => __('Post Meta Text Color' , 'king' ),
            'name' => 'post_meta_text_color',
            'type' => 'color_picker',
            'instructions' => __('Select post meta text and icons color in post page', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_587bde52c5bfe',
            'label' => __('Post page boxes background' , 'king' ),
            'name' => 'post_page_boxes_background',
            'type' => 'color_picker',
            'instructions' => __('Select post page boxes background color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_587bde85c5bff',
            'label' => __('Post page boxes title background' , 'king' ),
            'name' => 'post_page_boxes_title_background',
            'type' => 'color_picker',
            'instructions' => __('Select post page boxes title background color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_58cc4e71fa23c',
            'label' => __('Post page boxes title color' , 'king' ),
            'name' => 'post_page_boxes_title_color',
            'type' => 'color_picker',
            'instructions' => __('Select post page boxes title text color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_58729467dea0d',
            'label' => __('Comments area background color' , 'king' ),
            'name' => 'comments_area_background_color',
            'type' => 'color_picker',
            'instructions' => __('Select comments area background color in post page', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_587294b7dea0e',
            'label' => __('Comment box background' , 'king' ),
            'name' => 'comment_box_background',
            'type' => 'color_picker',
            'instructions' => __('Select comment box background color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_587294e3dea0f',
            'label' => __('Comment box text color' , 'king' ),
            'name' => 'comment_box_text_color',
            'type' => 'color_picker',
            'instructions' => __('Select comment box text color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_58729749cc217',
            'label' => __('Comments reply button background' , 'king' ),
            'name' => 'comments_reply_button_background',
            'type' => 'color_picker',
            'instructions' => __('Select comments reply button background color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5872978acc218',
            'label' => __('Comments reply button value color' , 'king' ),
            'name' => 'comments_reply_button_value_color',
            'type' => 'color_picker',
            'instructions' => __('Select comments reply button value color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5872984de6632',
            'label' => __('Comment Form Background' , 'king' ),
            'name' => 'comment_form_background',
            'type' => 'color_picker',
            'instructions' => __('Select Comment Form Background color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_58729871e6633',
            'label' => __('Comment Form Text Color' , 'king' ),
            'name' => 'comment_form_text_color',
            'type' => 'color_picker',
            'instructions' => __('Select Comment Form text color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_584b14ce5892e',
            'label' => __('Custom CSS' , 'king' ),
            'name' => '',
            'type' => 'tab',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'left',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_584b14e35892f',
            'label' => __('Custom Css' , 'king' ),
            'name' => 'custom_css',
            'type' => 'textarea',
            'instructions' => __('You can add your custom css code here ;', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '60',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'css code here',
            'maxlength' => '',
            'rows' => 24,
            'new_lines' => '',
        ),
        array(
            'key' => 'field_5fafb7824fb70',
            'label' => __('Kingflix Page' , 'king' ),
            'name' => '',
            'type' => 'tab',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'left',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_5fafb79e4fb71',
            'label' => __('Categories Title Color' , 'king' ),
            'name' => 'kingflix_categories_title_color',
            'type' => 'color_picker',
            'instructions' => __('categories title color in king flix page', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5fafb7ffd8271',
            'label' => __('Posts Background Color' , 'king' ),
            'name' => 'kingflix_posts_background',
            'type' => 'color_picker',
            'instructions' => __('posts background color in king flix page', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5fafb84fd8272',
            'label' => __('Posts Title color' , 'king' ),
            'name' => 'kingflix_posts_title_color',
            'type' => 'color_picker',
            'instructions' => __('posts title color in king flix page', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5fafb87ad8273',
            'label' => __('Post Buttons Colors' , 'king' ),
            'name' => 'kingflix_post_buttons_colors',
            'type' => 'color_picker',
            'instructions' => __('posts button colors in king flix page', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5fafb89cd8274',
            'label' => __('Post Meta Color' , 'king' ),
            'name' => 'kingflix_post_meta_color',
            'type' => 'color_picker',
            'instructions' => __('posts meta text color in king flix page', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5fb3ab76025fa',
            'label' => __('Quick View Background' , 'king' ),
            'name' => 'quick_view_background',
            'type' => 'color_picker',
            'instructions' => __('quick view modal background color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5fb3abbe025fb',
            'label' => __('Quick View Post Title' , 'king' ),
            'name' => 'quick_view_post_title',
            'type' => 'color_picker',
            'instructions' => __('quick view modal text color for title', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5fb3abe7025fc',
            'label' => __('Quick View Post Content' , 'king' ),
            'name' => 'quick_view_post_content',
            'type' => 'color_picker',
            'instructions' => __('quick view modal text color for content', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5fb3ac2c025fd',
            'label' => __('Quick View Widget Title' , 'king' ),
            'name' => 'quick_view_widget_title',
            'type' => 'color_picker',
            'instructions' => __('quick view modal widget title color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
    ),
    'location' => array(
        array(
            array(
                'param' => 'options_page',
                'operator' => '==',
                'value' => 'acf-options-customize',
            ),
        ),
    ),
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => true,
    'description' => '',
    'show_in_rest' => false,
));

acf_add_local_field_group(array(
    'key' => 'group_5aaadfdfcb26c',
    'title' => 'Extra Options',
    'fields' => array(
        array(
            'key' => 'field_5aaadfed91603',
            'label' => __('Color' , 'king' ),
            'name' => 'category_colors',
            'type' => 'color_picker',
            'instructions' => __('You can select a color for this', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5af35938f0413',
            'label' => __('Logo' , 'king' ),
            'name' => 'category_logo',
            'type' => 'image',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'return_format' => 'array',
            'preview_size' => 'thumbnail',
            'library' => 'uploadedTo',
            'min_width' => '',
            'min_height' => '',
            'min_size' => '',
            'max_width' => '',
            'max_height' => '',
            'max_size' => '',
            'mime_types' => 'jpg, png, gif, jpeg',
        ),
        array(
            'key' => 'field_5af35834f0412',
            'label' => __('Background Image' , 'king' ),
            'name' => 'category_background_image',
            'type' => 'image',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'return_format' => 'array',
            'preview_size' => 'thumbnail',
            'library' => 'uploadedTo',
            'min_width' => '',
            'min_height' => '',
            'min_size' => '',
            'max_width' => '',
            'max_height' => '',
            'max_size' => '',
            'mime_types' => 'jpg, png, gif, jpeg',
        ),
    ),
    'location' => array(
        array(
            array(
                'param' => 'taxonomy',
                'operator' => '==',
                'value' => 'category',
            ),
        ),
        array(
            array(
                'param' => 'taxonomy',
                'operator' => '==',
                'value' => 'post_tag',
            ),
        ),
    ),
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => true,
    'description' => '',
    'show_in_rest' => false,
));

acf_add_local_field_group(array(
    'key' => 'group_60ae46c60a552',
    'title' => 'Image Gallery',
    'fields' => array(
        array(
            'key' => 'field_60ae46d02f589',
            'label' => __('Images' , 'king' ),
            'name' => 'images_gallery',
            'type' => 'gallery',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => 'king-gallery-img',
                'id' => '',
            ),
            'return_format' => 'array',
            'preview_size' => 'thumbnail',
            'insert' => 'append',
            'library' => 'uploadedTo',
            'min' => 1,
            'max' => 30,
            'min_width' => '',
            'min_height' => '',
            'min_size' => '',
            'max_width' => '',
            'max_height' => '',
            'max_size' => 5,
            'mime_types' => 'jpg, jpeg, png, gif, webp',
        ),
    ),
    'location' => array(
        array(
            array(
                'param' => 'post_format',
                'operator' => '==',
                'value' => 'image',
            ),
        ),
    ),
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => true,
    'description' => '',
    'show_in_rest' => 0,
));

acf_add_local_field_group(array(
    'key' => 'group_5fb50168c5167',
    'title' => 'Kingflix settings',
    'fields' => array(
        array(
            'key' => 'field_5fb5017cb785d',
            'label' => __('Posts number in categories' , 'king' ),
            'name' => 'kingflix_posts_number_in_categories',
            'type' => 'number',
            'instructions' => __('show max posts in each categories', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 12,
            'placeholder' => '',
            'prepend' => 'number',
            'append' => '',
            'min' => 1,
            'max' => 150,
            'step' => '',
        ),
        array(
            'key' => 'field_5fb7a234b3ab5',
            'label' => __('Display Bookmarked Posts' , 'king' ),
            'name' => 'kingflix_display_bookmarked_posts',
            'type' => 'true_false',
            'instructions' => __('display bookmarked posts in kingflix page', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_5fb7a267b3ab6',
            'label' => __('Bookmarked Posts Header' , 'king' ),
            'name' => 'kingflix_bookmarked_posts_header',
            'type' => 'text',
            'instructions' => __('header for bookmarked posts in kingflix page', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5fb7a234b3ab5',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 'Watch Later',
            'placeholder' => '',
            'prepend' => 'title',
            'append' => '',
            'maxlength' => '',
        ),
        array(
            'key' => 'field_5fb50268e803c',
            'label' => __('Display Trending Posts' , 'king' ),
            'name' => 'kingflix_display_trending_posts',
            'type' => 'true_false',
            'instructions' => __('display trending posts in kingflix page', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_5fb506e28caaa',
            'label' => __('Trending Posts Header' , 'king' ),
            'name' => 'kingflix_trending_posts_header',
            'type' => 'text',
            'instructions' => __('header for trending posts in kingflix page', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5fb50268e803c',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 'Trending',
            'placeholder' => '',
            'prepend' => 'title',
            'append' => '',
            'maxlength' => '',
        ),
    ),
    'location' => array(
        array(
            array(
                'param' => 'page_template',
                'operator' => '==',
                'value' => 'king_page_kingflix.php',
            ),
        ),
    ),
    'menu_order' => 0,
    'position' => 'acf_after_title',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'field',
    'hide_on_screen' => '',
    'active' => true,
    'description' => '',
    'show_in_rest' => false,
));

acf_add_local_field_group(array(
    'key' => 'group_58bc8b259b335',
    'title' => 'Lists',
    'fields' => array(
        array(
            'key' => 'field_5a53c07ad0754',
            'label' => __('Lists' , 'king' ),
            'name' => '',
            'type' => 'tab',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'left',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_57daf9b9334ca',
            'label' => __('Length of Hot page' , 'king' ),
            'name' => 'length_hot',
            'type' => 'number',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 10,
            'placeholder' => 'max 50',
            'prepend' => 'Hot',
            'append' => '',
            'min' => 1,
            'max' => 50,
            'step' => '',
        ),
        array(
            'key' => 'field_57dafb25dd912',
            'label' => __('Length of Trend page' , 'king' ),
            'name' => 'length_trend',
            'type' => 'number',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 10,
            'placeholder' => 'max 50',
            'prepend' => 'Trend',
            'append' => '',
            'min' => 1,
            'max' => 50,
            'step' => '',
        ),
        array(
            'key' => 'field_57dafc37a5570',
            'label' => __('Length of NSFW page' , 'king' ),
            'name' => 'length_nsfw',
            'type' => 'number',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 10,
            'placeholder' => 'max 50',
            'prepend' => 'NSFW',
            'append' => '',
            'min' => 1,
            'max' => 50,
            'step' => '',
        ),
        array(
            'key' => 'field_5903b3a8d050f',
            'label' => __('Length of Reactions page' , 'king' ),
            'name' => 'length_reaction',
            'type' => 'number',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 10,
            'placeholder' => 'max 50',
            'prepend' => 'Reactions',
            'append' => '',
            'min' => 1,
            'max' => 50,
            'step' => '',
        ),
        array(
            'key' => 'field_5817b2fb6b637',
            'label' => __('Length of Users Dashboard' , 'king' ),
            'name' => 'length_of_users_dashboard',
            'type' => 'number',
            'instructions' => __('Length of Following Users Posts in Dashboard Page', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 10,
            'placeholder' => 'max 50',
            'prepend' => 'Posts',
            'append' => '',
            'min' => 1,
            'max' => 50,
            'step' => '',
        ),
        array(
            'key' => 'field_57dafbcf93901',
            'label' => __('Length of Users Page' , 'king' ),
            'name' => 'length_users',
            'type' => 'number',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 10,
            'placeholder' => 'max 50',
            'prepend' => 'Users',
            'append' => '',
            'min' => 1,
            'max' => 50,
            'step' => '',
        ),
        array(
            'key' => 'field_5814fc5ee9ded',
            'label' => __('Length of Followers' , 'king' ),
            'name' => 'length_of_followers',
            'type' => 'number',
            'instructions' => __('Length of followers in profile page', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 10,
            'placeholder' => 'max 50',
            'prepend' => 'Users',
            'append' => '',
            'min' => 1,
            'max' => 50,
            'step' => '',
        ),
        array(
            'key' => 'field_5814fc80e9dee',
            'label' => __('Length of Following Users' , 'king' ),
            'name' => 'length_of_following',
            'type' => 'number',
            'instructions' => __('Length of Following Users in profile page', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 10,
            'placeholder' => 'max 50',
            'prepend' => 'Users',
            'append' => '',
            'min' => 1,
            'max' => 50,
            'step' => '',
        ),
        array(
            'key' => 'field_58150087dea82',
            'label' => __('Length of Posts in Profile' , 'king' ),
            'name' => 'length_of_posts_in_profile',
            'type' => 'number',
            'instructions' => __('Length of User\'s posts in profile page', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 10,
            'placeholder' => 'max 50',
            'prepend' => 'Posts',
            'append' => '',
            'min' => 1,
            'max' => 50,
            'step' => '',
        ),
        array(
            'key' => 'field_58150123c274f',
            'label' => __('Length of user\'s favorited posts' , 'king' ),
            'name' => 'length_of_users_liked_posts',
            'type' => 'number',
            'instructions' => __('Length of User\'s favorited posts in profile page', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 10,
            'placeholder' => 'max 50',
            'prepend' => 'Posts',
            'append' => '',
            'min' => 1,
            'max' => 50,
            'step' => '',
        ),
        array(
            'key' => 'field_5a53c092d0755',
            'label' => __('Badges' , 'king' ),
            'name' => '',
            'type' => 'tab',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'left',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_5a53c0da450b0',
            'label' => __('Enable User Badges' , 'king' ),
            'name' => 'enable_user_badges',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Enable Badges for Users', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_5a5682dbc9aa0',
            'label' => __('Enable Leaderboard Badges' , 'king' ),
            'name' => 'enable_leaderboard_badges',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5a53c0da450b0',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Enable Leaderboard Badges Based Points', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_5a567199e3d3d',
            'label' => __('Leaderboard Badges' , 'king' ),
            'name' => 'leaderboard_badges',
            'type' => 'repeater',
            'instructions' => __('You can add max. 10 badges. Rank badges by leaderboard.', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5a5682dbc9aa0',
                        'operator' => '==',
                        'value' => '1',
                    ),
                    array(
                        'field' => 'field_5a53c0da450b0',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'collapsed' => '',
            'min' => 0,
            'max' => 10,
            'layout' => 'table',
            'button_label' => 'New Badge for Leaderboard',
            'sub_fields' => array(
                array(
                    'key' => 'field_5a56757220005',
                    'label' => __('Leaderboard Badge Title' , 'king' ) ,
                    'name' => 'leaderboard_badge_title',
                    'type' => 'text',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '50',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'placeholder' => '',
                    'prepend' => 'Title',
                    'append' => '',
                    'maxlength' => 50,
                ),
                array(
                    'key' => 'field_5a56759520006',
                    'label' => __('Leaderboard Badge Icon' , 'king' ) ,
                    'name' => 'leaderboard_badge_icon',
                    'type' => 'image',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '50',
                        'class' => '',
                        'id' => '',
                    ),
                    'return_format' => 'url',
                    'preview_size' => 'thumbnail',
                    'library' => 'uploadedTo',
                    'min_width' => '',
                    'min_height' => '',
                    'min_size' => '',
                    'max_width' => '',
                    'max_height' => '',
                    'max_size' => '',
                    'mime_types' => '',
                ),
            ),
        ),
        array(
            'key' => 'field_5a53c1327f005',
            'label' => __('King Badges' , 'king' ),
            'name' => 'king_badges',
            'type' => 'flexible_content',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5a53c0da450b0',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'layouts' => array(
                '5a53c156ae608' => array(
                    'key' => '5a53c156ae608' ,
                    'name' => 'badges_for_points',
                    'label' => __('Badges For Points', 'king' ),
                    'display' => 'table',
                    'sub_fields' => array(
                        array(
                            'key' => 'field_5a53c2c77f008',
                            'label' => __('Badge Icon', 'king' ),
                            'name' => 'badge_icon',
                            'type' => 'image',
                            
                            'required' => 1,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '20',
                                'class' => '',
                                'id' => '',
                            ),
                            'return_format' => 'url',
                            'preview_size' => 'thumbnail',
                            'library' => 'uploadedTo',
                            'min_width' => '',
                            'min_height' => '',
                            'min_size' => '',
                            'max_width' => '',
                            'max_height' => '',
                            'max_size' => 10,
                            'mime_types' => '',
                        ),
                        array(
                            'key' => 'field_5a53c26b7f007',
                            'label' => __('Badge Min. Point', 'king' ),
                            'name' => 'badge_min_point',
                            'type' => 'number',
                            
                            'required' => 1,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '15',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'placeholder' => '',
                            'prepend' => 'Min',
                            'append' => '',
                            'min' => 0,
                            'max' => '',
                            'step' => '',
                        ),
                        array(
                            'key' => 'field_5a55dc50522c9',
                            'label' => __('Badge Max. Point', 'king' ),
                            'name' => 'badge_max_point',
                            'type' => 'number',
                            
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '15',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'placeholder' => '',
                            'prepend' => 'Max',
                            'append' => '',
                            'min' => 0,
                            'max' => '',
                            'step' => '',
                        ),
                        array(
                            'key' => 'field_5a53c21c7f006',
                            'label' => __('Badge Title', 'king' ),
                            'name' => 'badge_title',
                            'type' => 'text',
                            
                            'required' => 1,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '20',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'placeholder' => '',
                            'prepend' => 'Text',
                            'append' => '',
                            'maxlength' => 50,
                        ),
                        array(
                            'key' => 'field_5a5469ee905b9',
                            'label' => __('Badge Description', 'king' ),
                            'name' => 'badge_description',
                            'type' => 'textarea',
                            'instructions' => __('( optional )', 'king' ) ,
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '30',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'placeholder' => '',
                            'maxlength' => '',
                            'rows' => 4,
                            'new_lines' => '',
                        ),
                    ),
                    'min' => '',
                    'max' => '',
                ),
                '5a55ddc8a356a' => array(
                    'key' => '5a55ddc8a356a' ,
                    'name' => 'badges_for_followers',
                    'label' => __('Badges For Followers', 'king' ),
                    'display' => 'table',
                    'sub_fields' => array(
                        array(
                            'key' => 'field_5a55ddc8a356c',
                            'label' => __('Badge Min. Followers', 'king' ),
                            'name' => 'badge_min_point',
                            'type' => 'number',
                            
                            'required' => 1,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '15',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'placeholder' => '',
                            'prepend' => 'Min',
                            'append' => '',
                            'min' => 0,
                            'max' => '',
                            'step' => '',
                        ),
                        array(
                            'key' => 'field_5a55ddc8a356d',
                            'label' => __('Badge Max. Followers', 'king' ),
                            'name' => 'badge_max_point',
                            'type' => 'number',
                            
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '15',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'placeholder' => '',
                            'prepend' => 'Max',
                            'append' => '',
                            'min' => 0,
                            'max' => '',
                            'step' => '',
                        ),
                        array(
                            'key' => 'field_5a55ddc8a356e',
                            'label' => __('Badge Title', 'king' ),
                            'name' => 'badge_title',
                            'type' => 'text',
                            
                            'required' => 1,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '20',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'placeholder' => '',
                            'prepend' => 'Text',
                            'append' => '',
                            'maxlength' => 50,
                        ),
                        array(
                            'key' => 'field_5a55ddc8a356f',
                            'label' => __('Badge Description', 'king' ),
                            'name' => 'badge_description',
                            'type' => 'textarea',
                            'instructions' => __('( optional )', 'king' ) ,
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '30',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'placeholder' => '',
                            'maxlength' => '',
                            'rows' => 4,
                            'new_lines' => '',
                        ),
                        array(
                            'key' => 'field_5a55ddc8a356b',
                            'label' => __('Badge Icon', 'king' ),
                            'name' => 'badge_icon',
                            'type' => 'image',
                            
                            'required' => 1,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '20',
                                'class' => '',
                                'id' => '',
                            ),
                            'return_format' => 'url',
                            'preview_size' => 'thumbnail',
                            'library' => 'uploadedTo',
                            'min_width' => '',
                            'min_height' => '',
                            'min_size' => '',
                            'max_width' => '',
                            'max_height' => '',
                            'max_size' => 10,
                            'mime_types' => '',
                        ),
                    ),
                    'min' => '',
                    'max' => '',
                ),
                '5a55ddd9a3570' => array(
                    'key' => '5a55ddd9a3570' ,
                    'name' => 'badges_for_posts',
                    'label' => __('Badges For Posts', 'king' ),
                    'display' => 'table',
                    'sub_fields' => array(
                        array(
                            'key' => 'field_5a55ddd9a3572',
                            'label' => __('Badge Min. Posts', 'king' ),
                            'name' => 'badge_min_point',
                            'type' => 'number',
                            
                            'required' => 1,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '15',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'placeholder' => '',
                            'prepend' => 'Min',
                            'append' => '',
                            'min' => 0,
                            'max' => '',
                            'step' => '',
                        ),
                        array(
                            'key' => 'field_5a55ddd9a3573',
                            'label' => __('Badge Max. Posts', 'king' ),
                            'name' => 'badge_max_point',
                            'type' => 'number',
                            
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '15',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'placeholder' => '',
                            'prepend' => 'Max',
                            'append' => '',
                            'min' => 0,
                            'max' => '',
                            'step' => '',
                        ),
                        array(
                            'key' => 'field_5a55ddd9a3574',
                            'label' => __('Badge Title', 'king' ),
                            'name' => 'badge_title',
                            'type' => 'text',
                            
                            'required' => 1,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '20',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'placeholder' => '',
                            'prepend' => 'Text',
                            'append' => '',
                            'maxlength' => 50,
                        ),
                        array(
                            'key' => 'field_5a55ddd9a3575',
                            'label' => __('Badge Description', 'king' ),
                            'name' => 'badge_description',
                            'type' => 'textarea',
                            'instructions' => __('( optional )', 'king' ) ,
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '30',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'placeholder' => '',
                            'maxlength' => '',
                            'rows' => 4,
                            'new_lines' => '',
                        ),
                        array(
                            'key' => 'field_5a55ddd9a3571',
                            'label' => __('Badge Icon', 'king' ),
                            'name' => 'badge_icon',
                            'type' => 'image',
                            
                            'required' => 1,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '20',
                                'class' => '',
                                'id' => '',
                            ),
                            'return_format' => 'url',
                            'preview_size' => 'thumbnail',
                            'library' => 'uploadedTo',
                            'min_width' => '',
                            'min_height' => '',
                            'min_size' => '',
                            'max_width' => '',
                            'max_height' => '',
                            'max_size' => 10,
                            'mime_types' => '',
                        ),
                    ),
                    'min' => '',
                    'max' => '',
                ),
                '5a55ddeca3576' => array(
                    'key' => '5a55ddeca3576' , 'king' ) ,
                    'name' => 'badges_for_comments',
                    'label' => __('Badges For Comments', 'king' ),
                    'display' => 'table',
                    'sub_fields' => array(
                        array(
                            'key' => 'field_5a55ddeca3578',
                            'label' => __('Badge Min. Comments', 'king' ),
                            'name' => 'badge_min_point',
                            'type' => 'number',
                            
                            'required' => 1,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '15',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'placeholder' => '',
                            'prepend' => 'Min',
                            'append' => '',
                            'min' => 0,
                            'max' => '',
                            'step' => '',
                        ),
                        array(
                            'key' => 'field_5a55ddeca3579',
                            'label' => __('Badge Max. Comments', 'king' ),
                            'name' => 'badge_max_point',
                            'type' => 'number',
                            
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '15',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'placeholder' => '',
                            'prepend' => 'Max',
                            'append' => '',
                            'min' => 0,
                            'max' => '',
                            'step' => '',
                        ),
                        array(
                            'key' => 'field_5a55ddeca357a',
                            'label' => __('Badge Title', 'king' ),
                            'name' => 'badge_title',
                            'type' => 'text',
                            
                            'required' => 1,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '20',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'placeholder' => '',
                            'prepend' => 'Text',
                            'append' => '',
                            'maxlength' => 50,
                        ),
                        array(
                            'key' => 'field_5a55ddeca357b',
                            'label' => __('Badge Description', 'king' ),
                            'name' => 'badge_description',
                            'type' => 'textarea',
                            'instructions' => __('( optional )', 'king' ) ,
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '30',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'placeholder' => '',
                            'maxlength' => '',
                            'rows' => 4,
                            'new_lines' => '',
                        ),
                        array(
                            'key' => 'field_5a55ddeca3577',
                            'label' => __('Badge Icon', 'king' ),
                            'name' => 'badge_icon',
                            'type' => 'image',
                            
                            'required' => 1,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '20',
                                'class' => '',
                                'id' => '',
                            ),
                            'return_format' => 'url',
                            'preview_size' => 'thumbnail',
                            'library' => 'all',
                            'min_width' => '',
                            'min_height' => '',
                            'min_size' => '',
                            'max_width' => '',
                            'max_height' => '',
                            'max_size' => 10,
                            'mime_types' => '',
                        ),
                    ),
                    'min' => '',
                    'max' => '',
                ),
                '5a55de08a357c' => array(
                    'key' => '5a55de08a357c' , 'king' ) ,
                    'name' => 'badges_for_likes',
                    'label' => __('Badges For Likes', 'king' ),
                    'display' => 'table',
                    'sub_fields' => array(
                        array(
                            'key' => 'field_5a55de08a357e',
                            'label' => __('Badge Min. Likes', 'king' ),
                            'name' => 'badge_min_point',
                            'type' => 'number',
                            
                            'required' => 1,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '15',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'placeholder' => '',
                            'prepend' => 'Min',
                            'append' => '',
                            'min' => 0,
                            'max' => '',
                            'step' => '',
                        ),
                        array(
                            'key' => 'field_5a55de08a357f',
                            'label' => __('Badge Max. Likes', 'king' ),
                            'name' => 'badge_max_point',
                            'type' => 'number',
                            
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '15',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'placeholder' => '',
                            'prepend' => 'Max',
                            'append' => '',
                            'min' => 0,
                            'max' => '',
                            'step' => '',
                        ),
                        array(
                            'key' => 'field_5a55de08a3580',
                            'label' => __('Badge Title', 'king' ),
                            'name' => 'badge_title',
                            'type' => 'text',
                            
                            'required' => 1,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '20',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'placeholder' => '',
                            'prepend' => 'Text',
                            'append' => '',
                            'maxlength' => 50,
                        ),
                        array(
                            'key' => 'field_5a55de08a3581',
                            'label' => __('Badge Description', 'king' ),
                            'name' => 'badge_description',
                            'type' => 'textarea',
                            'instructions' => __('( optional )', 'king' ) ,
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '30',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'placeholder' => '',
                            'maxlength' => '',
                            'rows' => 4,
                            'new_lines' => '',
                        ),
                        array(
                            'key' => 'field_5a55de08a357d',
                            'label' => __('Badge Icon', 'king' ),
                            'name' => 'badge_icon',
                            'type' => 'image',
                            
                            'required' => 1,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '20',
                                'class' => '',
                                'id' => '',
                            ),
                            'return_format' => 'url',
                            'preview_size' => 'thumbnail',
                            'library' => 'uploadedTo',
                            'min_width' => '',
                            'min_height' => '',
                            'min_size' => '',
                            'max_width' => '',
                            'max_height' => '',
                            'max_size' => 10,
                            'mime_types' => '',
                        ),
                    ),
                    'min' => '',
                    'max' => '',
        ),
        array(
            'key' => 'field_5a5e621f2c193',
            'label' => __('User Points' , 'king' ),
            'name' => '',
            'type' => 'tab',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'top',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_5a5e62c52c195',
            'label' => __('Enable User Points' , 'king' ),
            'name' => 'enable_user_points',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Enable User Points Option', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_5a5e62ef2c196',
            'label' => __('Submitting a post' , 'king' ),
            'name' => 'submitting_a_post',
            'type' => 'number',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5a5e62c52c195',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 1,
            'placeholder' => '',
            'prepend' => 'points',
            'append' => '',
            'min' => '',
            'max' => '',
            'step' => '',
        ),
        array(
            'key' => 'field_5a5e631d2c197',
            'label' => __('Get a follower' , 'king' ),
            'name' => 'get_a_follower',
            'type' => 'number',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5a5e62c52c195',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 1,
            'placeholder' => '',
            'prepend' => 'points',
            'append' => '',
            'min' => '',
            'max' => '',
            'step' => '',
        ),
        array(
            'key' => 'field_5a5e632b2c198',
            'label' => __('Posting a comment' , 'king' ),
            'name' => 'posting_a_comment',
            'type' => 'number',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5a5e62c52c195',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 1,
            'placeholder' => '',
            'prepend' => 'points',
            'append' => '',
            'min' => '',
            'max' => '',
            'step' => '',
        ),
        array(
            'key' => 'field_5e73768fc9cac',
            'label' => __('User Groups' , 'king' ),
            'name' => '',
            'type' => 'tab',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'left',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_5e83b43e385ce',
            'label' => __('Enable User Groups' , 'king' ),
            'name' => 'enable_user_groups',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_5e7376a3c9cad',
            'label' => __('User Groups' , 'king' ),
            'name' => 'user_groups',
            'type' => 'repeater',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5e83b43e385ce',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '100',
                'class' => '',
                'id' => '',
            ),
            'collapsed' => '',
            'min' => 0,
            'max' => 0,
            'layout' => 'block',
            'button_label' => 'New Group',
            'sub_fields' => array(
                array(
                    'key' => 'field_5e73772dc9cae',
                    'label' => __('Group name' , 'king' ) ,
                    'name' => 'group_name',
                    'type' => 'text',
                    'instructions' => __('Name of this group', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '25',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'placeholder' => '',
                    'prepend' => 'Name',
                    'append' => '',
                    'maxlength' => 50,
                ),
                array(
                    'key' => 'field_5e737766c9caf',
                    'label' => __('Group Color' , 'king' ) ,
                    'name' => 'group_color',
                    'type' => 'color_picker',
                    'instructions' => __('Bckground Color', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '20',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'enable_opacity' => false,
                    'return_format' => 'string',
                ),
                array(
                    'key' => 'field_5e73778dc9cb0',
                    'label' => __('Group Icon' , 'king' ) ,
                    'name' => 'group_icon',
                    'type' => 'text',
                    'instructions' => __('Select <a href="https://fontawesome.com/icons?m=free" target="_blank">FontAwesome</a> icon code', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '32',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'placeholder' => '<i class="fas fa-crown"></i>',
                    'prepend' => 'icon',
                    'append' => '',
                    'maxlength' => '',
                ),
                array(
                    'key' => 'field_5e7379b1cccd4',
                    'label' => __('Default for new users' , 'king' ) ,
                    'name' => 'default_group_for_new_users',
                    'type' => 'true_false',
                    'instructions' => __('set as default for new users', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '23',
                        'class' => '',
                        'id' => '',
                    ),
                            'default_value' => 0,
                    'ui' => 1,
                    'ui_on_text' => '',
                    'ui_off_text' => '',
                ),
                array(
                    'key' => 'field_5e865379a58e8',
                    'label' => __('Group Users' , 'king' ) ,
                    'name' => 'group_users',
                    'type' => 'select',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '100',
                        'class' => '',
                        'id' => '',
                    ),
                    'choices' => array(
                        1 => 'admin',
                        3 => 'korkmaz',
                        2 => 'korkut',
                    ),
                    'default_value' => array(
                    ),
                    'allow_null' => 1,
                    'multiple' => 1,
                    'ui' => 1,
                    'ajax' => 1,
                    'return_format' => 'value',
                    'placeholder' => '',
                ),
            ),
        ),
        array(
            'key' => 'field_5e83b40e8884f',
            'label' => __('Group Permissions' , 'king' ),
            'name' => '',
            'type' => 'tab',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5e83b43e385ce',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'left',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_5e83c6c67829c',
            'label' => __('Create posts' , 'king' ),
            'name' => 'groups_create_posts',
            'type' => 'checkbox',
            'instructions' => __('Only these group users will be able to create post', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array(
                'king' => '<span class="group-icon" title="king" style="background-color: #0a0a0a;"><i class="fas fa-crown"></i>king</span>',
            ),
            'allow_custom' => 0,
            'default_value' => array(
            ),
            'layout' => 'horizontal',
            'toggle' => 0,
            'return_format' => 'value',
            'save_custom' => 0,
        ),
        array(
            'key' => 'field_5e84bcb207b30',
            'label' => __('Create posts without approval' , 'king' ),
            'name' => 'groups_create_posts_without_approval',
            'type' => 'checkbox',
            'instructions' => __('These group users will be able to create post without approval', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array(
                'king' => '<span class="group-icon" title="king" style="background-color: #0a0a0a;"><i class="fas fa-crown"></i>king</span>',
            ),
            'allow_custom' => 0,
            'default_value' => array(
            ),
            'layout' => 'horizontal',
            'toggle' => 0,
            'return_format' => 'value',
            'save_custom' => 0,
        ),
        array(
            'key' => 'field_5e84bec25347b',
            'label' => __('Edit their own posts' , 'king' ),
            'name' => 'groups_edit_their_own_posts',
            'type' => 'checkbox',
            'instructions' => __('These group users will be able to edit their posts', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array(
                'king' => '<span class="group-icon" title="king" style="background-color: #0a0a0a;"><i class="fas fa-crown"></i>king</span>',
            ),
            'allow_custom' => 0,
            'default_value' => array(
            ),
            'layout' => 'horizontal',
            'toggle' => 0,
            'return_format' => 'value',
            'save_custom' => 0,
        ),
        array(
            'key' => 'field_5e8e0884d1346',
            'label' => __('View posts' , 'king' ),
            'name' => 'groups_view_posts',
            'type' => 'checkbox',
            'instructions' => __('Only these group users will be able to see posts', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array(
                'king' => '<span class="group-icon" title="king" style="background-color: #0a0a0a;"><i class="fas fa-crown"></i>king</span>',
            ),
            'allow_custom' => 0,
            'default_value' => array(
            ),
            'layout' => 'horizontal',
            'toggle' => 0,
            'return_format' => 'value',
            'save_custom' => 0,
        ),
        array(
            'key' => 'field_5e922736085be',
            'label' => __('Write comments' , 'king' ),
            'name' => 'groups_write_comments',
            'type' => 'checkbox',
            'instructions' => __('These group users will be able to write comments to posts', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array(
                'king' => '<span class="group-icon" title="king" style="background-color: #0a0a0a;"><i class="fas fa-crown"></i>king</span>',
            ),
            'allow_custom' => 0,
            'default_value' => array(
            ),
            'layout' => 'horizontal',
            'toggle' => 0,
            'return_format' => 'value',
            'save_custom' => 0,
        ),
        array(
            'key' => 'field_5fd0d91ddd097',
            'label' => __('Membership' , 'king' ),
            'name' => '',
            'type' => 'tab',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'left',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_5fd0d93cdd098',
            'label' => __('Enable Membership' , 'king' ),
            'name' => 'enable_membership',
            'type' => 'true_false',
            'instructions' => __('Enable membership for your page. Required <strong>WooCommerce Plugin</strong> to use this feature.', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_5fe869e5f0de7',
            'label' => __('Membership Icon' , 'king' ),
            'name' => 'membership_icon',
            'type' => 'text',
            'instructions' => __('Select <a href="https://fontawesome.com/icons?m=free" target="_blank">FontAwesome</a> icon code', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5fd0d93cdd098',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '<i class="fas fa-fingerprint"></i>',
            'placeholder' => '',
            'prepend' => 'icon',
            'append' => '',
            'maxlength' => '',
        ),
        array(
            'key' => 'field_5fe868ed022ac',
            'label' => __('Restricted Post Title' , 'king' ),
            'name' => 'restricted_post_title',
            'type' => 'text',
            'instructions' => __('title for restricted posts', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5fd0d93cdd098',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 'This post is for premium members.',
            'placeholder' => '',
            'prepend' => 'title',
            'append' => '',
            'maxlength' => '',
        ),
        array(
            'key' => 'field_5fe86a6df0de9',
            'label' => __('Restricted Post Description' , 'king' ),
            'name' => 'restricted_post_description',
            'type' => 'textarea',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5fd0d93cdd098',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 'Let\'s buy a plan.',
            'placeholder' => '',
            'maxlength' => '',
            'rows' => 3,
            'new_lines' => '',
        ),
        array(
            'key' => 'field_5ffda525a7d38',
            'label' => __('Membership Icon Title' , 'king' ),
            'name' => 'membership_icon_title',
            'type' => 'text',
            'instructions' => __('Profile membership icon title', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5fd0d93cdd098',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 'Premium',
            'placeholder' => '',
            'prepend' => 'title',
            'append' => '',
            'maxlength' => '',
        ),
        array(
            'key' => 'field_5fe86af2d3783',
            'label' => __('Restricted Post Button Value' , 'king' ),
            'name' => 'restricted_post_button_value',
            'type' => 'text',
            'instructions' => __('button value text', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5fd0d93cdd098',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 'See All Plans',
            'placeholder' => '',
            'prepend' => 'button',
            'append' => '',
            'maxlength' => '',
        ),
        array(
            'key' => 'field_61b8c36143d1c',
            'label' => __('Flags' , 'king' ),
            'name' => '',
            'type' => 'tab',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'left',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_61b8c37443d1d',
            'label' => __('Enable flags for posts' , 'king' ),
            'name' => 'enable_flags_for_posts',
            'type' => 'true_false',
            'instructions' => __('enable flags for posts and users can report posts', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_61b8c3c343d1e',
            'label' => __('Enable flags for comments' , 'king' ),
            'name' => 'enable_flags_for_comments',
            'type' => 'true_false',
            'instructions' => __('enable flags for comments and users can report them', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_61b8c45443d1f',
            'label' => __('Hide posts' , 'king' ),
            'name' => 'hide_posts_flag',
            'type' => 'true_false',
            'instructions' => __('Hide posts after certain number of flags', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_61b8c37443d1d',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
                array(
                    array(
                        'field' => 'field_61b8c3c343d1e',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_61b8c4f543d21',
            'label' => __('Hide after this amount' , 'king' ),
            'name' => 'hide_after_this_amount',
            'type' => 'number',
            'instructions' => __('hide posts or comments after this number of flags', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_61b8c45443d1f',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 15,
            'placeholder' => '',
            'prepend' => 'flags',
            'append' => '',
            'min' => '',
            'max' => 200,
            'step' => '',
        ),
    ),
    'location' => array(
        array(
            array(
                'param' => 'options_page',
                'operator' => '==',
                'value' => 'acf-options-lists',
            ),
        ),
    ),
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => true,
    'description' => '',
    'show_in_rest' => 0,
));

acf_add_local_field_group(array(
    'key' => 'group_6196417bbcc9e',
    'title' => 'Mega Menu',
    'fields' => array(
        array(
            'key' => 'field_61964183f0755',
            'label' => __('Enable Mega Menu' , 'king' ),
            'name' => 'enable_mega_menu',
            'type' => 'true_false',
            'instructions' => __('Enable mega menu and show posts.', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' ( only available for categories and tags ! )', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
    ),
    'location' => array(
        array(
            array(
                'param' => 'nav_menu_item',
                'operator' => '==',
                'value' => 'location/header-nav',
            ),
        ),
    ),
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => true,
    'description' => '',
    'show_in_rest' => 0,
));

acf_add_local_field_group(array(
    'key' => 'group_5c9bdc5f829e9',
    'title' => 'Menus',
    'fields' => array(
        array(
            'key' => 'field_5c9bdc62674dd',
            'label' => __('Add Badge To Menu' , 'king' ),
            'name' => 'add_badge_to_menu',
            'type' => 'true_false',
            'instructions' => __('you can add badge to menu items', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_5c9bdc83674de',
            'label' => __('Badge Text' , 'king' ),
            'name' => 'menu_badge_text',
            'type' => 'text',
            'instructions' => __('you can add badge to menu items', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5c9bdc62674dd',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'New!',
            'prepend' => 'text',
            'append' => '',
            'maxlength' => '',
        ),
        array(
            'key' => 'field_5c9bdcbc674df',
            'label' => __('Badge Background Color' , 'king' ),
            'name' => 'menu_badge_background_color',
            'type' => 'color_picker',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5c9bdc62674dd',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_60bfbf2ba014f',
            'label' => __('Add Icon to Menu' , 'king' ),
            'name' => 'add_icon_to_menu',
            'type' => 'true_false',
            'instructions' => __('you can add icons before the menu item title', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_60bfbf53a0150',
            'label' => __('Menu item icon' , 'king' ),
            'name' => 'menu_item_icon',
            'type' => 'text',
            'instructions' => __('Supporting FontAwesome icons, you can select the icons <a href="https://fontawesome.com/icons" target="_blank">Here</a>', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_60bfbf2ba014f',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '<i class="far fa-circle"></i>',
            'prepend' => 'Icon',
            'append' => '',
            'maxlength' => '',
        ),
        array(
            'key' => 'field_60bfbf5aa0151',
            'label' => __('Menu item icon color' , 'king' ),
            'name' => 'menu_item_icon_color',
            'type' => 'color_picker',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_60bfbf2ba014f',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
    ),
    'location' => array(
        array(
            array(
                'param' => 'nav_menu_item',
                'operator' => '==',
                'value' => 'all',
            ),
        ),
    ),
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => true,
    'description' => '',
    'show_in_rest' => false,
));

acf_add_local_field_group(array(
    'key' => 'group_61dd8ed6800f7',
    'title' => 'Page Template',
    'fields' => array(
        array(
            'key' => 'field_61dd8edfd4b33',
            'label' => __('' , 'king' ),
            'name' => 'page_template',
            'type' => 'group',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'layout' => 'block',
            'sub_fields' => array(
                array(
                    'key' => 'field_61dd8f09d4b34',
                    'label' => __('Sidebar' , 'king' ) ,
                    'name' => 'sidebar',
                    'type' => 'radio',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => 'radio-flex',
                        'id' => '',
                    ),
                    'choices' => array(
                        'king-sidebar-01' => '<img src="../wp-content/themes/king/layouts/imgs/templates/sidebar/sidebar-01.svg" height="127" width="127" />',
                        'king-sidebar-02' => '<img src="../wp-content/themes/king/layouts/imgs/templates/sidebar/sidebar-02.svg" height="127" width="127" />',
                        'king-sidebar-03' => '<img src="../wp-content/themes/king/layouts/imgs/templates/sidebar/sidebar-03.svg" height="127" width="127" />',
                        'king-sidebar-05' => '<img src="../wp-content/themes/king/layouts/imgs/templates/sidebar/sidebar-05.svg" height="127" width="127" />',
                        'king-sidebar-04' => '<img src="../wp-content/themes/king/layouts/imgs/templates/sidebar/sidebar-04.svg" height="127" width="127" />',
                    ),
                    'allow_null' => 1,
                    'other_choice' => 0,
                    'default_value' => '',
                    'layout' => 'horizontal',
                    'return_format' => 'value',
                    'save_other_choice' => 0,
                ),
                array(
                    'key' => 'field_61dd8f21d4b35',
                    'label' => __('Column' , 'king' ) ,
                    'name' => 'column',
                    'type' => 'radio',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => 'radio-flex',
                        'id' => '',
                    ),
                    'choices' => array(
                        'king-column-02' => '<img src="../wp-content/themes/king/layouts/imgs/templates/column/column-02.svg" height="80" width="127" />',
                        'king-column-03' => '<img src="../wp-content/themes/king/layouts/imgs/templates/column/column-03.svg" height="80" width="127" />',
                        'king-column-04' => '<img src="../wp-content/themes/king/layouts/imgs/templates/column/column-04.svg" height="80" width="127" />',
                        'king-column-05' => '<img src="../wp-content/themes/king/layouts/imgs/templates/column/column-05.svg" height="80" width="127" />',
                    ),
                    'allow_null' => 1,
                    'other_choice' => 0,
                    'default_value' => '',
                    'layout' => 'horizontal',
                    'return_format' => 'value',
                    'save_other_choice' => 0,
                ),
            ),
        ),
    ),
    'location' => array(
        array(
            array(
                'param' => 'page_template',
                'operator' => '==',
                'value' => 'king_page_hot.php',
            ),
        ),
        array(
            array(
                'param' => 'page_template',
                'operator' => '==',
                'value' => 'king_page_nsfw.php',
            ),
        ),
        array(
            array(
                'param' => 'page_template',
                'operator' => '==',
                'value' => 'king_page_reactions.php',
            ),
        ),
        array(
            array(
                'param' => 'page_template',
                'operator' => '==',
                'value' => 'king_page_trend.php',
            ),
        ),
    ),
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => true,
    'description' => '',
    'show_in_rest' => 0,
));

acf_add_local_field_group(array(
    'key' => 'group_609eb489bc7c6',
    'title' => 'poll',
    'fields' => array(
        array(
            'key' => 'field_609eb497417b5',
            'label' => __('Poll' , 'king' ),
            'name' => 'king_poll',
            'type' => 'repeater',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => 'king-repeater',
                'id' => '',
            ),
            'collapsed' => 'field_609eb5aa417b7',
            'min' => 1,
            'max' => 50,
            'layout' => 'block',
            'button_label' => 'Add New',
            'sub_fields' => array(
                array(
                    'key' => 'field_609eb5aa417b7',
                    'label' => __('Question' , 'king' ) ,
                    'name' => 'poll_title',
                    'type' => 'text',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_609eb628417b8',
                                'operator' => '!=',
                                'value' => '1',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'placeholder' => 'Question',
                    'prepend' => '',
                    'append' => '',
                    'maxlength' => 400,
                ),
                array(
                    'key' => 'field_609eb628417b8',
                    'label' => __('Hide question title' , 'king' ) ,
                    'name' => 'hide_poll_title',
                    'type' => 'true_false',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_60a001af265bf',
                                'operator' => '!=empty',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                            'default_value' => 0,
                    'ui' => 1,
                    'ui_on_text' => '',
                    'ui_off_text' => '',
                ),
                array(
                    'key' => 'field_60a001af265bf',
                    'label' => __('Question Image' , 'king' ) ,
                    'name' => 'poll_image',
                    'type' => 'image',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'return_format' => 'array',
                    'preview_size' => 'thumbnail',
                    'library' => 'uploadedTo',
                    'min_width' => '',
                    'min_height' => '',
                    'min_size' => '',
                    'max_width' => '',
                    'max_height' => '',
                    'max_size' => 5,
                    'mime_types' => 'jpg, jpeg, png, gif, webp,',
                ),
                array(
                    'key' => 'field_609eb66c417b9',
                    'label' => __('Answers Style' , 'king' ) ,
                    'name' => 'poll_answers_style',
                    'type' => 'radio',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '15',
                        'class' => 'poll-radio',
                        'id' => '',
                    ),
                    'choices' => array(
                        'pollgrid-1' => '<i class="fas fa-bars"></i>',
                        'pollgrid-2' => '<i class="fas fa-th-large"></i>',
                        'pollgrid-3' => '<i class="fas fa-grip-horizontal"></i>',
                    ),
                    'allow_null' => 0,
                    'other_choice' => 0,
                    'default_value' => '',
                    'layout' => 'vertical',
                    'return_format' => 'value',
                    'save_other_choice' => 0,
                ),
                array(
                    'key' => 'field_609ebc61fab81',
                    'label' => __('Answers' , 'king' ) ,
                    'name' => 'poll_grid_answers',
                    'type' => 'repeater',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '85',
                        'class' => 'dflex',
                        'id' => '',
                    ),
                    'collapsed' => '',
                    'min' => 2,
                    'max' => 20,
                    'layout' => 'block',
                    'button_label' => 'add answer',
                    'sub_fields' => array(
                        array(
                            'key' => 'field_609ebc62fab82',
                            'label' => __('Answer Image',  'king' ),
                            'name' => 'poll_answer_image',
                            'type' => 'image',
                            
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_609eb66c417b9',
                                        'operator' => '==',
                                        'value' => 'pollgrid-2',
                                    ),
                                ),
                                array(
                                    array(
                                        'field' => 'field_609eb66c417b9',
                                        'operator' => '==',
                                        'value' => 'pollgrid-3',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'return_format' => 'array',
                            'preview_size' => 'thumbnail',
                            'library' => 'uploadedTo',
                            'min_width' => '',
                            'min_height' => '',
                            'min_size' => '',
                            'max_width' => '',
                            'max_height' => '',
                            'max_size' => '',
                            'mime_types' => '',
                        ),
                        array(
                            'key' => 'field_609ebc62fab83',
                            'label' => __('Answer', 'king' ),
                            'name' => 'poll_answer',
                            'type' => 'text',
                            
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'placeholder' => '',
                            'prepend' => '',
                            'append' => '',
                            'maxlength' => 200,
                        ),
                    ),
                ),
                array(
                    'key' => 'field_60a6bebb2fb0f',
                    'label' => __('poll results' , 'king' ) ,
                    'name' => 'poll_results',
                    'type' => 'text',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => 'hidden',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'maxlength' => '',
                ),
            ),
        ),
    ),
    'location' => array(
        array(
            array(
                'param' => 'post_type',
                'operator' => '==',
                'value' => 'poll',
            ),
        ),
    ),
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => true,
    'description' => '',
    'show_in_rest' => 0,
));

acf_add_local_field_group(array(
    'key' => 'group_60c4b5ef1dddc',
    'title' => 'Polls Templates',
    'fields' => array(
        array(
            'key' => 'field_60c4b5fb3936f',
            'label' => __('Poll Template' , 'king' ),
            'name' => 'poll_template',
            'type' => 'radio',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array(
                'poll-template-1' => '<img src="../wp-content/themes/king/layouts/imgs/templates/single/polltemplate-v1.svg" height="180" width="180" />',
                'poll-template-2' => '<img src="../wp-content/themes/king/layouts/imgs/templates/single/polltemplate-v2.svg" height="180" width="180" />',
            ),
            'allow_null' => 1,
            'other_choice' => 0,
            'default_value' => '',
            'layout' => 'horizontal',
            'return_format' => 'value',
            'save_other_choice' => 0,
        ),
    ),
    'location' => array(
        array(
            array(
                'param' => 'post_type',
                'operator' => '==',
                'value' => 'poll',
            ),
        ),
    ),
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => true,
    'description' => '',
    'show_in_rest' => false,
));

acf_add_local_field_group(array(
    'key' => 'group_58bc8b265348c',
    'title' => 'Settings',
    'fields' => array(
        array(
            'key' => 'field_58505951c4ed2',
            'label' => __('General Settings' , 'king' ),
            'name' => '',
            'type' => 'tab',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'left',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_58519d525afb0',
            'label' => __('Page Logo' , 'king' ),
            'name' => 'page_logo',
            'type' => 'image',
            'instructions' => __('Set an image to page logo', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'return_format' => 'array',
            'preview_size' => 'thumbnail',
            'library' => 'uploadedTo',
            'min_width' => '',
            'min_height' => '',
            'min_size' => '',
            'max_width' => '',
            'max_height' => '',
            'max_size' => '',
            'mime_types' => '',
        ),
        array(
            'key' => 'field_5894e65d6db87',
            'label' => __('Mobile Page Logo' , 'king' ),
            'name' => 'mobile_page_logo',
            'type' => 'image',
            'instructions' => __('Select mobile logo . We recommend using square image.', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'return_format' => 'array',
            'preview_size' => 'thumbnail',
            'library' => 'uploadedTo',
            'min_width' => '',
            'min_height' => '',
            'min_size' => '',
            'max_width' => '',
            'max_height' => '',
            'max_size' => '',
            'mime_types' => '',
        ),
        array(
            'key' => 'field_5850595bc4ed3',
            'label' => __('Disable Users To Submit Posts' , 'king' ),
            'name' => 'disable_users_submit',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Disable Users To Submit Posts', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_5850597dc4ed4',
            'label' => __('Disable News' , 'king' ),
            'name' => 'disable_news',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5850595bc4ed3',
                        'operator' => '!=',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Disable Users to Submit News', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_585059a0c4ed5',
            'label' => __('Disable Video' , 'king' ),
            'name' => 'disable_video',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5850595bc4ed3',
                        'operator' => '!=',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Disable Users to Submit Video', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_585059b6c4ed6',
            'label' => __('Disable Image' , 'king' ),
            'name' => 'disable_image',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5850595bc4ed3',
                        'operator' => '!=',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Disable Users to Submit Image', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_5eef51b56ab0b',
            'label' => __('Disable Music' , 'king' ),
            'name' => 'disable_music',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5850595bc4ed3',
                        'operator' => '!=',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Disable Users to Submit Music', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_6096d4f98be8d',
            'label' => __('Disable List' , 'king' ),
            'name' => 'disable_list',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5850595bc4ed3',
                        'operator' => '!=',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Disable Users to Submit List', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_60ad74d978adb',
            'label' => __('Disable Polls' , 'king' ),
            'name' => 'disable_polls',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5850595bc4ed3',
                        'operator' => '!=',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Disable Users to Submit Polls', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_60b50a9f1b789',
            'label' => __('Disable Trivia Quiz' , 'king' ),
            'name' => 'disable_trivia',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5850595bc4ed3',
                        'operator' => '!=',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Disable Users to create Trivia Quiz', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_5c9ba55568bf6',
            'label' => __('Enable Night Mode' , 'king' ),
            'name' => 'enable_night_mode',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' visitors will be able to select night mode', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_5c9ba5a868bf7',
            'label' => __('Night Mode Logo' , 'king' ),
            'name' => 'night_mode_logo',
            'type' => 'image',
            'instructions' => __('Select a logo for night mode', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5c9ba55568bf6',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'return_format' => 'array',
            'preview_size' => 'thumbnail',
            'library' => 'all',
            'min_width' => '',
            'min_height' => '',
            'min_size' => '',
            'max_width' => '',
            'max_height' => '',
            'max_size' => '',
            'mime_types' => '',
        ),
        array(
            'key' => 'field_5e4fba72e9cd5',
            'label' => __('Night Mode Mobile Logo' , 'king' ),
            'name' => 'night_mode_mobile_logo',
            'type' => 'image',
            'instructions' => __('Select a logo for night mode for mobile view', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5c9ba55568bf6',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'return_format' => 'array',
            'preview_size' => 'thumbnail',
            'library' => 'all',
            'min_width' => '',
            'min_height' => '',
            'min_size' => '',
            'max_width' => '',
            'max_height' => '',
            'max_size' => '',
            'mime_types' => '',
        ),
        array(
            'key' => 'field_58599116f2877',
            'label' => __('NSFW Settings' , 'king' ),
            'name' => '',
            'type' => 'message',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' You can enable or NSFW option', 'king' ),
            'new_lines' => 'wpautop',
            'esc_html' => 0,
        ),
        array(
            'key' => 'field_58599151f2878',
            'label' => __('Enable NSFW for News' , 'king' ),
            'name' => 'enable_nsfw_for_news',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Enable NSFW for News', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_58599184f2879',
            'label' => __('Enable NSFW for Videos' , 'king' ),
            'name' => 'enable_nsfw_for_videos',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Enable NSFW for Videos', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_58599193f287a',
            'label' => __('Enable NSFW for Images' , 'king' ),
            'name' => 'enable_nsfw_for_images',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Enable NSFW for Images', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_60f6f3391ac32',
            'label' => __('Enable NSFW for Music' , 'king' ),
            'name' => 'enable_nsfw_for_music',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Enable NSFW for Music', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_60f6f3521ac33',
            'label' => __('Enable NSFW for List' , 'king' ),
            'name' => 'enable_nsfw_for_list',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Enable NSFW for List', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_60f6f3601ac34',
            'label' => __('Enable NSFW for Poll' , 'king' ),
            'name' => 'enable_nsfw_for_poll',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Enable NSFW for Polls', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_60f6f36e1ac35',
            'label' => __('Enable NSFW for Trivia Quiz' , 'king' ),
            'name' => 'enable_nsfw_for_trivia',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Enable NSFW for Trivia Quiz', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_58dae233761cc',
            'label' => __('Load More Button Show' , 'king' ),
            'name' => 'load_more_button_show',
            'type' => 'number',
            'instructions' => __('shows a trigger after page * loaded', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 1,
            'placeholder' => '',
            'prepend' => 'Page',
            'append' => '',
            'min' => 0,
            'max' => 150,
            'step' => '',
        ),
        array(
            'key' => 'field_597bbe9f58b70',
            'label' => __('Enable RTL' , 'king' ),
            'name' => 'enable_rtl',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Enable Rtl', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_60f154d367c31',
            'label' => __('Enable WP Login' , 'king' ),
            'name' => 'enable_wp_login',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Enable default WP login and register', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_58505945c4ed1',
            'label' => __('Registration' , 'king' ),
            'name' => '',
            'type' => 'tab',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'left',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_58505b59edb1c',
            'label' => __('Enable recaptcha' , 'king' ),
            'name' => 'enable_recaptcha',
            'type' => 'true_false',
            'instructions' => __('Enable recaptcha for register page', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Enable recaptcha', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_58505b78edb1d',
            'label' => __('Google Recaptcha Site key' , 'king' ),
            'name' => 'recaptcha_key',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_58505b59edb1c',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => 'Site Key',
            'append' => '',
            'formatting' => 'none',
            'maxlength' => '',
        ),
        array(
            'key' => 'field_58505bb2edb1e',
            'label' => __('Google Recaptcha Secret key' , 'king' ),
            'name' => 'recaptcha_secret',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_58505b59edb1c',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => 'Secret key',
            'append' => '',
            'formatting' => 'none',
            'maxlength' => '',
        ),
        array(
            'key' => 'field_5b41358c65287',
            'label' => __('Enable Allowed Emails' , 'king' ),
            'name' => 'enable_allowed_emails',
            'type' => 'true_false',
            'instructions' => __('Enable allowed emails for register page', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_5b4135b865288',
            'label' => __('Allowed Emails' , 'king' ),
            'name' => 'allowed_emails',
            'type' => 'repeater',
            'instructions' => __('add allowed email addresses for registration page, for example: gmail.com', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5b41358c65287',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'collapsed' => '',
            'min' => 0,
            'max' => 0,
            'layout' => 'block',
            'button_label' => 'Add One More',
            'sub_fields' => array(
                array(
                    'key' => 'field_5b41360b65289',
                    'label' => __('Allowed Email' , 'king' ) ,
                    'name' => 'allowed_email',
                    'type' => 'text',
                    'instructions' => __('add email addresses per input', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'placeholder' => 'for example : gmail.com',
                    'prepend' => 'email source',
                    'append' => '',
                    'maxlength' => '',
                ),
            ),
        ),
        array(
            'key' => 'field_5ceaa10ab26af',
            'label' => __('Enable Age Verification' , 'king' ),
            'name' => 'enable_age_verification',
            'type' => 'true_false',
            'instructions' => __('Enable age verification for register page', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_5ceaa116b26b0',
            'label' => __('Minimum Age for Registration' , 'king' ),
            'name' => 'minimum_age_for_registration',
            'type' => 'number',
            'instructions' => __('the minimum age requirements to register your page', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5ceaa10ab26af',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 13,
            'placeholder' => '',
            'prepend' => 'Age',
            'append' => '',
            'min' => 1,
            'max' => 200,
            'step' => '',
        ),
        array(
            'key' => 'field_58505d44da944',
            'label' => __('Social Logins' , 'king' ),
            'name' => '',
            'type' => 'message',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Social login settings', 'king' ),
            'new_lines' => 'wpautop',
            'esc_html' => 0,
        ),
        array(
            'key' => 'field_57d9b645ca86f',
            'label' => __('Enable Facebook Login and Register' , 'king' ),
            'name' => 'enable_facebook_login',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Enable Facebook Login and Register', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_57d9b66eca870',
            'label' => __('Facebook App ID' , 'king' ),
            'name' => 'facebook_app_id',
            'type' => 'text',
            
            'required' => 1,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_57d9b645ca86f',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => 'App ID',
            'append' => '',
            'formatting' => 'none',
            'maxlength' => '',
        ),
        array(
            'key' => 'field_57d9b6cbca871',
            'label' => __('Facebook Secret Key' , 'king' ),
            'name' => 'facebook_secret_key',
            'type' => 'text',
            
            'required' => 1,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_57d9b645ca86f',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => 'Secret Key',
            'append' => '',
            'formatting' => 'none',
            'maxlength' => '',
        ),
        array(
            'key' => 'field_57d9c80dcd294',
            'label' => __('Enable Google Login and Register' , 'king' ),
            'name' => 'enable_googleplus_login',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Enable Google Login and Register', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_57d9c873cd296',
            'label' => __('Google+ Client ID' , 'king' ),
            'name' => 'googleplus_client_id',
            'type' => 'text',
            
            'required' => 1,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_57d9c80dcd294',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => 'Client ID',
            'append' => '',
            'formatting' => 'none',
            'maxlength' => '',
        ),
        array(
            'key' => 'field_57d9c8a2cd297',
            'label' => __('Google+ Client Secret' , 'king' ),
            'name' => 'googleplus_client_secret',
            'type' => 'text',
            
            'required' => 1,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_57d9c80dcd294',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => 'Client Secret',
            'append' => '',
            'formatting' => 'none',
            'maxlength' => '',
        ),
        array(
            'key' => 'field_5ab16883a1965',
            'label' => __('Enable Social Logins in Modal' , 'king' ),
            'name' => 'enable_social_logins_in_modal',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_57d9b645ca86f',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
                array(
                    array(
                        'field' => 'field_57d9c80dcd294',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Enable Google+ and Facebook Login in modal box', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_58505c966cb4a',
            'label' => __('TermsConditions' , 'king' ),
            'name' => '',
            'type' => 'message',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Terms and Conditions Text', 'king' ),
            'new_lines' => 'wpautop',
            'esc_html' => 0,
        ),
        array(
            'key' => 'field_58505c1d656ae',
            'label' => __('Enable Terms and Conditions' , 'king' ),
            'name' => 'enable_terms_and_conditions',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Enable Terms and Conditions on register page', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_58505c38656af',
            'label' => __('Terms and Conditions' , 'king' ),
            'name' => 'terms_and_conditions',
            'type' => 'textarea',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_58505c1d656ae',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'page terms and conditions for users',
            'maxlength' => '',
            'rows' => 10,
            'new_lines' => '',
        ),
        array(
            'key' => 'field_591ccb719720f',
            'label' => __('Users' , 'king' ),
            'name' => '',
            'type' => 'tab',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'left',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_5e760eb00fbe2',
            'label' => __('Show user results in search' , 'king' ),
            'name' => 'show_user_results_in_search',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' display user search results in search page', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_5cf15178e5bee',
            'label' => __('Enable Category Follow' , 'king' ),
            'name' => 'enable_category_follow',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Allow users to follow categories', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_5cf151e3e5bef',
            'label' => __('Enable Tag Follow' , 'king' ),
            'name' => 'enable_tag_follow',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Allow users to follow tags', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_591cc88deaabc',
            'label' => __('Enable Private Messages' , 'king' ),
            'name' => 'enable_private_messages',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Enable private messages between members', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_58505a0bc4ed7',
            'label' => __('Only verified users can create posts' , 'king' ),
            'name' => 'only_verified',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' If you enable this only verified users can create posts', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_58505a4ec4ed8',
            'label' => __('Do not use moderation for verified users posts' , 'king' ),
            'name' => 'verified_posts',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' if you enable this, verified users posts will be published without moderation', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_5962a60ced4f8',
            'label' => __('Default Avatar' , 'king' ),
            'name' => 'default_avatar',
            'type' => 'image',
            'instructions' => __('For users without a custom avatar of their own, you can either display a generic logo', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'return_format' => 'array',
            'preview_size' => 'thumbnail',
            'library' => 'uploadedTo',
            'min_width' => '',
            'min_height' => '',
            'min_size' => '',
            'max_width' => '',
            'max_height' => '',
            'max_size' => 4,
            'mime_types' => 'jpg, png, gif, jpeg',
        ),
        array(
            'key' => 'field_5962a9f8d8a5c',
            'label' => __('Default Cover' , 'king' ),
            'name' => 'default_cover',
            'type' => 'image',
            'instructions' => __('Custom cover image for user\'s profile page', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'return_format' => 'array',
            'preview_size' => 'thumbnail',
            'library' => 'uploadedTo',
            'min_width' => '',
            'min_height' => '',
            'min_size' => '',
            'max_width' => '',
            'max_height' => '',
            'max_size' => 8,
            'mime_types' => 'jpg, png, gif, jpeg',
        ),
        array(
            'key' => 'field_58505a6fc4ed9',
            'label' => __('Max. Avatar Size' , 'king' ),
            'name' => 'max_avatar_size',
            'type' => 'number',
            'instructions' => __('Max. avatar size for users', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 2,
            'placeholder' => '',
            'prepend' => 'MB',
            'append' => '',
            'min' => 0,
            'max' => 10,
            'step' => '',
        ),
        array(
            'key' => 'field_58505a95c4eda',
            'label' => __('Max. Cover Size' , 'king' ),
            'name' => 'max_cover_size',
            'type' => 'number',
            'instructions' => __('Max. cover size for users', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 2,
            'placeholder' => '',
            'prepend' => 'MB',
            'append' => '',
            'min' => 0,
            'max' => 20,
            'step' => '',
        ),
        array(
            'key' => 'field_58866ca1459fd',
            'label' => __('Social Share' , 'king' ),
            'name' => '',
            'type' => 'tab',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'left',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_58866cd9459ff',
            'label' => __('Social Share Settings' , 'king' ),
            'name' => '',
            'type' => 'message',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Facebook App ID and Secret Key required to count facebook share. You can create an app after login <a href="https://developers.facebook.com/" target="_blank">HERE</a>', 'king' ),
            'new_lines' => 'wpautop',
            'esc_html' => 0,
        ),
        array(
            'key' => 'field_58866cb0459fe',
            'label' => __('Facebook App ID' , 'king' ),
            'name' => 'facebook_share_app_id',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => 'App ID',
            'append' => '',
            'formatting' => 'none',
            'maxlength' => '',
        ),
        array(
            'key' => 'field_58866d8945a00',
            'label' => __('Facebook Secret Key' , 'king' ),
            'name' => 'facebook_share_secret_key',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => 'Secret Key',
            'append' => '',
            'formatting' => 'none',
            'maxlength' => '',
        ),
        array(
            'key' => 'field_5945ad8eec21b',
            'label' => __('Facebook access token' , 'king' ),
            'name' => 'facebook_access_token',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => 'hidden',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => 'Access',
            'append' => '',
            'maxlength' => '',
        ),
        array(
            'key' => 'field_58867bfc5820a',
            'label' => __('Display or Hide Share Buttons' , 'king' ),
            'name' => '',
            'type' => 'message',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Display or Hide Share Buttons', 'king' ),
            'new_lines' => 'wpautop',
            'esc_html' => 0,
        ),
        array(
            'key' => 'field_58867c7f5820b',
            'label' => __('Display Thumblr Share Button' , 'king' ),
            'name' => 'display_thumblr_share_button',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Display Thumblr Share Button', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_58867cab5820c',
            'label' => __('Display Linkedin Share Button' , 'king' ),
            'name' => 'display_linkedin_share_button',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Display Linkedin Share Button', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_58867cc25820d',
            'label' => __('Display Pinterest Share Button' , 'king' ),
            'name' => 'display_pinterest_share_button',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Display Pinterest Share Button', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_58867cd65820e',
            'label' => __('Display VK Share Button' , 'king' ),
            'name' => 'display_vk_share_button',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Display VK Share Button', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_59025c9640fcd',
            'label' => __('Display Whatsapp Share Button' , 'king' ),
            'name' => 'display_wapp_share_button',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Display Whatsapp Share Button in mobile view', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_588fa0bac1507',
            'label' => __('Submit Page' , 'king' ),
            'name' => '',
            'type' => 'tab',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'left',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_5c9ba7100c467',
            'label' => __('Enable Save Posts' , 'king' ),
            'name' => 'enable_save_posts',
            'type' => 'true_false',
            'instructions' => __('Authors will be able to save posts as draft', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_5cea9bea2aa64',
            'label' => __('Disable post moderation' , 'king' ),
            'name' => 'disable_post_moderation',
            'type' => 'true_false',
            'instructions' => __('All users posts will be published automatically without moderation', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_588fa0d0c1508',
            'label' => __('Maximum Title Length' , 'king' ),
            'name' => 'maximum_title_length',
            'type' => 'number',
            'instructions' => __('Maximum length of post title', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 140,
            'placeholder' => '',
            'prepend' => 'characters',
            'append' => '',
            'min' => 10,
            'max' => 1200,
            'step' => 10,
        ),
        array(
            'key' => 'field_588fae418b17f',
            'label' => __('Maximum Content Length' , 'king' ),
            'name' => 'maximum_content_length',
            'type' => 'number',
            'instructions' => __('Maximum length of post content', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 2000,
            'placeholder' => '',
            'prepend' => 'characters',
            'append' => '',
            'min' => 10,
            'max' => 8000,
            'step' => 10,
        ),
        array(
            'key' => 'field_597bc29558c8a',
            'label' => __('Maximum File Upload Size' , 'king' ),
            'name' => 'max_file_u_size',
            'type' => 'number',
            'instructions' => __('Maximum File Upload Size', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 2,
            'placeholder' => '',
            'prepend' => 'MB',
            'append' => '',
            'min' => 1,
            'max' => 1000,
            'step' => 1,
        ),
        array(
            'key' => 'field_590ba0bcfa337',
            'label' => __('Disable Video and Mp3 upload' , 'king' ),
            'name' => 'disable_video_and_mp3_upload',
            'type' => 'true_false',
            'instructions' => __('Disable Video and Mp3 upload in video submit page', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_5eefcef17a29a',
            'label' => __('Disable Creating Playlist' , 'king' ),
            'name' => 'disable_creating_playlist',
            'type' => 'true_false',
            'instructions' => __('Disable creating playlist for video and music submission on front-end', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_59c9862afac51',
            'label' => __('Enable embed code adding' , 'king' ),
            'name' => 'enable_embed_code_adding',
            'type' => 'true_false',
            'instructions' => __('Enable embed code adding in video submit page', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_5a27076c77513',
            'label' => __('Facebook User Access Token' , 'king' ),
            'name' => 'facebook_user_access_token',
            'type' => 'text',
            'instructions' => __('Need this to create thumbnail for Facebook Videos, you can get your user access token <a href="https://developers.facebook.com/tools/accesstoken/" target="_blank">HERE</a>', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => 'FB User Access',
            'append' => '',
            'maxlength' => '',
        ),
        array(
            'key' => 'field_58caff33cd44c',
            'label' => __('Reactions' , 'king' ),
            'name' => '',
            'type' => 'tab',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'left',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_58caff4ccd44d',
            'label' => __('Enable Reactions' , 'king' ),
            'name' => 'enable_reactions',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Enable Reactions for your page', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_5a5e5a964ea35',
            'label' => __('Enable Reactions Without Comments' , 'king' ),
            'name' => 'enable_reactions_without_comments',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Enable Reactions without comments in post page', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_58caff85cd44e',
            'label' => __('Display Reactions Results Block' , 'king' ),
            'name' => 'display_reactions_block',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_58caff4ccd44d',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Display Reactions block in post page', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_58cb233146f1f',
            'label' => __('Reactions Title in comment form' , 'king' ),
            'name' => 'reactions_title_in_comment_form',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_58caff4ccd44d',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'Reactions',
            'prepend' => 'text',
            'append' => '',
            'maxlength' => 100,
        ),
        array(
            'key' => 'field_58cb0162d8099',
            'label' => __('1st Reaction' , 'king' ),
            'name' => '',
            'type' => 'message',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_58caff4ccd44d',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'new_lines' => 'wpautop',
            'esc_html' => 0,
        ),
        array(
            'key' => 'field_58cb0048d7754',
            'label' => __('Like' , 'king' ),
            'name' => '1st_reaction',
            'type' => 'image',
            'instructions' => __('Minimum size: 42px | 42px', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_58caff4ccd44d',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'return_format' => 'url',
            'preview_size' => 'thumbnail',
            'library' => 'uploadedTo',
            'min_width' => 42,
            'min_height' => 42,
            'min_size' => '',
            'max_width' => 800,
            'max_height' => 800,
            'max_size' => 5,
            'mime_types' => 'jpeg, png, gif, jpg,',
        ),
        array(
            'key' => 'field_58cb01a1d809a',
            'label' => __('1st Reaction Text' , 'king' ),
            'name' => '1st_reaction_text',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_58caff4ccd44d',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'Like',
            'prepend' => 'text',
            'append' => '',
            'maxlength' => 100,
        ),
        array(
            'key' => 'field_58cb02debe50e',
            'label' => __('2nd Reaction' , 'king' ),
            'name' => '',
            'type' => 'message',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_58caff4ccd44d',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'new_lines' => 'wpautop',
            'esc_html' => 0,
        ),
        array(
            'key' => 'field_58cb038c97f33',
            'label' => __('Love' , 'king' ),
            'name' => '2nd_reaction',
            'type' => 'image',
            'instructions' => __('Minimum size: 42px | 42px', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_58caff4ccd44d',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'return_format' => 'url',
            'preview_size' => 'thumbnail',
            'library' => 'uploadedTo',
            'min_width' => 42,
            'min_height' => 42,
            'min_size' => '',
            'max_width' => 400,
            'max_height' => 400,
            'max_size' => 5,
            'mime_types' => 'jpeg, png, gif, jpg,',
        ),
        array(
            'key' => 'field_58cb03ef97f38',
            'label' => __('2nd Reaction Text' , 'king' ),
            'name' => '2nd_reaction_text',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_58caff4ccd44d',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'Love',
            'prepend' => 'text',
            'append' => '',
            'maxlength' => 100,
        ),
        array(
            'key' => 'field_58cb0323be50f',
            'label' => __('3rd Reaction' , 'king' ),
            'name' => '',
            'type' => 'message',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_58caff4ccd44d',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'new_lines' => 'wpautop',
            'esc_html' => 0,
        ),
        array(
            'key' => 'field_58cb03a897f34',
            'label' => __('Haha' , 'king' ),
            'name' => '3rd_reaction',
            'type' => 'image',
            'instructions' => __('Minimum size: 42px | 42px', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_58caff4ccd44d',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'return_format' => 'url',
            'preview_size' => 'thumbnail',
            'library' => 'uploadedTo',
            'min_width' => 42,
            'min_height' => 42,
            'min_size' => '',
            'max_width' => 400,
            'max_height' => 400,
            'max_size' => 5,
            'mime_types' => 'jpeg, png, gif, jpg,',
        ),
        array(
            'key' => 'field_58cb040e97f39',
            'label' => __('3rd Reaction Text' , 'king' ),
            'name' => '3rd_reaction_text',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_58caff4ccd44d',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'Haha',
            'prepend' => 'text',
            'append' => '',
            'maxlength' => 100,
        ),
        array(
            'key' => 'field_58cb0331be510',
            'label' => __('4th Reaction' , 'king' ),
            'name' => '',
            'type' => 'message',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_58caff4ccd44d',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'new_lines' => 'wpautop',
            'esc_html' => 0,
        ),
        array(
            'key' => 'field_58cb03b597f35',
            'label' => __('Wow' , 'king' ),
            'name' => '4th_reaction',
            'type' => 'image',
            'instructions' => __('Minimum size: 42px | 42px', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_58caff4ccd44d',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'return_format' => 'url',
            'preview_size' => 'thumbnail',
            'library' => 'uploadedTo',
            'min_width' => 42,
            'min_height' => 42,
            'min_size' => '',
            'max_width' => 400,
            'max_height' => 400,
            'max_size' => 5,
            'mime_types' => 'jpeg, png, gif, jpg,',
        ),
        array(
            'key' => 'field_58cb042397f3a',
            'label' => __('4th Reaction Text' , 'king' ),
            'name' => '4th_reaction_text',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_58caff4ccd44d',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'Wow',
            'prepend' => 'text',
            'append' => '',
            'maxlength' => 100,
        ),
        array(
            'key' => 'field_58cb033bbe512',
            'label' => __('5th Reaction' , 'king' ),
            'name' => '',
            'type' => 'message',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_58caff4ccd44d',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'new_lines' => 'wpautop',
            'esc_html' => 0,
        ),
        array(
            'key' => 'field_58cb03c897f36',
            'label' => __('Sad' , 'king' ),
            'name' => '5th_reaction',
            'type' => 'image',
            'instructions' => __('Minimum size: 42px | 42px', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_58caff4ccd44d',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'return_format' => 'url',
            'preview_size' => 'thumbnail',
            'library' => 'uploadedTo',
            'min_width' => 42,
            'min_height' => 42,
            'min_size' => '',
            'max_width' => 400,
            'max_height' => 400,
            'max_size' => 5,
            'mime_types' => 'jpeg, png, gif, jpg,',
        ),
        array(
            'key' => 'field_58cb043e97f3b',
            'label' => __('5th Reaction Text' , 'king' ),
            'name' => '5th_reaction_text',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_58caff4ccd44d',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'Sad',
            'prepend' => 'text',
            'append' => '',
            'maxlength' => 100,
        ),
        array(
            'key' => 'field_58cb034abe513',
            'label' => __('6th Reaction' , 'king' ),
            'name' => '',
            'type' => 'message',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_58caff4ccd44d',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'new_lines' => 'wpautop',
            'esc_html' => 0,
        ),
        array(
            'key' => 'field_58cb03d597f37',
            'label' => __('Angry' , 'king' ),
            'name' => '6th_reaction',
            'type' => 'image',
            'instructions' => __('Minimum size: 42px | 42px', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_58caff4ccd44d',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'return_format' => 'url',
            'preview_size' => 'thumbnail',
            'library' => 'uploadedTo',
            'min_width' => 42,
            'min_height' => 42,
            'min_size' => '',
            'max_width' => 400,
            'max_height' => 400,
            'max_size' => 5,
            'mime_types' => 'jpeg, png, gif, jpg,',
        ),
        array(
            'key' => 'field_58cb044b97f3c',
            'label' => __('6th Reaction Text' , 'king' ),
            'name' => '6th_reaction_text',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_58caff4ccd44d',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'Angry',
            'prepend' => 'text',
            'append' => '',
            'maxlength' => 100,
        ),
        array(
            'key' => 'field_5a3c362f08c02',
            'label' => __('AMP' , 'king' ),
            'name' => '',
            'type' => 'tab',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'left',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_5a3c373608c03',
            'label' => __('Enable AMP' , 'king' ),
            'name' => 'enable_amp',
            'type' => 'true_false',
            'instructions' => __('Enable Google accelerated mobile pages ( AMP )', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_5a4bf625a9545',
            'label' => __('AMP Share Options' , 'king' ),
            'name' => 'amp_share_options',
            'type' => 'checkbox',
            'instructions' => __('AMP Share Options', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5a3c373608c03',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array(
                'facebook' => 'Facebook',
                'twitter' => 'Twitter',
                'google_plus' => 'Google Plus',
                'whatsapp' => 'WhatsApp',
                'sms' => 'SMS',
                'email' => 'E-mail',
            ),
            'allow_custom' => 0,
            'save_custom' => 0,
            'default_value' => array(
                0 => 'facebook',
                1 => 'twitter',
                2 => 'google_plus',
                3 => 'whatsapp',
                4 => 'sms',
                5 => 'email',
            ),
            'layout' => 'horizontal',
            'toggle' => 0,
            'return_format' => 'value',
        ),
        array(
            'key' => 'field_5a4bf05004466',
            'label' => __('Amp Customization' , 'king' ),
            'name' => '',
            'type' => 'message',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5a3c373608c03',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'new_lines' => '',
            'esc_html' => 0,
        ),
        array(
            'key' => 'field_5a4bf2a752501',
            'label' => __('Amp Body Background Color' , 'king' ),
            'name' => 'amp_body_background_color',
            'type' => 'color_picker',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5a3c373608c03',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5a4bf0c904467',
            'label' => __('Amp Header Background' , 'king' ),
            'name' => 'amp_header_background',
            'type' => 'color_picker',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5a3c373608c03',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5a4bf320b9bd4',
            'label' => __('Amp Container Background' , 'king' ),
            'name' => 'amp_container_background',
            'type' => 'color_picker',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5a3c373608c03',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5a4bf38cb9bd5',
            'label' => __('Amp Container Text Color' , 'king' ),
            'name' => 'amp_container_text_color',
            'type' => 'color_picker',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5a3c373608c03',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5a4bf42559121',
            'label' => __('Amp Share Box Background' , 'king' ),
            'name' => 'amp_share_box_background',
            'type' => 'color_picker',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5a3c373608c03',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5a4bf4c92fd47',
            'label' => __('Amp Custom CSS' , 'king' ),
            'name' => 'amp_custom_css',
            'type' => 'textarea',
            'instructions' => __('Custom css for the Amp page', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5a3c373608c03',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'maxlength' => '',
            'rows' => '',
            'new_lines' => '',
        ),
        array(
            'key' => 'field_61854baf759ac',
            'label' => __('Stories' , 'king' ),
            'name' => '',
            'type' => 'tab',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'top',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_61854bc6759ad',
            'label' => __('Enable Stories' , 'king' ),
            'name' => 'enable_stories',
            'type' => 'true_false',
            'instructions' => __('enable stories for your page', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_61923fece7c4b',
            'label' => __('Stories Slider Title' , 'king' ),
            'name' => 'stories_slider_title',
            'type' => 'text',
            'instructions' => __('add title for stories slider ( optional )', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_61854bc6759ad',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'Stories',
            'prepend' => 'text',
            'append' => '',
            'maxlength' => '',
        ),
        array(
            'key' => 'field_61854bf3759ae',
            'label' => __('Display stories on homepage' , 'king' ),
            'name' => 'display_stories_on_homepage',
            'type' => 'true_false',
            'instructions' => __('display user stories on homepage like slider', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_61854bc6759ad',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_61a24df9a6280',
            'label' => __('Total Number of Stories' , 'king' ),
            'name' => 'total_number_of_stories',
            'type' => 'number',
            'instructions' => __('change number of stories to display on slider', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_61854bc6759ad',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 14,
            'placeholder' => '',
            'prepend' => 'number',
            'append' => '',
            'min' => 1,
            'max' => 55,
            'step' => '',
        ),
        array(
            'key' => 'field_618e63744af65',
            'label' => __('Stories date range' , 'king' ),
            'name' => 'stories_date_range',
            'type' => 'select',
            'instructions' => __('select date period of stories to display', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_61854bc6759ad',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'choices' => array(
                'all' => 'All Stories',
                'week' => 'Weekly Stories',
                'day' => 'Daily Stories',
            ),
            'default_value' => false,
            'allow_null' => 0,
            'multiple' => 0,
            'ui' => 0,
            'return_format' => 'value',
            'ajax' => 0,
            'placeholder' => '',
        ),
        array(
            'key' => 'field_618cfd2b41df1',
            'label' => __('Stories display style' , 'king' ),
            'name' => 'stories_display_style',
            'type' => 'select',
            'instructions' => __('display all stories or last story of users', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_61854bc6759ad',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'choices' => array(
                'all' => 'All stories',
                'last' => 'Last story',
            ),
            'default_value' => false,
            'allow_null' => 0,
            'multiple' => 0,
            'ui' => 0,
            'return_format' => 'value',
            'ajax' => 0,
            'placeholder' => '',
        ),
        array(
            'key' => 'field_6193a5db50c41',
            'label' => __('Hide create story' , 'king' ),
            'name' => 'hide_create_story',
            'type' => 'true_false',
            'instructions' => __('you can hide create story box in stories slider', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_61854bc6759ad',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_61a24f8fd2004',
            'label' => __('Add create story in submit' , 'king' ),
            'name' => 'add_create_story_in_submit',
            'type' => 'true_false',
            'instructions' => __('you can add create story button in submit posts dropdown', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_61854bc6759ad',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_61b8890587434',
            'label' => __('Disable adding links' , 'king' ),
            'name' => 'disable_adding_links',
            'type' => 'true_false',
            'instructions' => __('you can disable to users add links to stories', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_61854bc6759ad',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_61af72ea5b82a',
            'label' => __('Moderate stories' , 'king' ),
            'name' => 'moderate_stories',
            'type' => 'true_false',
            'instructions' => __('enable story moderation', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_61854bc6759ad',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_61c064ac9870e',
            'label' => __('Display featured stories' , 'king' ),
            'name' => 'display_featured_stories',
            'type' => 'true_false',
            'instructions' => __('you can display only featured stories on homepage.', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_61854bc6759ad',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_5cf2b3a525dfc',
            'label' => __('Texts' , 'king' ),
            'name' => '',
            'type' => 'tab',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'left',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_5cf2b41025dfe',
            'label' => __('Enable Text Translation' , 'king' ),
            'name' => 'enable_text_translation',
            'type' => 'true_false',
            'instructions' => __('You can translate some texts in king theme', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_5cf2b3cf25dfd',
            'label' => __('News' , 'king' ),
            'name' => 'news_text',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5cf2b41025dfe',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'new text here',
            'prepend' => 'News',
            'append' => '',
            'maxlength' => 50,
        ),
        array(
            'key' => 'field_5cf2b52795a06',
            'label' => __('Submit News' , 'king' ),
            'name' => 'submit_news_text',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5cf2b41025dfe',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'new text here',
            'prepend' => 'Submit News',
            'append' => '',
            'maxlength' => 50,
        ),
        array(
            'key' => 'field_5cf2b4e71e0eb',
            'label' => __('Video' , 'king' ),
            'name' => 'videos_text',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5cf2b41025dfe',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'new text here',
            'prepend' => 'Video',
            'append' => '',
            'maxlength' => 50,
        ),
        array(
            'key' => 'field_5cf2b54195a07',
            'label' => __('Submit Video' , 'king' ),
            'name' => 'submit_video_text',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5cf2b41025dfe',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'new text here',
            'prepend' => 'Submit Video',
            'append' => '',
            'maxlength' => 50,
        ),
        array(
            'key' => 'field_5cf2b63a2c40f',
            'label' => __('Image' , 'king' ),
            'name' => 'image_text',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5cf2b41025dfe',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'new text here',
            'prepend' => 'Image',
            'append' => '',
            'maxlength' => 50,
        ),
        array(
            'key' => 'field_5cf2b69f2c411',
            'label' => __('Submit Image' , 'king' ),
            'name' => 'submit_image_text',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5cf2b41025dfe',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'new text here',
            'prepend' => 'Submit Image',
            'append' => '',
            'maxlength' => 50,
        ),
        array(
            'key' => 'field_5ef7c280c4b2e',
            'label' => __('Music' , 'king' ),
            'name' => 'music_text',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5cf2b41025dfe',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'new text here',
            'prepend' => 'Music',
            'append' => '',
            'maxlength' => 50,
        ),
        array(
            'key' => 'field_5ef7c2a0c4b2f',
            'label' => __('Submit Music' , 'king' ),
            'name' => 'submit_music_text',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5cf2b41025dfe',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'new text here',
            'prepend' => 'Submit Music',
            'append' => '',
            'maxlength' => 50,
        ),
        array(
            'key' => 'field_60cb352d4cfae',
            'label' => __('List' , 'king' ),
            'name' => 'list_text',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5cf2b41025dfe',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'new text here',
            'prepend' => 'List',
            'append' => '',
            'maxlength' => 50,
        ),
        array(
            'key' => 'field_60cb352c4cfad',
            'label' => __('Submit List' , 'king' ),
            'name' => 'submit_list_text',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5cf2b41025dfe',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'new text here',
            'prepend' => 'Submit List',
            'append' => '',
            'maxlength' => 50,
        ),
        array(
            'key' => 'field_60cb35704cfaf',
            'label' => __('Poll' , 'king' ),
            'name' => 'Poll_text',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5cf2b41025dfe',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'new text here',
            'prepend' => 'Poll',
            'append' => '',
            'maxlength' => 50,
        ),
        array(
            'key' => 'field_60cb35764cfb0',
            'label' => __('Submit Poll' , 'king' ),
            'name' => 'submit_poll_text',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5cf2b41025dfe',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'new text here',
            'prepend' => 'Submit Poll',
            'append' => '',
            'maxlength' => 50,
        ),
        array(
            'key' => 'field_60cb35a44cfb1',
            'label' => __('Trivia Quiz' , 'king' ),
            'name' => 'trivia_quiz_text',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5cf2b41025dfe',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'new text here',
            'prepend' => 'Trivia Quiz',
            'append' => '',
            'maxlength' => 50,
        ),
        array(
            'key' => 'field_60cb35a64cfb2',
            'label' => __('Submit Trivia Quiz' , 'king' ),
            'name' => 'submit_trivia_quiz_text',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5cf2b41025dfe',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'new text here',
            'prepend' => 'Submit Trivia Quiz',
            'append' => '',
            'maxlength' => 50,
        ),
        array(
            'key' => 'field_5cf2b6542c410',
            'label' => __('featured' , 'king' ),
            'name' => 'featured_text',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5cf2b41025dfe',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'new text here',
            'prepend' => 'featured',
            'append' => '',
            'maxlength' => 50,
        ),
        array(
            'key' => 'field_5cf2b6b92c412',
            'label' => __('trending' , 'king' ),
            'name' => 'trending_text',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5cf2b41025dfe',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'new text here',
            'prepend' => 'trending',
            'append' => '',
            'maxlength' => 50,
        ),
        array(
            'key' => 'field_5cf3b0aab5c12',
            'label' => __('My Settings' , 'king' ),
            'name' => 'my_settings_text',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5cf2b41025dfe',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'new text here',
            'prepend' => 'My Settings',
            'append' => '',
            'maxlength' => 50,
        ),
        array(
            'key' => 'field_5cf3b0c7b5c13',
            'label' => __('Inbox' , 'king' ),
            'name' => 'inbox_text',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5cf2b41025dfe',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'new text here',
            'prepend' => 'Inbox',
            'append' => '',
            'maxlength' => 50,
        ),
        array(
            'key' => 'field_5cf3b100b5c15',
            'label' => __('Private Messages' , 'king' ),
            'name' => 'private_messages_text',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5cf2b41025dfe',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'new text here',
            'prepend' => 'Private Messages',
            'append' => '',
            'maxlength' => 50,
        ),
        array(
            'key' => 'field_5cf3b0ddb5c14',
            'label' => __('My Dashboard' , 'king' ),
            'name' => 'my_dashboard_text',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5cf2b41025dfe',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'new text here',
            'prepend' => 'My Dashboard',
            'append' => '',
            'maxlength' => 50,
        ),
        array(
            'key' => 'field_5cf3b201ae737',
            'label' => __('Submit Post' , 'king' ),
            'name' => 'submit_post_text',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5cf2b41025dfe',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'new text here',
            'prepend' => 'Submit Post',
            'append' => '',
            'maxlength' => 50,
        ),
        array(
            'key' => 'field_5cf3b221ae738',
            'label' => __('Save' , 'king' ),
            'name' => 'save_text',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5cf2b41025dfe',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'new text here',
            'prepend' => 'Save',
            'append' => '',
            'maxlength' => 50,
        ),
        array(
            'key' => 'field_5cf3b23aae739',
            'label' => __('Add New' , 'king' ),
            'name' => 'add_new_text',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5cf2b41025dfe',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'new text here',
            'prepend' => 'Add New',
            'append' => '',
            'maxlength' => 50,
        ),
        array(
            'key' => 'field_5cf3b32a80ccf',
            'label' => __('Select Image' , 'king' ),
            'name' => 'select_image_text',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5cf2b41025dfe',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'new text here',
            'prepend' => 'Select Image',
            'append' => '',
            'maxlength' => 50,
        ),
        array(
            'key' => 'field_5f860d34ab24d',
            'label' => __('Bookmark' , 'king' ),
            'name' => 'bookmark_text',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5cf2b41025dfe',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'new text here',
            'prepend' => 'Bookmark',
            'append' => '',
            'maxlength' => 50,
        ),
        array(
            'key' => 'field_5f860d65ab24e',
            'label' => __('My Bookmarks' , 'king' ),
            'name' => 'my_bookmarks_text',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5cf2b41025dfe',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'new text here',
            'prepend' => 'My Bookmarks',
            'append' => '',
            'maxlength' => 50,
        ),
        array(
            'key' => 'field_619a23d4fadc3',
            'label' => __('Stories' , 'king' ),
            'name' => 'stories_text',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5cf2b41025dfe',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'new text here',
            'prepend' => 'Stories',
            'append' => '',
            'maxlength' => 50,
        ),
        array(
            'key' => 'field_61a754bdadd7f',
            'label' => __('Story' , 'king' ),
            'name' => 'story_text',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5cf2b41025dfe',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'new text here',
            'prepend' => 'Story',
            'append' => '',
            'maxlength' => 50,
        ),
        array(
            'key' => 'field_619a239e5148e',
            'label' => __('Create Story' , 'king' ),
            'name' => 'create_story_text',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5cf2b41025dfe',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'new text here',
            'prepend' => 'Create Story',
            'append' => '',
            'maxlength' => 50,
        ),
    ),
    'location' => array(
        array(
            array(
                'param' => 'options_page',
                'operator' => '==',
                'value' => 'acf-options-settings',
            ),
        ),
    ),
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => true,
    'description' => '',
    'show_in_rest' => 0,
));

acf_add_local_field_group(array(
    'key' => 'group_61c063b43ff8a',
    'title' => 'Story Options',
    'fields' => array(
        array(
            'key' => 'field_61c063bae3e39',
            'label' => __('Featured Story' , 'king' ),
            'name' => 'featured_story',
            'type' => 'true_false',
            'instructions' => __('select this story as featured and display on homepage.', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
    ),
    'location' => array(
        array(
            array(
                'param' => 'post_type',
                'operator' => '==',
                'value' => 'stories',
            ),
        ),
    ),
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => true,
    'description' => '',
    'show_in_rest' => 0,
));

acf_add_local_field_group(array(
    'key' => 'group_5d4edfd34af88',
    'title' => 'Templates',
    'fields' => array(
        array(
            'key' => 'field_5e28624658a65',
            'label' => __('Header' , 'king' ),
            'name' => '',
            'type' => 'tab',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'left',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_5e28626d0b645',
            'label' => __('Header Templates' , 'king' ),
            'name' => 'header_templates',
            'type' => 'radio',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'choices' => array(
                'header-template-01' => '<img src="../wp-content/themes/king/layouts/imgs/templates/header/header-01.svg" height="84" width="350" />',
                'header-template-02' => '<img src="../wp-content/themes/king/layouts/imgs/templates/header/header-02.svg" height="84" width="350" />',
                'header-template-03' => '<img src="../wp-content/themes/king/layouts/imgs/templates/header/header-03.svg" height="84" width="350" />',
                'header-template-04' => '<img src="../wp-content/themes/king/layouts/imgs/templates/header/header-04.svg" height="84" width="350" />',
                'header-template-05' => '<img src="../wp-content/themes/king/layouts/imgs/templates/header/header-05.svg" height="130" width="350" />',
                'header-template-06' => '<img src="../wp-content/themes/king/layouts/imgs/templates/header/header-06.svg" height="84" width="350" />',
                'header-template-07' => '<img src="../wp-content/themes/king/layouts/imgs/templates/header/header-07.svg" height="130" width="350" />',
                'header-template-08' => '<img src="../wp-content/themes/king/layouts/imgs/templates/header/header-08.svg" height="130" width="350" />',
                'header-template-09' => '<img src="../wp-content/themes/king/layouts/imgs/templates/header/header-09.svg" height="130" width="350" />',
            ),
            'allow_null' => 0,
            'other_choice' => 0,
            'default_value' => '',
            'layout' => 'vertical',
            'return_format' => 'value',
            'save_other_choice' => 0,
        ),
        array(
            'key' => 'field_5e53da07acb39',
            'label' => __('Header 02 Options' , 'king' ),
            'name' => 'header_02_options',
            'type' => 'group',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5e28626d0b645',
                        'operator' => '==',
                        'value' => 'header-template-02',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'layout' => 'block',
            'sub_fields' => array(
                array(
                    'key' => 'field_5e53da07acb3a',
                    'label' => __('Page Margins' , 'king' ) ,
                    'name' => 'margin',
                    'type' => 'number',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 10,
                    'placeholder' => 'left and right margin',
                    'prepend' => '',
                    'append' => 'px',
                    'min' => 4,
                    'max' => 600,
                    'step' => '',
                ),
            ),
        ),
        array(
            'key' => 'field_5e53dbaa24f17',
            'label' => __('Header 03 Options' , 'king' ),
            'name' => 'header_03_options',
            'type' => 'group',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5e28626d0b645',
                        'operator' => '==',
                        'value' => 'header-template-03',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'layout' => 'block',
            'sub_fields' => array(
                array(
                    'key' => 'field_5e53dbaa24f18',
                    'label' => __('Top Header First Color of Background' , 'king' ) ,
                    'name' => 'background1',
                    'type' => 'color_picker',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'enable_opacity' => false,
                    'return_format' => 'string',
                ),
                array(
                    'key' => 'field_5e53dc0a24f19',
                    'label' => __('Top Header Second Color of Background' , 'king' ) ,
                    'name' => 'background2',
                    'type' => 'color_picker',
                    'instructions' => __('', 'king') , 
                    'required' => 1,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_5e53dbaa24f18',
                                'operator' => '!=empty',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'enable_opacity' => false,
                    'return_format' => 'string',
                ),
                array(
                    'key' => 'field_5e53df0ec83b0',
                    'label' => __('Font Color' , 'king' ) ,
                    'name' => 'font_color',
                    'type' => 'color_picker',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'enable_opacity' => false,
                    'return_format' => 'string',
                ),
                array(
                    'key' => 'field_5e7e38d8c7b48',
                    'label' => __('Top Header Right Icons' , 'king' ) ,
                    'name' => 'top_header_right_icons',
                    'type' => 'repeater',
                    'instructions' => __('You can add small icons at top bar', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'collapsed' => '',
                    'min' => 0,
                    'max' => 15,
                    'layout' => 'block',
                    'button_label' => 'Add Icon',
                    'sub_fields' => array(
                        array(
                            'key' => 'field_5e7e3958c7b49',
                            'label' => __('link url', 'king' ),
                            'name' => 'link_url',
                            'type' => 'url',
                            
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'placeholder' => 'url',
                        ),
                        array(
                            'key' => 'field_5e7e396ec7b4a',
                            'label' => __('Icon Code', 'king' ),
                            'name' => 'icon_code',
                            'type' => 'text',
                            'instructions' => __('You can select icons <a href="https://fontawesome.com/icons/" target="_blank">Here</a>', 'king' ) ,
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'placeholder' => '<i class="fas fa-crown"></i>',
                            'prepend' => 'code',
                            'append' => '',
                            'maxlength' => '',
                        ),
                    ),
                ),
            ),
        ),
        array(
            'key' => 'field_5e29be8d3c80f',
            'label' => __('Header 04 Options' , 'king' ),
            'name' => 'header_04_options',
            'type' => 'group',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5e28626d0b645',
                        'operator' => '==',
                        'value' => 'header-template-04',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'layout' => 'block',
            'sub_fields' => array(
                array(
                    'key' => 'field_5e2aba22fca80',
                    'label' => __('Ad Area Background' , 'king' ) ,
                    'name' => 'background',
                    'type' => 'color_picker',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'enable_opacity' => false,
                    'return_format' => 'string',
                ),
                array(
                    'key' => 'field_5e2aba956976a',
                    'label' => __('Ad Code' , 'king' ) ,
                    'name' => 'code',
                    'type' => 'textarea',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'placeholder' => 'Ad code ( HTML allowed )',
                    'maxlength' => '',
                    'rows' => 6,
                    'new_lines' => '',
                ),
                array(
                    'key' => 'field_5fc28afc5237e',
                    'label' => __('Height' , 'king' ) ,
                    'name' => 'top_height',
                    'type' => 'number',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => 'px',
                    'min' => '',
                    'max' => '',
                    'step' => '',
                ),
                array(
                    'key' => 'field_5fc28b225237f',
                    'label' => __('Background Image' , 'king' ) ,
                    'name' => 'top_background_image',
                    'type' => 'image',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'return_format' => 'url',
                    'preview_size' => 'thumbnail',
                    'library' => 'uploadedTo',
                    'min_width' => '',
                    'min_height' => '',
                    'min_size' => '',
                    'max_width' => '',
                    'max_height' => '',
                    'max_size' => '',
                    'mime_types' => '',
                ),
            ),
        ),
        array(
            'key' => 'field_5ed57df438c6d',
            'label' => __('Header 07 Options' , 'king' ),
            'name' => 'header_07_options',
            'type' => 'group',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5e28626d0b645',
                        'operator' => '==',
                        'value' => 'header-template-07',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'layout' => 'block',
            'sub_fields' => array(
                array(
                    'key' => 'field_5ed57df438c6e',
                    'label' => __('Header Position' , 'king' ) ,
                    'name' => 'position',
                    'type' => 'true_false',
                    'instructions' => __('Select header position', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                            'default_value' => 0,
                    'ui' => 1,
                    'ui_on_text' => 'Right',
                    'ui_off_text' => 'Left',
                ),
            ),
        ),
        array(
            'key' => 'field_5ee1260bb71fa',
            'label' => __('Header 08 Options' , 'king' ),
            'name' => 'header_08_options',
            'type' => 'group',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5e28626d0b645',
                        'operator' => '==',
                        'value' => 'header-template-08',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'layout' => 'block',
            'sub_fields' => array(
                array(
                    'key' => 'field_5ee1260bb71fd',
                    'label' => __('Font Color' , 'king' ) ,
                    'name' => 'font_color',
                    'type' => 'color_picker',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'enable_opacity' => false,
                    'return_format' => 'string',
                ),
                array(
                    'key' => 'field_5ee1260bb71fe',
                    'label' => __('Bottom Icons' , 'king' ) ,
                    'name' => 'bottom_icons',
                    'type' => 'repeater',
                    'instructions' => __('You can add small icons at bottom of right menu', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'collapsed' => '',
                    'min' => 0,
                    'max' => 10,
                    'layout' => 'block',
                    'button_label' => 'Add Icon',
                    'sub_fields' => array(
                        array(
                            'key' => 'field_5ee1260bb71ff',
                            'label' => __('link url', 'king' ),
                            'name' => 'link_url',
                            'type' => 'url',
                            
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'placeholder' => 'url',
                        ),
                        array(
                            'key' => 'field_5ee1260bb7200',
                            'label' => __('Icon Code', 'king' ),
                            'name' => 'icon_code',
                            'type' => 'text',
                            'instructions' => __('You can select icons <a href="https://fontawesome.com/icons/" target="_blank">Here</a>', 'king' ) ,
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'placeholder' => '<i class="fas fa-crown"></i>',
                            'prepend' => 'code',
                            'append' => '',
                            'maxlength' => '',
                        ),
                    ),
                ),
            ),
        ),
        array(
            'key' => 'field_5f9574b14efd0',
            'label' => __('Header Options' , 'king' ),
            'name' => 'header_09_options',
            'type' => 'group',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5e28626d0b645',
                        'operator' => '==',
                        'value' => 'header-template-06',
                    ),
                ),
                array(
                    array(
                        'field' => 'field_5e28626d0b645',
                        'operator' => '==',
                        'value' => 'header-template-09',
                    ),
                ),
                array(
                    array(
                        'field' => 'field_5e28626d0b645',
                        'operator' => '==',
                        'value' => 'header-template-05',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'layout' => 'block',
            'sub_fields' => array(
                array(
                    'key' => 'field_5f9574d24efd5',
                    'label' => __('Title of Header Nav' , 'king' ) ,
                    'name' => 'title_of_header_nav',
                    'type' => 'text',
                    'instructions' => __('you can add title for header nav links in left menu ( not required )', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'placeholder' => 'Menu',
                    'prepend' => 'text',
                    'append' => '',
                    'maxlength' => '',
                ),
                array(
                    'key' => 'field_5f95752b4efd6',
                    'label' => __('Title of Menu' , 'king' ) ,
                    'name' => 'title_of_menu',
                    'type' => 'text',
                    'instructions' => __('you can add title for menu links in left menu ( not required )', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'placeholder' => 'Links',
                    'prepend' => 'text',
                    'append' => '',
                    'maxlength' => '',
                ),
                array(
                    'key' => 'field_5f9800fc4be72',
                    'label' => __('Show Following Users' , 'king' ) ,
                    'name' => 'show_following_users',
                    'type' => 'true_false',
                    'instructions' => __('show following users in left menu', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                            'default_value' => 0,
                    'ui' => 1,
                    'ui_on_text' => '',
                    'ui_off_text' => '',
                ),
                array(
                    'key' => 'field_5f9801524be73',
                    'label' => __('Following Users Title' , 'king' ) ,
                    'name' => 'following_users_title',
                    'type' => 'text',
                    'instructions' => __('Add title for following users in left menu ( not required )', 'king') , 
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_5f9800fc4be72',
                                'operator' => '==',
                                'value' => '1',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'placeholder' => 'Subscriptions',
                    'prepend' => 'text',
                    'append' => '',
                    'maxlength' => '',
                ),
                array(
                    'key' => 'field_5f9576256aff6',
                    'label' => __('Left Menu Background' , 'king' ) ,
                    'name' => 'left_menu_background',
                    'type' => 'color_picker',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'enable_opacity' => false,
                    'return_format' => 'string',
                ),
                array(
                    'key' => 'field_5f9576496aff7',
                    'label' => __('Left Menu Links Color' , 'king' ) ,
                    'name' => 'left_menu_links_color',
                    'type' => 'color_picker',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'enable_opacity' => false,
                    'return_format' => 'string',
                ),
            ),
        ),
        array(
            'key' => 'field_5d4edff04a593',
            'label' => __('Posts Page' , 'king' ),
            'name' => '',
            'type' => 'tab',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'left',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_5d4ee03c4a594',
            'label' => __('Single Post Templates' , 'king' ),
            'name' => 'single_post_templates',
            'type' => 'radio',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array(
                'template-1' => '<img src="../wp-content/themes/king/layouts/imgs/templates/single/template-v1.svg" height="180" width="180" />',
                'template-2' => '<img src="../wp-content/themes/king/layouts/imgs/templates/single/template-v2.svg" height="180" width="180" />',
                'template-3' => '<img src="../wp-content/themes/king/layouts/imgs/templates/single/template-v3.svg" height="180" width="180" />',
                'template-4' => '<img src="../wp-content/themes/king/layouts/imgs/templates/single/template-v4.svg" height="180" width="180" />',
                'template-5' => '<img src="../wp-content/themes/king/layouts/imgs/templates/single/template-v5.svg" height="180" width="180" />',
                'template-6' => '<img src="../wp-content/themes/king/layouts/imgs/templates/single/template-v6.svg" height="180" width="180" />',
            ),
            'allow_null' => 1,
            'other_choice' => 0,
            'default_value' => '',
            'layout' => 'horizontal',
            'return_format' => 'value',
            'save_other_choice' => 0,
        ),
        array(
            'key' => 'field_5d4ee0794a595',
            'label' => __('Default Background' , 'king' ),
            'name' => 'default_background',
            'type' => 'image',
            'instructions' => __('You can select an image here to display if there is not featured image', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5d4ee03c4a594',
                        'operator' => '==',
                        'value' => 'template-3',
                    ),
                ),
                array(
                    array(
                        'field' => 'field_5d4ee03c4a594',
                        'operator' => '==',
                        'value' => 'template-4',
                    ),
                ),
                array(
                    array(
                        'field' => 'field_5d4ee03c4a594',
                        'operator' => '==',
                        'value' => 'template-5',
                    ),
                ),
                array(
                    array(
                        'field' => 'field_5d4ee03c4a594',
                        'operator' => '==',
                        'value' => 'template-6',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'return_format' => 'url',
            'preview_size' => 'medium',
            'library' => 'all',
            'min_width' => '',
            'min_height' => '',
            'min_size' => '',
            'max_width' => '',
            'max_height' => '',
            'max_size' => '',
            'mime_types' => '',
        ),
        array(
            'key' => 'field_5d4ee0cf4a599',
            'label' => __('Video Posts Templates' , 'king' ),
            'name' => 'video_posts_templates',
            'type' => 'radio',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array(
                'video-template-1' => '<img src="../wp-content/themes/king/layouts/imgs/templates/single/videotemplate-v1.svg" height="180" width="180" />',
                'video-template-2' => '<img src="../wp-content/themes/king/layouts/imgs/templates/single/videotemplate-v2.svg" height="180" width="180" />',
                'video-template-3' => '<img src="../wp-content/themes/king/layouts/imgs/templates/single/videotemplate-v3.svg" height="180" width="180" />',
            ),
            'allow_null' => 1,
            'other_choice' => 0,
            'default_value' => '',
            'layout' => 'horizontal',
            'return_format' => 'value',
            'save_other_choice' => 0,
        ),
        array(
            'key' => 'field_5d4ee1104a59a',
            'label' => __('Image Posts Templates' , 'king' ),
            'name' => 'image_posts_templates',
            'type' => 'radio',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array(
                'image-template-1' => '<img src="../wp-content/themes/king/layouts/imgs/templates/single/imagetemplate-v1.svg" height="180" width="180" />',
                'image-template-2' => '<img src="../wp-content/themes/king/layouts/imgs/templates/single/imagetemplate-v2.svg" height="180" width="180" />',
            ),
            'allow_null' => 1,
            'other_choice' => 0,
            'default_value' => '',
            'layout' => 'horizontal',
            'return_format' => 'value',
            'save_other_choice' => 0,
        ),
        array(
            'key' => 'field_60ad359f94397',
            'label' => __('Poll Posts Templates' , 'king' ),
            'name' => 'poll_posts_templates',
            'type' => 'radio',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array(
                'poll-template-1' => '<img src="../wp-content/themes/king/layouts/imgs/templates/single/polltemplate-v1.svg" height="180" width="180" />',
                'poll-template-2' => '<img src="../wp-content/themes/king/layouts/imgs/templates/single/polltemplate-v2.svg" height="180" width="180" />',
            ),
            'allow_null' => 1,
            'other_choice' => 0,
            'default_value' => '',
            'layout' => 'horizontal',
            'return_format' => 'value',
            'save_other_choice' => 0,
        ),
        array(
            'key' => 'field_60c4b3ad9aadb',
            'label' => __('Trivia Quiz Posts Templates' , 'king' ),
            'name' => 'trivia_quiz_posts_templates',
            'type' => 'radio',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array(
                'trivia-template-1' => '<img src="../wp-content/themes/king/layouts/imgs/templates/single/polltemplate-v1.svg" height="180" width="180" />',
                'trivia-template-2' => '<img src="../wp-content/themes/king/layouts/imgs/templates/single/polltemplate-v2.svg" height="180" width="180" />',
            ),
            'allow_null' => 1,
            'other_choice' => 0,
            'default_value' => '',
            'layout' => 'horizontal',
            'return_format' => 'value',
            'save_other_choice' => 0,
        ),
        array(
            'key' => 'field_5e5965f2be87b',
            'label' => __('Posts' , 'king' ),
            'name' => '',
            'type' => 'tab',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'left',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_5e59662fbe87c',
            'label' => __('Post Template' , 'king' ),
            'name' => 'select_default_display_option',
            'type' => 'radio',
            'instructions' => __('You can select default view option of your page,', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array(
                'king-grid-01' => '<img src="../wp-content/themes/king/layouts/imgs/templates/posts/posts-01.svg" height="220" width="220" />',
                'king-grid-02' => '<img src="../wp-content/themes/king/layouts/imgs/templates/posts/posts-02.svg" height="220" width="220" />',
                'king-grid-03' => '<img src="../wp-content/themes/king/layouts/imgs/templates/posts/posts-03.svg" height="220" width="220" />',
                'king-list' => '<img src="../wp-content/themes/king/layouts/imgs/templates/posts/posts-04.svg" height="220" width="220" />',
                'king-grid-04' => '<img src="../wp-content/themes/king/layouts/imgs/templates/posts/posts-05.svg" height="220" width="220" />',
                'king-grid-05' => '<img src="../wp-content/themes/king/layouts/imgs/templates/posts/posts-06.svg" height="220" width="220" />',
                'king-grid-06' => '<img src="../wp-content/themes/king/layouts/imgs/templates/posts/posts-07.svg" height="220" width="220" />',
                'king-grid-07' => '<img src="../wp-content/themes/king/layouts/imgs/templates/posts/posts-08.svg" height="220" width="220" />',
                'king-grid-08' => '<img src="../wp-content/themes/king/layouts/imgs/templates/posts/posts-09.svg" height="220" width="220" />',
                'king-grid-09' => '<img src="../wp-content/themes/king/layouts/imgs/templates/posts/posts-10.svg" height="220" width="220" />',
                'king-grid-10' => '<img src="../wp-content/themes/king/layouts/imgs/templates/posts/posts-11.svg" height="220" width="220" />',
                'king-grid-11' => '<img src="../wp-content/themes/king/layouts/imgs/templates/posts/posts-12.svg" height="220" width="220" />',
            ),
            'allow_null' => 0,
            'other_choice' => 0,
            'default_value' => '',
            'layout' => 'horizontal',
            'return_format' => 'value',
            'save_other_choice' => 0,
        ),
        array(
            'key' => 'field_5ed7df88c8c01',
            'label' => __('Padding Between Posts' , 'king' ),
            'name' => 'padding_between_posts',
            'type' => 'number',
            'instructions' => __('Select padding size between posts', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5e59662fbe87c',
                        'operator' => '==',
                        'value' => 'king-grid-10',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '100',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => 'padding',
            'append' => 'px',
            'min' => '',
            'max' => 40,
            'step' => '',
        ),
        array(
            'key' => 'field_5ed7e1a80346f',
            'label' => __('Border Radius of Posts' , 'king' ),
            'name' => 'border_radius_of_posts',
            'type' => 'number',
            'instructions' => __('Select border radius size of posts', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5e59662fbe87c',
                        'operator' => '==',
                        'value' => 'king-grid-10',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '100',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => 'radius',
            'append' => 'px',
            'min' => '',
            'max' => 40,
            'step' => '',
        ),
        array(
            'key' => 'field_5e56a74a8095c',
            'label' => __('Pagination' , 'king' ),
            'name' => '',
            'type' => 'tab',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'left',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_5e56a7618095d',
            'label' => __('Pagination Type' , 'king' ),
            'name' => 'pagination_type',
            'type' => 'radio',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array(
                'king-pagination-01' => '<img src="../wp-content/themes/king/layouts/imgs/templates/pagination/king-pagination-01.svg" height="96" width="400" />',
                'king-pagination-02' => '<img src="../wp-content/themes/king/layouts/imgs/templates/pagination/king-pagination-02.svg" height="96" width="400" />',
                'king-pagination-03' => '<img src="../wp-content/themes/king/layouts/imgs/templates/pagination/king-pagination-03.svg" height="96" width="400" />',
            ),
            'allow_null' => 0,
            'other_choice' => 0,
            'default_value' => '',
            'layout' => 'vertical',
            'return_format' => 'value',
            'save_other_choice' => 0,
        ),
        array(
            'key' => 'field_5e69103a459eb',
            'label' => __('Templates' , 'king' ),
            'name' => '',
            'type' => 'tab',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'left',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_61d420a81e11e',
            'label' => __('Homepage template' , 'king' ),
            'name' => 'homepage_template',
            'type' => 'group',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => 'ktemps',
                'id' => '',
            ),
            'layout' => 'block',
            'sub_fields' => array(
                array(
                    'key' => 'field_5e69104d459ec',
                    'label' => __('Sidebar' , 'king' ) ,
                    'name' => 'sidebar',
                    'type' => 'radio',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => 'radio-flex',
                        'id' => '',
                    ),
                    'choices' => array(
                        'king-sidebar-01' => '<img src="../wp-content/themes/king/layouts/imgs/templates/sidebar/sidebar-01.svg" height="127" width="127" />',
                        'king-sidebar-02' => '<img src="../wp-content/themes/king/layouts/imgs/templates/sidebar/sidebar-02.svg" height="127" width="127" />',
                        'king-sidebar-03' => '<img src="../wp-content/themes/king/layouts/imgs/templates/sidebar/sidebar-03.svg" height="127" width="127" />',
                        'king-sidebar-05' => '<img src="../wp-content/themes/king/layouts/imgs/templates/sidebar/sidebar-05.svg" height="127" width="127" />',
                        'king-sidebar-04' => '<img src="../wp-content/themes/king/layouts/imgs/templates/sidebar/sidebar-04.svg" height="127" width="127" />',
                    ),
                    'allow_null' => 0,
                    'other_choice' => 0,
                    'default_value' => '',
                    'layout' => 'horizontal',
                    'return_format' => 'value',
                    'save_other_choice' => 0,
                ),
                array(
                    'key' => 'field_61d420e31e11f',
                    'label' => __('Column' , 'king' ) ,
                    'name' => 'column',
                    'type' => 'radio',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => 'radio-flex',
                        'id' => '',
                    ),
                    'choices' => array(
                        'king-column-02' => '<img src="../wp-content/themes/king/layouts/imgs/templates/column/column-02.svg" height="80" width="127" />',
                        'king-column-03' => '<img src="../wp-content/themes/king/layouts/imgs/templates/column/column-03.svg" height="80" width="127" />',
                        'king-column-04' => '<img src="../wp-content/themes/king/layouts/imgs/templates/column/column-04.svg" height="80" width="127" />',
                        'king-column-05' => '<img src="../wp-content/themes/king/layouts/imgs/templates/column/column-05.svg" height="80" width="127" />',
                    ),
                    'allow_null' => 1,
                    'other_choice' => 0,
                    'default_value' => '',
                    'layout' => 'horizontal',
                    'return_format' => 'value',
                    'save_other_choice' => 0,
                ),
            ),
        ),
        array(
            'key' => 'field_61d4551c37fd0',
            'label' => __('Archive template' , 'king' ),
            'name' => 'archive_template',
            'type' => 'group',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => 'ktemps',
                'id' => '',
            ),
            'layout' => 'block',
            'sub_fields' => array(
                array(
                    'key' => 'field_61d4551c37fd1',
                    'label' => __('Sidebar' , 'king' ) ,
                    'name' => 'sidebar',
                    'type' => 'radio',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => 'radio-flex',
                        'id' => '',
                    ),
                    'choices' => array(
                        'king-sidebar-01' => '<img src="../wp-content/themes/king/layouts/imgs/templates/sidebar/sidebar-01.svg" height="127" width="127" />',
                        'king-sidebar-02' => '<img src="../wp-content/themes/king/layouts/imgs/templates/sidebar/sidebar-02.svg" height="127" width="127" />',
                        'king-sidebar-03' => '<img src="../wp-content/themes/king/layouts/imgs/templates/sidebar/sidebar-03.svg" height="127" width="127" />',
                        'king-sidebar-05' => '<img src="../wp-content/themes/king/layouts/imgs/templates/sidebar/sidebar-05.svg" height="127" width="127" />',
                        'king-sidebar-04' => '<img src="../wp-content/themes/king/layouts/imgs/templates/sidebar/sidebar-04.svg" height="127" width="127" />',
                    ),
                    'allow_null' => 0,
                    'other_choice' => 0,
                    'default_value' => '',
                    'layout' => 'horizontal',
                    'return_format' => 'value',
                    'save_other_choice' => 0,
                ),
                array(
                    'key' => 'field_61d4551c37fd2',
                    'label' => __('Column' , 'king' ) ,
                    'name' => 'column',
                    'type' => 'radio',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => 'radio-flex',
                        'id' => '',
                    ),
                    'choices' => array(
                        'king-column-02' => '<img src="../wp-content/themes/king/layouts/imgs/templates/column/column-02.svg" height="80" width="127" />',
                        'king-column-03' => '<img src="../wp-content/themes/king/layouts/imgs/templates/column/column-03.svg" height="80" width="127" />',
                        'king-column-04' => '<img src="../wp-content/themes/king/layouts/imgs/templates/column/column-04.svg" height="80" width="127" />',
                        'king-column-05' => '<img src="../wp-content/themes/king/layouts/imgs/templates/column/column-05.svg" height="80" width="127" />',
                    ),
                    'allow_null' => 1,
                    'other_choice' => 0,
                    'default_value' => '',
                    'layout' => 'horizontal',
                    'return_format' => 'value',
                    'save_other_choice' => 0,
                ),
            ),
        ),
        array(
            'key' => 'field_61d57ef337e5b',
            'label' => __('Search page template' , 'king' ),
            'name' => 'search_page_template',
            'type' => 'group',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => 'ktemps',
                'id' => '',
            ),
            'layout' => 'block',
            'sub_fields' => array(
                array(
                    'key' => 'field_61d57ef337e5c',
                    'label' => __('Sidebar' , 'king' ) ,
                    'name' => 'sidebar',
                    'type' => 'radio',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => 'radio-flex',
                        'id' => '',
                    ),
                    'choices' => array(
                        'king-sidebar-01' => '<img src="../wp-content/themes/king/layouts/imgs/templates/sidebar/sidebar-01.svg" height="127" width="127" />',
                        'king-sidebar-02' => '<img src="../wp-content/themes/king/layouts/imgs/templates/sidebar/sidebar-02.svg" height="127" width="127" />',
                        'king-sidebar-03' => '<img src="../wp-content/themes/king/layouts/imgs/templates/sidebar/sidebar-03.svg" height="127" width="127" />',
                        'king-sidebar-05' => '<img src="../wp-content/themes/king/layouts/imgs/templates/sidebar/sidebar-05.svg" height="127" width="127" />',
                        'king-sidebar-04' => '<img src="../wp-content/themes/king/layouts/imgs/templates/sidebar/sidebar-04.svg" height="127" width="127" />',
                    ),
                    'allow_null' => 0,
                    'other_choice' => 0,
                    'save_other_choice' => 0,
                    'default_value' => '',
                    'layout' => 'horizontal',
                    'return_format' => 'value',
                ),
                array(
                    'key' => 'field_61d57ef337e5d',
                    'label' => __('Column' , 'king' ) ,
                    'name' => 'column',
                    'type' => 'radio',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => 'radio-flex',
                        'id' => '',
                    ),
                    'choices' => array(
                        'king-column-02' => '<img src="../wp-content/themes/king/layouts/imgs/templates/column/column-02.svg" height="80" width="127" />',
                        'king-column-03' => '<img src="../wp-content/themes/king/layouts/imgs/templates/column/column-03.svg" height="80" width="127" />',
                        'king-column-04' => '<img src="../wp-content/themes/king/layouts/imgs/templates/column/column-04.svg" height="80" width="127" />',
                        'king-column-05' => '<img src="../wp-content/themes/king/layouts/imgs/templates/column/column-05.svg" height="80" width="127" />',
                    ),
                    'allow_null' => 1,
                    'other_choice' => 0,
                    'save_other_choice' => 0,
                    'default_value' => '',
                    'layout' => 'horizontal',
                    'return_format' => 'value',
                ),
            ),
        ),
        array(
            'key' => 'field_61d5a26b8d14f',
            'label' => __('Dashboard template' , 'king' ),
            'name' => 'dashboard_template',
            'type' => 'group',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => 'ktemps',
                'id' => '',
            ),
            'layout' => 'block',
            'sub_fields' => array(
                array(
                    'key' => 'field_61d5a26b8d150',
                    'label' => __('Sidebar' , 'king' ) ,
                    'name' => 'sidebar',
                    'type' => 'radio',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => 'radio-flex',
                        'id' => '',
                    ),
                    'choices' => array(
                        'king-sidebar-01' => '<img src="../wp-content/themes/king/layouts/imgs/templates/sidebar/sidebar-01.svg" height="127" width="127" />',
                        'king-sidebar-02' => '<img src="../wp-content/themes/king/layouts/imgs/templates/sidebar/sidebar-02.svg" height="127" width="127" />',
                        'king-sidebar-03' => '<img src="../wp-content/themes/king/layouts/imgs/templates/sidebar/sidebar-03.svg" height="127" width="127" />',
                        'king-sidebar-05' => '<img src="../wp-content/themes/king/layouts/imgs/templates/sidebar/sidebar-05.svg" height="127" width="127" />',
                        'king-sidebar-04' => '<img src="../wp-content/themes/king/layouts/imgs/templates/sidebar/sidebar-04.svg" height="127" width="127" />',
                    ),
                    'allow_null' => 0,
                    'other_choice' => 0,
                    'save_other_choice' => 0,
                    'default_value' => '',
                    'layout' => 'horizontal',
                    'return_format' => 'value',
                ),
                array(
                    'key' => 'field_61d5a26b8d151',
                    'label' => __('Column' , 'king' ) ,
                    'name' => 'column',
                    'type' => 'radio',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => 'radio-flex',
                        'id' => '',
                    ),
                    'choices' => array(
                        'king-column-02' => '<img src="../wp-content/themes/king/layouts/imgs/templates/column/column-02.svg" height="80" width="127" />',
                        'king-column-03' => '<img src="../wp-content/themes/king/layouts/imgs/templates/column/column-03.svg" height="80" width="127" />',
                        'king-column-04' => '<img src="../wp-content/themes/king/layouts/imgs/templates/column/column-04.svg" height="80" width="127" />',
                        'king-column-05' => '<img src="../wp-content/themes/king/layouts/imgs/templates/column/column-05.svg" height="80" width="127" />',
                    ),
                    'allow_null' => 1,
                    'other_choice' => 0,
                    'save_other_choice' => 0,
                    'default_value' => '',
                    'layout' => 'horizontal',
                    'return_format' => 'value',
                ),
            ),
        ),
        array(
            'key' => 'field_61d59359f7ccd',
            'label' => __('News page template' , 'king' ),
            'name' => 'news_page_template',
            'type' => 'group',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => 'ktemps',
                'id' => '',
            ),
            'layout' => 'block',
            'sub_fields' => array(
                array(
                    'key' => 'field_61d59359f7cce',
                    'label' => __('Sidebar' , 'king' ) ,
                    'name' => 'sidebar',
                    'type' => 'radio',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => 'radio-flex',
                        'id' => '',
                    ),
                    'choices' => array(
                        'king-sidebar-01' => '<img src="../wp-content/themes/king/layouts/imgs/templates/sidebar/sidebar-01.svg" height="127" width="127" />',
                        'king-sidebar-02' => '<img src="../wp-content/themes/king/layouts/imgs/templates/sidebar/sidebar-02.svg" height="127" width="127" />',
                        'king-sidebar-03' => '<img src="../wp-content/themes/king/layouts/imgs/templates/sidebar/sidebar-03.svg" height="127" width="127" />',
                        'king-sidebar-05' => '<img src="../wp-content/themes/king/layouts/imgs/templates/sidebar/sidebar-05.svg" height="127" width="127" />',
                        'king-sidebar-04' => '<img src="../wp-content/themes/king/layouts/imgs/templates/sidebar/sidebar-04.svg" height="127" width="127" />',
                    ),
                    'allow_null' => 0,
                    'other_choice' => 0,
                    'save_other_choice' => 0,
                    'default_value' => '',
                    'layout' => '',
                    'return_format' => '',
                ),
                array(
                    'key' => 'field_61d59359f7ccf',
                    'label' => __('Column' , 'king' ) ,
                    'name' => 'column',
                    'type' => 'radio',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => 'radio-flex',
                        'id' => '',
                    ),
                    'choices' => array(
                        'king-column-02' => '<img src="../wp-content/themes/king/layouts/imgs/templates/column/column-02.svg" height="80" width="127" />',
                        'king-column-03' => '<img src="../wp-content/themes/king/layouts/imgs/templates/column/column-03.svg" height="80" width="127" />',
                        'king-column-04' => '<img src="../wp-content/themes/king/layouts/imgs/templates/column/column-04.svg" height="80" width="127" />',
                        'king-column-05' => '<img src="../wp-content/themes/king/layouts/imgs/templates/column/column-05.svg" height="80" width="127" />',
                    ),
                    'allow_null' => 1,
                    'other_choice' => 0,
                    'save_other_choice' => 0,
                    'default_value' => '',
                    'layout' => '',
                    'return_format' => '',
                ),
            ),
        ),
        array(
            'key' => 'field_61d593faf7cd0',
            'label' => __('Videos page template' , 'king' ),
            'name' => 'videos_page_template',
            'type' => 'group',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => 'ktemps',
                'id' => '',
            ),
            'layout' => 'block',
            'sub_fields' => array(
                array(
                    'key' => 'field_61d593faf7cd1',
                    'label' => __('Sidebar' , 'king' ) ,
                    'name' => 'sidebar',
                    'type' => 'radio',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => 'radio-flex',
                        'id' => '',
                    ),
                    'choices' => array(
                        'king-sidebar-01' => '<img src="../wp-content/themes/king/layouts/imgs/templates/sidebar/sidebar-01.svg" height="127" width="127" />',
                        'king-sidebar-02' => '<img src="../wp-content/themes/king/layouts/imgs/templates/sidebar/sidebar-02.svg" height="127" width="127" />',
                        'king-sidebar-03' => '<img src="../wp-content/themes/king/layouts/imgs/templates/sidebar/sidebar-03.svg" height="127" width="127" />',
                        'king-sidebar-05' => '<img src="../wp-content/themes/king/layouts/imgs/templates/sidebar/sidebar-05.svg" height="127" width="127" />',
                        'king-sidebar-04' => '<img src="../wp-content/themes/king/layouts/imgs/templates/sidebar/sidebar-04.svg" height="127" width="127" />',
                    ),
                    'allow_null' => 0,
                    'other_choice' => 0,
                    'save_other_choice' => 0,
                    'default_value' => '',
                    'layout' => '',
                    'return_format' => '',
                ),
                array(
                    'key' => 'field_61d593faf7cd2',
                    'label' => __('Column' , 'king' ) ,
                    'name' => 'column',
                    'type' => 'radio',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => 'radio-flex',
                        'id' => '',
                    ),
                    'choices' => array(
                        'king-column-02' => '<img src="../wp-content/themes/king/layouts/imgs/templates/column/column-02.svg" height="80" width="127" />',
                        'king-column-03' => '<img src="../wp-content/themes/king/layouts/imgs/templates/column/column-03.svg" height="80" width="127" />',
                        'king-column-04' => '<img src="../wp-content/themes/king/layouts/imgs/templates/column/column-04.svg" height="80" width="127" />',
                        'king-column-05' => '<img src="../wp-content/themes/king/layouts/imgs/templates/column/column-05.svg" height="80" width="127" />',
                    ),
                    'allow_null' => 1,
                    'other_choice' => 0,
                    'save_other_choice' => 0,
                    'default_value' => '',
                    'layout' => '',
                    'return_format' => '',
                ),
            ),
        ),
        array(
            'key' => 'field_61d59421f7cd3',
            'label' => __('Images page template' , 'king' ),
            'name' => 'images_page_template',
            'type' => 'group',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => 'ktemps',
                'id' => '',
            ),
            'layout' => 'block',
            'sub_fields' => array(
                array(
                    'key' => 'field_61d59421f7cd4',
                    'label' => __('Sidebar' , 'king' ) ,
                    'name' => 'sidebar',
                    'type' => 'radio',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => 'radio-flex',
                        'id' => '',
                    ),
                    'choices' => array(
                        'king-sidebar-01' => '<img src="../wp-content/themes/king/layouts/imgs/templates/sidebar/sidebar-01.svg" height="127" width="127" />',
                        'king-sidebar-02' => '<img src="../wp-content/themes/king/layouts/imgs/templates/sidebar/sidebar-02.svg" height="127" width="127" />',
                        'king-sidebar-03' => '<img src="../wp-content/themes/king/layouts/imgs/templates/sidebar/sidebar-03.svg" height="127" width="127" />',
                        'king-sidebar-05' => '<img src="../wp-content/themes/king/layouts/imgs/templates/sidebar/sidebar-05.svg" height="127" width="127" />',
                        'king-sidebar-04' => '<img src="../wp-content/themes/king/layouts/imgs/templates/sidebar/sidebar-04.svg" height="127" width="127" />',
                    ),
                    'allow_null' => 0,
                    'other_choice' => 0,
                    'save_other_choice' => 0,
                    'default_value' => '',
                    'layout' => 'horizontal',
                    'return_format' => 'value',
                ),
                array(
                    'key' => 'field_61d59421f7cd5',
                    'label' => __('Column' , 'king' ) ,
                    'name' => 'column',
                    'type' => 'radio',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => 'radio-flex',
                        'id' => '',
                    ),
                    'choices' => array(
                        'king-column-02' => '<img src="../wp-content/themes/king/layouts/imgs/templates/column/column-02.svg" height="80" width="127" />',
                        'king-column-03' => '<img src="../wp-content/themes/king/layouts/imgs/templates/column/column-03.svg" height="80" width="127" />',
                        'king-column-04' => '<img src="../wp-content/themes/king/layouts/imgs/templates/column/column-04.svg" height="80" width="127" />',
                        'king-column-05' => '<img src="../wp-content/themes/king/layouts/imgs/templates/column/column-05.svg" height="80" width="127" />',
                    ),
                    'allow_null' => 1,
                    'other_choice' => 0,
                    'save_other_choice' => 0,
                    'default_value' => '',
                    'layout' => 'horizontal',
                    'return_format' => 'value',
                ),
            ),
        ),
        array(
            'key' => 'field_61d5a5838b402',
            'label' => __('Profile template' , 'king' ),
            'name' => 'profile_template',
            'type' => 'group',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => 'ktemps',
                'id' => '',
            ),
            'layout' => 'block',
            'sub_fields' => array(
                array(
                    'key' => 'field_61d5a5838b404',
                    'label' => __('Column' , 'king' ) ,
                    'name' => 'column',
                    'type' => 'radio',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => 'radio-flex',
                        'id' => '',
                    ),
                    'choices' => array(
                        'king-column-02' => '<img src="../wp-content/themes/king/layouts/imgs/templates/column/column-02.svg" height="80" width="127" />',
                        'king-column-03' => '<img src="../wp-content/themes/king/layouts/imgs/templates/column/column-03.svg" height="80" width="127" />',
                        'king-column-04' => '<img src="../wp-content/themes/king/layouts/imgs/templates/column/column-04.svg" height="80" width="127" />',
                        'king-column-05' => '<img src="../wp-content/themes/king/layouts/imgs/templates/column/column-05.svg" height="80" width="127" />',
                    ),
                    'allow_null' => 1,
                    'other_choice' => 0,
                    'save_other_choice' => 0,
                    'default_value' => '',
                    'layout' => 'horizontal',
                    'return_format' => 'value',
                ),
            ),
        ),
        array(
            'key' => 'field_5eadb0c9e9e3b',
            'label' => __('Image Gallery' , 'king' ),
            'name' => '',
            'type' => 'tab',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'left',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_5eadb0f9e9e3c',
            'label' => __('Gallery layout' , 'king' ),
            'name' => 'gallery_layout',
            'type' => 'radio',
            'instructions' => __('Select gallery layout for images posts', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array(
                'king-gallery-01' => '<img src="../wp-content/themes/king/layouts/imgs/templates/gallery/gallery-01.svg" height="220" width="220" />',
                'king-gallery-02' => '<img src="../wp-content/themes/king/layouts/imgs/templates/gallery/gallery-02.svg" height="220" width="220" />',
                'king-gallery-03' => '<img src="../wp-content/themes/king/layouts/imgs/templates/gallery/gallery-03.svg" height="220" width="220" />',
            ),
            'allow_null' => 0,
            'other_choice' => 0,
            'default_value' => 'king-gallery-01',
            'layout' => 'horizontal',
            'return_format' => 'value',
            'save_other_choice' => 0,
        ),
        array(
            'key' => 'field_5eb5a80b9380e',
            'label' => __('Enable lightbox gallery' , 'king' ),
            'name' => 'enable_lightbox_gallery',
            'type' => 'true_false',
            'instructions' => __('enable lightbox view for multiple images, users can see images with full width', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_5eb6dfac3b094',
            'label' => __('Gallery background' , 'king' ),
            'name' => 'gallery_background',
            'type' => 'color_picker',
            'instructions' => __('select color for the background of lightbox gallery', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5eb5a80b9380e',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5eb6e037ec85a',
            'label' => __('Gallery text color' , 'king' ),
            'name' => 'gallery_text_color',
            'type' => 'color_picker',
            'instructions' => __('select color for the texts in lightbox gallery', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5eb5a80b9380e',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5eb5bbe5f6fd2',
            'label' => __('Enable lightbox ad' , 'king' ),
            'name' => 'enable_lightbox_ad',
            'type' => 'true_false',
            'instructions' => __('enable ad in lightbox gallery', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5eb5a80b9380e',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_5eb5bc46f6fd3',
            'label' => __('Lightbox gallery ad code' , 'king' ),
            'name' => 'lightbox_gallery_ad_code',
            'type' => 'textarea',
            
            'required' => 1,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5eb5bbe5f6fd2',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'ad code here HTML allowed',
            'maxlength' => '',
            'rows' => 6,
            'new_lines' => '',
        ),
        array(
            'key' => 'field_5ec94b465a36c',
            'label' => __('Slider' , 'king' ),
            'name' => '',
            'type' => 'tab',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'left',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_5ec94b505a36d',
            'label' => __('Display Slider' , 'king' ),
            'name' => 'display_slider',
            'type' => 'true_false',
            'instructions' => __('if you select this slider will be displayed at home page', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Display Slider', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_5ec94e7246167',
            'label' => __('Slider Template' , 'king' ),
            'name' => 'slider_template',
            'type' => 'radio',
            'instructions' => __('Select slider template', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5ec94b505a36d',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array(
                'slider-template-1' => '<img src="../wp-content/themes/king/layouts/imgs/templates/slider/slider1.svg" height="220" width="220" />',
                'slider-template-2' => '<img src="../wp-content/themes/king/layouts/imgs/templates/slider/slider2.svg" height="220" width="220" />',
                'slider-template-3' => '<img src="../wp-content/themes/king/layouts/imgs/templates/slider/slider3.svg" height="220" width="220" />',
            ),
            'allow_null' => 0,
            'other_choice' => 0,
            'default_value' => '',
            'layout' => 'horizontal',
            'return_format' => 'value',
            'save_other_choice' => 0,
        ),
        array(
            'key' => 'field_5ec94b83e3e5a',
            'label' => __('Show in Slider' , 'king' ),
            'name' => 'show_slider',
            'type' => 'select',
            'instructions' => __('if you select this slider will be displayed at home page', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5ec94b505a36d',
                        'operator' => '==',
                        'value' => '1',
                    ),
                    array(
                        'field' => 'field_5ec94e7246167',
                        'operator' => '==',
                        'value' => 'slider-template-1',
                    ),
                ),
                array(
                    array(
                        'field' => 'field_5ec94b505a36d',
                        'operator' => '==',
                        'value' => '1',
                    ),
                    array(
                        'field' => 'field_5ec94e7246167',
                        'operator' => '==',
                        'value' => 'slider-template-2',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array(
                'featured-post' => 'Featured Posts',
                'keep_trending' => 'Trending Posts',
                'editors_choice' => 'Editors’ Choice',
                'most_views' => 'Most Views',
                'most_likes' => 'Most Likes',
            ),
            'default_value' => false,
            'allow_null' => 0,
            'multiple' => 0,
            'ui' => 0,
            'return_format' => 'value',
            'ajax' => 0,
            'placeholder' => '',
        ),
        array(
            'key' => 'field_5ec94bf0e3e5c',
            'label' => __('Select Grid Template' , 'king' ),
            'name' => 'select_grid_template',
            'type' => 'radio',
            'instructions' => __('You can select grid template', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5ec94b505a36d',
                        'operator' => '==',
                        'value' => '1',
                    ),
                    array(
                        'field' => 'field_5ec94e7246167',
                        'operator' => '==',
                        'value' => 'slider-template-1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array(
                'grid-template-1' => '<img src="../wp-content/themes/king/layouts/imgs/grid/grid-1.svg" height="140" width="160" />',
                'grid-template-2' => '<img src="../wp-content/themes/king/layouts/imgs/grid/grid-2.svg" height="140" width="160" />',
                'grid-template-3' => '<img src="../wp-content/themes/king/layouts/imgs/grid/grid-3.svg" height="140" width="160" />',
                'grid-template-4' => '<img src="../wp-content/themes/king/layouts/imgs/grid/grid-4.svg" height="140" width="160" />',
                'grid-template-5' => '<img src="../wp-content/themes/king/layouts/imgs/grid/grid-5.svg" height="140" width="160" />',
                'grid-template-6' => '<img src="../wp-content/themes/king/layouts/imgs/grid/grid-6.svg" height="140" width="160" />',
                'grid-template-7' => '<img src="../wp-content/themes/king/layouts/imgs/grid/grid-7.svg" height="140" width="160" />',
                'grid-template-8' => '<img src="../wp-content/themes/king/layouts/imgs/grid/grid-8.svg" height="140" width="160" />',
                'grid-template-9' => '<img src="../wp-content/themes/king/layouts/imgs/grid/grid-9.svg" height="140" width="160" />',
                'grid-template-10' => '<img src="../wp-content/themes/king/layouts/imgs/grid/grid-10.svg" height="140" width="160" />',
                'grid-template-11' => '<img src="../wp-content/themes/king/layouts/imgs/grid/grid-11.svg" height="140" width="160" />',
                'grid-template-12' => '<img src="../wp-content/themes/king/layouts/imgs/grid/grid-12.svg" height="140" width="160" />',
                'grid-template-13' => '<img src="../wp-content/themes/king/layouts/imgs/grid/grid-13.svg" height="140" width="160" />',
            ),
            'allow_null' => 0,
            'other_choice' => 0,
            'default_value' => '',
            'layout' => 'horizontal',
            'return_format' => 'value',
            'save_other_choice' => 0,
        ),
        array(
            'key' => 'field_5ec94c68998ff',
            'label' => __('Grid Height' , 'king' ),
            'name' => 'grid_height',
            'type' => 'number',
            'instructions' => __('You can change the grid height', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5ec94b505a36d',
                        'operator' => '==',
                        'value' => '1',
                    ),
                    array(
                        'field' => 'field_5ec94e7246167',
                        'operator' => '==',
                        'value' => 'slider-template-1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => 'height',
            'append' => 'px',
            'min' => 100,
            'max' => 1500,
            'step' => 10,
        ),
        array(
            'key' => 'field_5ed7e45c59192',
            'label' => __('Padding Between Grid Posts' , 'king' ),
            'name' => 'padding_between_grid_posts',
            'type' => 'number',
            'instructions' => __('You can change the padding between grid posts', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5ec94b505a36d',
                        'operator' => '==',
                        'value' => '1',
                    ),
                    array(
                        'field' => 'field_5ec94e7246167',
                        'operator' => '==',
                        'value' => 'slider-template-1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => 'padding',
            'append' => 'px',
            'min' => '',
            'max' => 80,
            'step' => '',
        ),
        array(
            'key' => 'field_5ed7e4aa59193',
            'label' => __('Border Radius of Grid Posts' , 'king' ),
            'name' => 'border_radius_of_grid_posts',
            'type' => 'number',
            'instructions' => __('You can change the border radius of grid posts', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5ec94b505a36d',
                        'operator' => '==',
                        'value' => '1',
                    ),
                    array(
                        'field' => 'field_5ec94e7246167',
                        'operator' => '==',
                        'value' => 'slider-template-1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => 'radius',
            'append' => 'px',
            'min' => '',
            'max' => 80,
            'step' => '',
        ),
        array(
            'key' => 'field_5ec94d0b086c1',
            'label' => __('Slider Height' , 'king' ),
            'name' => 'slider_height',
            'type' => 'number',
            'instructions' => __('You can change the slider height', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5ec94b505a36d',
                        'operator' => '==',
                        'value' => '1',
                    ),
                    array(
                        'field' => 'field_5ec94e7246167',
                        'operator' => '==',
                        'value' => 'slider-template-2',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => 'height',
            'append' => 'px',
            'min' => 100,
            'max' => 1100,
            'step' => 10,
        ),
        array(
            'key' => 'field_5ec94d3b086c2',
            'label' => __('Length of Posts in Slider' , 'king' ),
            'name' => 'length_slider',
            'type' => 'number',
            'instructions' => __('Length of Posts in Slider', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5ec94b505a36d',
                        'operator' => '==',
                        'value' => '1',
                    ),
                    array(
                        'field' => 'field_5ec94e7246167',
                        'operator' => '==',
                        'value' => 'slider-template-2',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 4,
            'placeholder' => '',
            'prepend' => 'Slider Posts',
            'append' => '',
            'min' => 1,
            'max' => 50,
            'step' => '',
        ),
        array(
            'key' => 'field_5ec94d74086c3',
            'label' => __('Items Length' , 'king' ),
            'name' => 'items_length',
            'type' => 'number',
            'instructions' => __('This variable allows you to set the maximum amount of items displayed at a time with the widest browser width', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5ec94b505a36d',
                        'operator' => '==',
                        'value' => '1',
                    ),
                    array(
                        'field' => 'field_5ec94e7246167',
                        'operator' => '==',
                        'value' => 'slider-template-2',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 1,
            'placeholder' => '',
            'prepend' => 'Items Length',
            'append' => '',
            'min' => 1,
            'max' => 16,
            'step' => '',
        ),
        array(
            'key' => 'field_5ec964ac47a82',
            'label' => __('Video' , 'king' ),
            'name' => 'slider_video',
            'type' => 'file',
            'instructions' => __('Select video file for background', 'king' ) ,
            'required' => 1,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5ec94b505a36d',
                        'operator' => '==',
                        'value' => '1',
                    ),
                    array(
                        'field' => 'field_5ec94e7246167',
                        'operator' => '==',
                        'value' => 'slider-template-3',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'return_format' => 'url',
            'library' => 'all',
            'min_size' => '',
            'max_size' => '',
            'mime_types' => 'mp4',
        ),
        array(
            'key' => 'field_5ec965abc520f',
            'label' => __('Header' , 'king' ),
            'name' => 'slider_video_header',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5ec94b505a36d',
                        'operator' => '==',
                        'value' => '1',
                    ),
                    array(
                        'field' => 'field_5ec94e7246167',
                        'operator' => '==',
                        'value' => 'slider-template-3',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => 'Text',
            'append' => '',
            'maxlength' => '',
        ),
        array(
            'key' => 'field_5ec96684c5210',
            'label' => __('Description' , 'king' ),
            'name' => 'slider_video_description',
            'type' => 'textarea',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5ec94b505a36d',
                        'operator' => '==',
                        'value' => '1',
                    ),
                    array(
                        'field' => 'field_5ec94e7246167',
                        'operator' => '==',
                        'value' => 'slider-template-3',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'maxlength' => '',
            'rows' => 4,
            'new_lines' => '',
        ),
        array(
            'key' => 'field_5ec98844abd92',
            'label' => __('Button Link' , 'king' ),
            'name' => 'slider_video_button_link',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5ec94b505a36d',
                        'operator' => '==',
                        'value' => '1',
                    ),
                    array(
                        'field' => 'field_5ec94e7246167',
                        'operator' => '==',
                        'value' => 'slider-template-3',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '60',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => 'Link',
            'append' => '',
            'maxlength' => '',
        ),
        array(
            'key' => 'field_5ec988d9abd93',
            'label' => __('Button Text' , 'king' ),
            'name' => 'slider_video_button_text',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5ec94b505a36d',
                        'operator' => '==',
                        'value' => '1',
                    ),
                    array(
                        'field' => 'field_5ec94e7246167',
                        'operator' => '==',
                        'value' => 'slider-template-3',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '40',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => 'Text',
            'append' => '',
            'maxlength' => '',
        ),
        array(
            'key' => 'field_5ec9498a29f77',
            'label' => __('Mini Slider' , 'king' ),
            'name' => '',
            'type' => 'tab',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'left',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_5ec949ddf486d',
            'label' => __('Display Mini Slider' , 'king' ),
            'name' => 'display_mini_slider',
            'type' => 'true_false',
            'instructions' => __('you can enable mini slider', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' enable mini slider', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_5f930538d0503',
            'label' => __('Mini Slider Title' , 'king' ),
            'name' => 'mini_slider_title',
            'type' => 'text',
            'instructions' => __('You can add title for mini slider ( not required )', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5ec949ddf486d',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => 'text',
            'append' => '',
            'maxlength' => 150,
        ),
        array(
            'key' => 'field_5ec94a5f08aa2',
            'label' => __('Show in Mini Slider' , 'king' ),
            'name' => 'show_in_mini_slider',
            'type' => 'select',
            'instructions' => __('you can enable mini slider', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5ec949ddf486d',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array(
                'featured-post' => 'Featured Posts',
                'keep_trending' => 'Trending Posts',
                'editors_choice' => 'Editors’ Choice',
                'show_categories' => 'Show Categories',
            ),
            'default_value' => false,
            'allow_null' => 0,
            'multiple' => 0,
            'ui' => 0,
            'return_format' => 'value',
            'ajax' => 0,
            'placeholder' => '',
        ),
        array(
            'key' => 'field_5ec94a8808aa3',
            'label' => __('Mini slider post height' , 'king' ),
            'name' => 'mini_slider_post_height',
            'type' => 'number',
            'instructions' => __('you can change mini slider posts height', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5ec949ddf486d',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => 'height',
            'append' => 'px',
            'min' => 100,
            'max' => 800,
            'step' => 10,
        ),
        array(
            'key' => 'field_5f930274cf35c',
            'label' => __('Mini slider paddings' , 'king' ),
            'name' => 'mini_slider_paddings',
            'type' => 'number',
            'instructions' => __('you can select mini slider padding size right and left side', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5ec949ddf486d',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => 'padding',
            'append' => 'px',
            'min' => 0,
            'max' => 400,
            'step' => '',
        ),
        array(
            'key' => 'field_5fa1575764b5e',
            'label' => __('Post Number in Mini Slider' , 'king' ),
            'name' => 'post_number_in_mini_slider',
            'type' => 'number',
            'instructions' => __('Posts number in mini slider', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5ec949ddf486d',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 6,
            'placeholder' => '',
            'prepend' => 'Posts',
            'append' => '',
            'min' => 1,
            'max' => 99,
            'step' => '',
        ),
        array(
            'key' => 'field_5ec94adbb2b61',
            'label' => __('Mini Slider Items Length' , 'king' ),
            'name' => 'mini_items_length',
            'type' => 'number',
            'instructions' => __('This variable allows you to set the maximum amount of items displayed at a time with the widest browser width', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5ec949ddf486d',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 6,
            'placeholder' => '',
            'prepend' => 'Items Length',
            'append' => '',
            'min' => 1,
            'max' => 16,
            'step' => '',
        ),
        array(
            'key' => 'field_5f7f356f014bd',
            'label' => __('Header Nav' , 'king' ),
            'name' => '',
            'type' => 'tab',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'top',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_60bf95fc1bfd1',
            'label' => __('Header Nav' , 'king' ),
            'name' => 'king_header_nav',
            'type' => 'checkbox',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array(
                'news_link' => 'News',
                'videos_link' => 'Video',
                'images_link' => 'Image',
                'musics_link' => 'Music',
                'lists_link' => 'List',
                'polls_link' => 'Polls',
                'quiz_link' => 'Trivia Quiz',
            ),
            'allow_custom' => 0,
            'default_value' => array(
                0 => 'news_link',
                1 => 'videos_link',
                2 => 'images_link',
                3 => 'musics_link',
            ),
            'layout' => 'horizontal',
            'toggle' => 0,
            'return_format' => 'value',
            'save_custom' => 0,
        ),
        array(
            'key' => 'field_5f7f39ca32e76',
            'label' => __('News Mega Menu' , 'king' ),
            'name' => 'for_news_link',
            'type' => 'group',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_60bf95fc1bfd1',
                        'operator' => '==',
                        'value' => 'news_link',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'layout' => 'block',
            'sub_fields' => array(
                array(
                    'key' => 'field_5f7f3ce893e52',
                    'label' => __('for news link' , 'king' ) ,
                    'name' => 'for_news',
                    'type' => 'true_false',
                    'instructions' => __('enable mega menu for news link', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '33',
                        'class' => '',
                        'id' => '',
                    ),
                            'default_value' => 0,
                    'ui' => 1,
                    'ui_on_text' => '',
                    'ui_off_text' => '',
                ),
                array(
                    'key' => 'field_5f7f3d8180484',
                    'label' => __('show in mega menu' , 'king' ) ,
                    'name' => 'show_in_mega_menu',
                    'type' => 'select',
                    'instructions' => __('select post order', 'king') , 
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_5f7f3ce893e52',
                                'operator' => '==',
                                'value' => '1',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '33',
                        'class' => '',
                        'id' => '',
                    ),
                    'choices' => array(
                        'recent' => 'recent news',
                        'popular' => 'popular news',
                    ),
                    'default_value' => false,
                    'allow_null' => 0,
                    'multiple' => 0,
                    'ui' => 0,
                    'return_format' => 'value',
                    'ajax' => 0,
                    'placeholder' => '',
                ),
                array(
                    'key' => 'field_5f82f74ba9456',
                    'label' => __('post number' , 'king' ) ,
                    'name' => 'mpost_number',
                    'type' => 'range',
                    'instructions' => __('number of posts display in mega menu', 'king') , 
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_5f7f3ce893e52',
                                'operator' => '==',
                                'value' => '1',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '33',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 5,
                    'min' => 1,
                    'max' => 10,
                    'step' => '',
                    'prepend' => 'posts',
                    'append' => '',
                ),
                array(
                    'key' => 'field_5f7f3e33d0bca',
                    'label' => __('add links in mega menu' , 'king' ) ,
                    'name' => 'links_in_mega_menu',
                    'type' => 'repeater',
                    'instructions' => __('you can add extra links in mega menu', 'king') , 
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_5f7f3ce893e52',
                                'operator' => '==',
                                'value' => '1',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'collapsed' => 'field_5f7f3f6fd0bcb',
                    'min' => 0,
                    'max' => 30,
                    'layout' => 'block',
                    'button_label' => 'add new link',
                    'sub_fields' => array(
                        array(
                            'key' => 'field_5f7f3f6fd0bcb',
                            'label' => __('mega menu link text', 'king' ),
                            'name' => 'mega_menu_link_text',
                            'type' => 'text',
                            
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '50',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'placeholder' => '',
                            'prepend' => 'text',
                            'append' => '',
                            'maxlength' => '',
                        ),
                        array(
                            'key' => 'field_5f7f3f9cd0bcc',
                            'label' => __('mega menu link url', 'king' ),
                            'name' => 'mega_menu_link_url',
                            'type' => 'url',
                            
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '50',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'placeholder' => 'url',
                        ),
                    ),
                ),
            ),
        ),
        array(
            'key' => 'field_5f7f4080e9145',
            'label' => __('Video Mega Menu' , 'king' ),
            'name' => 'for_video_link',
            'type' => 'group',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_60bf95fc1bfd1',
                        'operator' => '==',
                        'value' => 'videos_link',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'layout' => 'block',
            'sub_fields' => array(
                array(
                    'key' => 'field_5f7f4080e9146',
                    'label' => __('for video link' , 'king' ) ,
                    'name' => 'for_video',
                    'type' => 'true_false',
                    'instructions' => __('enable mega menu for video link', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '33',
                        'class' => '',
                        'id' => '',
                    ),
                            'default_value' => 0,
                    'ui' => 1,
                    'ui_on_text' => '',
                    'ui_off_text' => '',
                ),
                array(
                    'key' => 'field_5f7f4080e9147',
                    'label' => __('show in mega menu' , 'king' ) ,
                    'name' => 'show_in_mega_menu',
                    'type' => 'select',
                    'instructions' => __('select which posts you like to show in video mega menu', 'king') , 
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_5f7f4080e9146',
                                'operator' => '==',
                                'value' => '1',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '33',
                        'class' => '',
                        'id' => '',
                    ),
                    'choices' => array(
                        'recent' => 'recent videos',
                        'popular' => 'popular videos',
                    ),
                    'default_value' => false,
                    'allow_null' => 0,
                    'multiple' => 0,
                    'ui' => 0,
                    'return_format' => 'value',
                    'ajax' => 0,
                    'placeholder' => '',
                ),
                array(
                    'key' => 'field_5f82f8695f624',
                    'label' => __('post number' , 'king' ) ,
                    'name' => 'mpost_number',
                    'type' => 'range',
                    'instructions' => __('number of posts display in mega menu', 'king') , 
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_5f7f4080e9146',
                                'operator' => '==',
                                'value' => '1',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '33',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 5,
                    'min' => 1,
                    'max' => 10,
                    'step' => '',
                    'prepend' => 'posts',
                    'append' => '',
                ),
                array(
                    'key' => 'field_5f7f4080e9148',
                    'label' => __('add links in mega menu' , 'king' ) ,
                    'name' => 'links_in_mega_menu',
                    'type' => 'repeater',
                    'instructions' => __('you can add extra links in mega menu', 'king') , 
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_5f7f4080e9146',
                                'operator' => '==',
                                'value' => '1',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'collapsed' => 'field_5f7f3f6fd0bcb',
                    'min' => 0,
                    'max' => 30,
                    'layout' => 'block',
                    'button_label' => 'add new link',
                    'sub_fields' => array(
                        array(
                            'key' => 'field_5f7f4080e9149',
                            'label' => __('mega menu link text', 'king' ),
                            'name' => 'mega_menu_link_text',
                            'type' => 'text',
                            
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '50',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'placeholder' => '',
                            'prepend' => 'text',
                            'append' => '',
                            'maxlength' => '',
                        ),
                        array(
                            'key' => 'field_5f7f4080e914a',
                            'label' => __('mega menu link url', 'king' ),
                            'name' => 'mega_menu_link_url',
                            'type' => 'url',
                            
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '50',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'placeholder' => 'url',
                        ),
                    ),
                ),
            ),
        ),
        array(
            'key' => 'field_5f7f403c31e59',
            'label' => __('Image Mega Menu' , 'king' ),
            'name' => 'for_image_link',
            'type' => 'group',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_60bf95fc1bfd1',
                        'operator' => '==',
                        'value' => 'images_link',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'layout' => 'block',
            'sub_fields' => array(
                array(
                    'key' => 'field_5f7f403c31e5a',
                    'label' => __('for image link' , 'king' ) ,
                    'name' => 'for_image',
                    'type' => 'true_false',
                    'instructions' => __('enable mega menu for image link', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '33',
                        'class' => '',
                        'id' => '',
                    ),
                            'default_value' => 0,
                    'ui' => 1,
                    'ui_on_text' => '',
                    'ui_off_text' => '',
                ),
                array(
                    'key' => 'field_5f7f403c31e5b',
                    'label' => __('show in mega menu' , 'king' ) ,
                    'name' => 'show_in_mega_menu',
                    'type' => 'select',
                    'instructions' => __('select which posts you like to show in image mega menu', 'king') , 
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_5f7f403c31e5a',
                                'operator' => '==',
                                'value' => '1',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '33',
                        'class' => '',
                        'id' => '',
                    ),
                    'choices' => array(
                        'recent' => 'recent images',
                        'popular' => 'popular images',
                    ),
                    'default_value' => false,
                    'allow_null' => 0,
                    'multiple' => 0,
                    'ui' => 0,
                    'return_format' => 'value',
                    'ajax' => 0,
                    'placeholder' => '',
                ),
                array(
                    'key' => 'field_5f82f9bd5f625',
                    'label' => __('post number' , 'king' ) ,
                    'name' => 'mpost_number',
                    'type' => 'range',
                    'instructions' => __('number of posts display in mega menu', 'king') , 
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_5f7f403c31e5a',
                                'operator' => '==',
                                'value' => '1',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '33',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 5,
                    'min' => 1,
                    'max' => 10,
                    'step' => '',
                    'prepend' => 'posts',
                    'append' => '',
                ),
                array(
                    'key' => 'field_5f7f403c31e5c',
                    'label' => __('add links in mega menu' , 'king' ) ,
                    'name' => 'links_in_mega_menu',
                    'type' => 'repeater',
                    'instructions' => __('you can add extra links in mega menu', 'king') , 
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_5f7f403c31e5a',
                                'operator' => '==',
                                'value' => '1',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'collapsed' => 'field_5f7f3f6fd0bcb',
                    'min' => 0,
                    'max' => 30,
                    'layout' => 'block',
                    'button_label' => 'add new link',
                    'sub_fields' => array(
                        array(
                            'key' => 'field_5f7f403c31e5d',
                            'label' => __('mega menu link text', 'king' ),
                            'name' => 'mega_menu_link_text',
                            'type' => 'text',
                            
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '50',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'placeholder' => '',
                            'prepend' => 'text',
                            'append' => '',
                            'maxlength' => '',
                        ),
                        array(
                            'key' => 'field_5f7f403c31e5e',
                            'label' => __('mega menu link url', 'king' ),
                            'name' => 'mega_menu_link_url',
                            'type' => 'url',
                            
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '50',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'placeholder' => 'url',
                        ),
                    ),
                ),
            ),
        ),
        array(
            'key' => 'field_5f7f423737191',
            'label' => __('Music Mega Menu' , 'king' ),
            'name' => 'for_music_link',
            'type' => 'group',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_60bf95fc1bfd1',
                        'operator' => '==',
                        'value' => 'musics_link',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'layout' => 'block',
            'sub_fields' => array(
                array(
                    'key' => 'field_5f7f423737192',
                    'label' => __('for music link' , 'king' ) ,
                    'name' => 'for_music',
                    'type' => 'true_false',
                    'instructions' => __('enable mega menu for music link', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '33',
                        'class' => '',
                        'id' => '',
                    ),
                            'default_value' => 0,
                    'ui' => 1,
                    'ui_on_text' => '',
                    'ui_off_text' => '',
                ),
                array(
                    'key' => 'field_5f7f423737193',
                    'label' => __('show in mega menu' , 'king' ) ,
                    'name' => 'show_in_mega_menu',
                    'type' => 'select',
                    'instructions' => __('select which posts you like to show in music mega menu', 'king') , 
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_5f7f423737192',
                                'operator' => '==',
                                'value' => '1',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '33',
                        'class' => '',
                        'id' => '',
                    ),
                    'choices' => array(
                        'recent' => 'recent musics',
                        'popular' => 'popular musics',
                    ),
                    'default_value' => false,
                    'allow_null' => 0,
                    'multiple' => 0,
                    'ui' => 0,
                    'return_format' => 'value',
                    'ajax' => 0,
                    'placeholder' => '',
                ),
                array(
                    'key' => 'field_5f82fa175f627',
                    'label' => __('post number' , 'king' ) ,
                    'name' => 'mpost_number',
                    'type' => 'range',
                    'instructions' => __('number of posts display in mega menu', 'king') , 
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_5f7f423737192',
                                'operator' => '==',
                                'value' => '1',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '33',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 5,
                    'min' => 1,
                    'max' => 10,
                    'step' => '',
                    'prepend' => 'posts',
                    'append' => '',
                ),
                array(
                    'key' => 'field_5f7f423737194',
                    'label' => __('add links in mega menu' , 'king' ) ,
                    'name' => 'links_in_mega_menu',
                    'type' => 'repeater',
                    'instructions' => __('you can add extra links in mega menu', 'king') , 
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_5f7f423737192',
                                'operator' => '==',
                                'value' => '1',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'collapsed' => 'field_5f7f3f6fd0bcb',
                    'min' => 0,
                    'max' => 30,
                    'layout' => 'block',
                    'button_label' => 'add new link',
                    'sub_fields' => array(
                        array(
                            'key' => 'field_5f7f423737195',
                            'label' => __('mega menu link text', 'king' ),
                            'name' => 'mega_menu_link_text',
                            'type' => 'text',
                            
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '50',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'placeholder' => '',
                            'prepend' => 'text',
                            'append' => '',
                            'maxlength' => '',
                        ),
                        array(
                            'key' => 'field_5f7f423737196',
                            'label' => __('mega menu link url', 'king' ),
                            'name' => 'mega_menu_link_url',
                            'type' => 'url',
                            
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '50',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'placeholder' => 'url',
                        ),
                    ),
                ),
            ),
        ),
        array(
            'key' => 'field_60c0cea641723',
            'label' => __('List Mega Menu' , 'king' ),
            'name' => 'for_list_link',
            'type' => 'group',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_60bf95fc1bfd1',
                        'operator' => '==',
                        'value' => 'lists_link',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'layout' => 'block',
            'sub_fields' => array(
                array(
                    'key' => 'field_60c0cea641724',
                    'label' => __('for list link' , 'king' ) ,
                    'name' => 'for_list',
                    'type' => 'true_false',
                    'instructions' => __('enable mega menu for list link', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '33',
                        'class' => '',
                        'id' => '',
                    ),
                            'default_value' => 0,
                    'ui' => 1,
                    'ui_on_text' => '',
                    'ui_off_text' => '',
                ),
                array(
                    'key' => 'field_60c0cea641725',
                    'label' => __('show in mega menu' , 'king' ) ,
                    'name' => 'show_in_mega_menu',
                    'type' => 'select',
                    'instructions' => __('select which posts you like to show in list mega menu', 'king') , 
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_60c0cea641724',
                                'operator' => '==',
                                'value' => '1',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '33',
                        'class' => '',
                        'id' => '',
                    ),
                    'choices' => array(
                        'recent' => 'recent lists',
                        'popular' => 'popular lists',
                    ),
                    'default_value' => false,
                    'allow_null' => 0,
                    'multiple' => 0,
                    'ui' => 0,
                    'return_format' => 'value',
                    'ajax' => 0,
                    'placeholder' => '',
                ),
                array(
                    'key' => 'field_60c0cea641726',
                    'label' => __('post number' , 'king' ) ,
                    'name' => 'mpost_number',
                    'type' => 'range',
                    'instructions' => __('number of posts display in mega menu', 'king') , 
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_60c0cea641724',
                                'operator' => '==',
                                'value' => '1',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '33',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 5,
                    'min' => 1,
                    'max' => 10,
                    'step' => '',
                    'prepend' => 'posts',
                    'append' => '',
                ),
                array(
                    'key' => 'field_60c0cea641727',
                    'label' => __('add links in mega menu' , 'king' ) ,
                    'name' => 'links_in_mega_menu',
                    'type' => 'repeater',
                    'instructions' => __('you can add extra links in mega menu', 'king') , 
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_60c0cea641724',
                                'operator' => '==',
                                'value' => '1',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'collapsed' => 'field_5f7f3f6fd0bcb',
                    'min' => 0,
                    'max' => 30,
                    'layout' => 'block',
                    'button_label' => 'add new link',
                    'sub_fields' => array(
                        array(
                            'key' => 'field_60c0cea641728',
                            'label' => __('mega menu link text', 'king' ),
                            'name' => 'mega_menu_link_text',
                            'type' => 'text',
                            
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '50',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'placeholder' => '',
                            'prepend' => 'text',
                            'append' => '',
                            'maxlength' => '',
                        ),
                        array(
                            'key' => 'field_60c0cea641729',
                            'label' => __('mega menu link url', 'king' ),
                            'name' => 'mega_menu_link_url',
                            'type' => 'url',
                            
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '50',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'placeholder' => 'url',
                        ),
                    ),
                ),
            ),
        ),
        array(
            'key' => 'field_60c0cf3e51bb0',
            'name' => __('Poll Mega Menu' , 'king' ),
            'name' => 'for_poll_link',
            'type' => 'group',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_60bf95fc1bfd1',
                        'operator' => '==',
                        'value' => 'polls_link',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'layout' => 'block',
            'sub_fields' => array(
                array(
                    'key' => 'field_60c0cf3e51bb1',
                    'label' => __('for poll link' , 'king' ) ,
                    'name' => 'for_poll',
                    'type' => 'true_false',
                    'instructions' => __('enable mega menu for poll link', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '33',
                        'class' => '',
                        'id' => '',
                    ),
                            'default_value' => 0,
                    'ui' => 1,
                    'ui_on_text' => '',
                    'ui_off_text' => '',
                ),
                array(
                    'key' => 'field_60c0cf3e51bb2',
                    'label' => __('show in mega menu' , 'king' ) ,
                    'name' => 'show_in_mega_menu',
                    'type' => 'select',
                    'instructions' => __('select which posts you like to show in poll mega menu', 'king') , 
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_60c0cf3e51bb1',
                                'operator' => '==',
                                'value' => '1',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '33',
                        'class' => '',
                        'id' => '',
                    ),
                    'choices' => array(
                        'recent' => 'recent polls',
                        'popular' => 'popular polls',
                    ),
                    'default_value' => false,
                    'allow_null' => 0,
                    'multiple' => 0,
                    'ui' => 0,
                    'return_format' => 'value',
                    'ajax' => 0,
                    'placeholder' => '',
                ),
                array(
                    'key' => 'field_60c0cf3e51bb3',
                    'label' => __('post number' , 'king' ) ,
                    'name' => 'mpost_number',
                    'type' => 'range',
                    'instructions' => __('number of posts display in mega menu', 'king') , 
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_60c0cf3e51bb1',
                                'operator' => '==',
                                'value' => '1',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '33',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 5,
                    'min' => 1,
                    'max' => 10,
                    'step' => '',
                    'prepend' => 'posts',
                    'append' => '',
                ),
                array(
                    'key' => 'field_60c0cf3e51bb4',
                    'label' => __('add links in mega menu' , 'king' ) ,
                    'name' => 'links_in_mega_menu',
                    'type' => 'repeater',
                    'instructions' => __('you can add extra links in mega menu', 'king') , 
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_60c0cf3e51bb1',
                                'operator' => '==',
                                'value' => '1',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'collapsed' => 'field_5f7f3f6fd0bcb',
                    'min' => 0,
                    'max' => 30,
                    'layout' => '',
                    'button_label' => 'add new link',
                    'sub_fields' => array(
                        array(
                            'key' => 'field_60c0cf3e51bb5',
                            'label' => __('mega menu link text', 'king' ),
                            'name' => 'mega_menu_link_text',
                            'type' => 'text',
                            
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '50',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'placeholder' => '',
                            'prepend' => 'text',
                            'append' => '',
                            'maxlength' => '',
                        ),
                        array(
                            'key' => 'field_60c0cf3e51bb6',
                            'label' => __('mega menu link url', 'king' ),
                            'name' => 'mega_menu_link_url',
                            'type' => 'url',
                            
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '50',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'placeholder' => 'url',
                        ),
                    ),
                ),
            ),
        ),
        array(
            'key' => 'field_60c0cf6e51bb7',
            'label' => __('Trivia Quiz Mega Menu' , 'king' ),
            'name' => 'for_trivia_link',
            'type' => 'group',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_60bf95fc1bfd1',
                        'operator' => '==',
                        'value' => 'quiz_link',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'layout' => 'block',
            'sub_fields' => array(
                array(
                    'key' => 'field_60c0cf6e51bb8',
                    'label' => __('for trivia link' , 'king' ) ,
                    'name' => 'for_trivia',
                    'type' => 'true_false',
                    'instructions' => __('enable mega menu for trivia link', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '33',
                        'class' => '',
                        'id' => '',
                    ),
                            'default_value' => 0,
                    'ui' => 1,
                    'ui_on_text' => '',
                    'ui_off_text' => '',
                ),
                array(
                    'key' => 'field_60c0cf6e51bb9',
                    'label' => __('show in mega menu' , 'king' ) ,
                    'name' => 'show_in_mega_menu',
                    'type' => 'select',
                    'instructions' => __('select which posts you like to show in trivia quiz mega menu', 'king') , 
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_60c0cf6e51bb8',
                                'operator' => '==',
                                'value' => '1',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '33',
                        'class' => '',
                        'id' => '',
                    ),
                    'choices' => array(
                        'recent' => 'recent trivia quizzes',
                        'popular' => 'popular trivia quizzes',
                    ),
                    'default_value' => false,
                    'allow_null' => 0,
                    'multiple' => 0,
                    'ui' => 0,
                    'return_format' => 'value',
                    'ajax' => 0,
                    'placeholder' => '',
                ),
                array(
                    'key' => 'field_60c0cf6e51bba',
                    'label' => __('post number' , 'king' ) ,
                    'name' => 'mpost_number',
                    'type' => 'range',
                    'instructions' => __('number of posts display in mega menu', 'king') , 
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_60c0cf6e51bb8',
                                'operator' => '==',
                                'value' => '1',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '33',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 5,
                    'min' => 1,
                    'max' => 10,
                    'step' => '',
                    'prepend' => 'posts',
                    'append' => '',
                ),
                array(
                    'key' => 'field_60c0cf6e51bbb',
                    'label' => __('add links in mega menu' , 'king' ) ,
                    'name' => 'links_in_mega_menu',
                    'type' => 'repeater',
                    'instructions' => __('you can add extra links in mega menu', 'king') , 
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_60c0cf6e51bb8',
                                'operator' => '==',
                                'value' => '1',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'collapsed' => 'field_5f7f3f6fd0bcb',
                    'min' => 0,
                    'max' => 30,
                    'layout' => 'block',
                    'button_label' => 'add new link',
                    'sub_fields' => array(
                        array(
                            'key' => 'field_60c0cf6f51bbc',
                            'label' => __('mega menu link text', 'king' ),
                            'name' => 'mega_menu_link_text',
                            'type' => 'text',
                            
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '50',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'placeholder' => '',
                            'prepend' => 'text',
                            'append' => '',
                            'maxlength' => '',
                        ),
                        array(
                            'key' => 'field_60c0cf6f51bbd',
                            'label' => __('mega menu link url', 'king' ),
                            'name' => 'mega_menu_link_url',
                            'type' => 'url',
                            
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '50',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'placeholder' => 'url',
                        ),
                    ),
                ),
            ),
        ),
        array(
            'key' => 'field_60bf964f1bfd2',
            'label' => __('Hide Header Menu' , 'king' ),
            'name' => 'hide_categories',
            'type' => 'true_false',
            'instructions' => __('Hide header Mega Menu of dots in header', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
    ),
    'location' => array(
        array(
            array(
                'param' => 'options_page',
                'operator' => '==',
                'value' => 'acf-options-templates',
            ),
        ),
    ),
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => true,
    'description' => '',
    'show_in_rest' => 0,
));

acf_add_local_field_group(array(
    'key' => 'group_60afc54cccfef',
    'title' => 'Trivia Quiz',
    'fields' => array(
        array(
            'key' => 'field_60afc56a4924f',
            'label' => __('Quiz Questions' , 'king' ),
            'name' => '',
            'type' => 'tab',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'top',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_60afc5cb49251',
            'label' => __('Questions' , 'king' ),
            'name' => 'quiz_questions',
            'type' => 'repeater',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => 'king-repeater',
                'id' => '',
            ),
            'collapsed' => 'field_60afc61249252',
            'min' => 1,
            'max' => 30,
            'layout' => 'block',
            'button_label' => 'Add New',
            'sub_fields' => array(
                array(
                    'key' => 'field_60afc61249252',
                    'label' => __('Question' , 'king' ) ,
                    'name' => 'quiz_title',
                    'type' => 'text',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_60afc76a49254',
                                'operator' => '!=',
                                'value' => '1',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'maxlength' => '',
                ),
                array(
                    'key' => 'field_60afc76a49254',
                    'label' => __('Hide Quiz title' , 'king' ) ,
                    'name' => 'hide_quiz_title',
                    'type' => 'true_false',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_60afc6a449253',
                                'operator' => '!=empty',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                            'default_value' => 0,
                    'ui' => 1,
                    'ui_on_text' => '',
                    'ui_off_text' => '',
                ),
                array(
                    'key' => 'field_60afc6a449253',
                    'label' => __('Image' , 'king' ) ,
                    'name' => 'quiz_image',
                    'type' => 'image',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'return_format' => 'array',
                    'preview_size' => 'thumbnail',
                    'library' => 'uploadedTo',
                    'min_width' => '',
                    'min_height' => '',
                    'min_size' => '',
                    'max_width' => '',
                    'max_height' => '',
                    'max_size' => 5,
                    'mime_types' => 'jpg, jpeg, png, gif,',
                ),
                array(
                    'key' => 'field_60afc8e93975d',
                    'label' => __('Answers Style' , 'king' ) ,
                    'name' => 'quiz_answers_style',
                    'type' => 'radio',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '15',
                        'class' => 'poll-radio',
                        'id' => '',
                    ),
                    'choices' => array(
                        'pollgrid-1' => '<i class="fas fa-bars"></i>',
                        'pollgrid-2' => '<i class="fas fa-th-large"></i>',
                        'pollgrid-3' => '<i class="fas fa-grip-horizontal"></i>',
                    ),
                    'allow_null' => 0,
                    'other_choice' => 0,
                    'default_value' => '',
                    'layout' => 'vertical',
                    'return_format' => 'value',
                    'save_other_choice' => 0,
                ),
                array(
                    'key' => 'field_60afc95c3975e',
                    'label' => __('Answers' , 'king' ) ,
                    'name' => 'quiz_grid_answers',
                    'type' => 'repeater',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '85',
                        'class' => 'dflex',
                        'id' => '',
                    ),
                    'collapsed' => '',
                    'min' => 2,
                    'max' => 20,
                    'layout' => 'block',
                    'button_label' => 'add answer',
                    'sub_fields' => array(
                        array(
                            'key' => 'field_60afc9b33975f',
                            'label' => __('Answer Image', 'king' ),
                            'name' => 'quiz_answer_image',
                            'type' => 'image',
                            
                            'required' => 0,
                            'conditional_logic' => array(
                                array(
                                    array(
                                        'field' => 'field_60afc8e93975d',
                                        'operator' => '==',
                                        'value' => 'pollgrid-2',
                                    ),
                                ),
                                array(
                                    array(
                                        'field' => 'field_60afc8e93975d',
                                        'operator' => '==',
                                        'value' => 'pollgrid-3',
                                    ),
                                ),
                            ),
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'return_format' => 'array',
                            'preview_size' => 'thumbnail',
                            'library' => 'uploadedTo',
                            'min_width' => '',
                            'min_height' => '',
                            'min_size' => '',
                            'max_width' => '',
                            'max_height' => '',
                            'max_size' => 5,
                            'mime_types' => '',
                        ),
                        array(
                            'key' => 'field_60afca756c796',
                            'label' => __('Answer', 'king' ),
                            'name' => 'quiz_answer',
                            'type' => 'text',
                            
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'placeholder' => '',
                            'prepend' => '',
                            'append' => '',
                            'maxlength' => 200,
                        ),
                        array(
                            'key' => 'field_60afcaf36c797',
                            'name' => 'quiz_correct',
                            'type' => 'true_false',
                            
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => 'qcorrect',
                            ),
                            'message' => __( ' Correct', 'king' ),
                            'default_value' => 0,
                            'ui' => 0,
                            'ui_on_text' => '',
                            'ui_off_text' => '',
                        ),
                    ),
                ),
            ),
        ),
        array(
            'key' => 'field_60afc5a049250',
            'label' => __('Quiz Results' , 'king' ),
            'name' => '',
            'type' => 'tab',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'top',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_60afe3a831738',
            'label' => __('Results' , 'king' ),
            'name' => 'quiz_results',
            'type' => 'repeater',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => 'king-repeater',
                'id' => '',
            ),
            'collapsed' => 'field_60afe5223173b',
            'min' => 1,
            'max' => 30,
            'layout' => 'block',
            'button_label' => 'Add',
            'sub_fields' => array(
                array(
                    'key' => 'field_60afe3e731739',
                    'label' => __('Low' , 'king' ) ,
                    'name' => 'result_range_low',
                    'type' => 'number',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '15',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '%',
                    'min' => 0,
                    'max' => 100,
                    'step' => '',
                ),
                array(
                    'key' => 'field_60afe4a33173a',
                    'label' => __('High' , 'king' ) ,
                    'name' => 'result_range_high',
                    'type' => 'number',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '15',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '%',
                    'min' => 0,
                    'max' => 100,
                    'step' => '',
                ),
                array(
                    'key' => 'field_60afe5223173b',
                    'label' => __('Result' , 'king' ) ,
                    'name' => 'quiz_result',
                    'type' => 'text',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '70',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'maxlength' => '',
                ),
                array(
                    'key' => 'field_60afe54d3173c',
                    'label' => __('Result Image' , 'king' ) ,
                    'name' => 'quiz_result_image',
                    'type' => 'image',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'return_format' => 'array',
                    'preview_size' => 'thumbnail',
                    'library' => 'uploadedTo',
                    'min_width' => '',
                    'min_height' => '',
                    'min_size' => '',
                    'max_width' => '',
                    'max_height' => '',
                    'max_size' => 5,
                    'mime_types' => 'jpg, jpeg, png, gif,',
                ),
                array(
                    'key' => 'field_60afe5933173d',
                    'label' => __('Description' , 'king' ) ,
                    'name' => 'quiz_result_description',
                    'type' => 'textarea',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'placeholder' => '',
                    'maxlength' => 800,
                    'rows' => 6,
                    'new_lines' => '',
                ),
            ),
        ),
    ),
    'location' => array(
        array(
            array(
                'param' => 'post_type',
                'operator' => '==',
                'value' => 'trivia',
            ),
        ),
    ),
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => true,
    'description' => '',
    'show_in_rest' => false,
));

acf_add_local_field_group(array(
    'key' => 'group_60c4b5699093b',
    'title' => 'Trivia Quiz Templates',
    'fields' => array(
        array(
            'key' => 'field_60c4b57e3b3d0',
            'label' => __('Trivia Templates' , 'king' ),
            'name' => 'trivia_templates',
            'type' => 'radio',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array(
                'trivia-template-1' => '<img src="../wp-content/themes/king/layouts/imgs/templates/single/polltemplate-v1.svg" height="180" width="180" />',
                'trivia-template-2' => '<img src="../wp-content/themes/king/layouts/imgs/templates/single/polltemplate-v2.svg" height="180" width="180" />',
            ),
            'allow_null' => 1,
            'other_choice' => 0,
            'default_value' => '',
            'layout' => 'horizontal',
            'return_format' => 'value',
            'save_other_choice' => 0,
        ),
    ),
    'location' => array(
        array(
            array(
                'param' => 'post_type',
                'operator' => '==',
                'value' => 'trivia',
            ),
        ),
    ),
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => true,
    'description' => '',
    'show_in_rest' => false,
));

acf_add_local_field_group(array(
    'key' => 'group_58bc8b2ad0dc4',
    'title' => 'User Options',
    'fields' => array(
        array(
            'key' => 'field_587be48552f9f',
            'label' => __('Author Image' , 'king' ),
            'name' => 'author_image',
            'type' => 'image',
            'instructions' => __('Upload author image.', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'preview_size' => 'thumbnail',
            'library' => 'all',
            'return_format' => 'array',
            'min_width' => 0,
            'min_height' => 0,
            'min_size' => 0,
            'max_width' => 0,
            'max_height' => 0,
            'max_size' => 0,
            'mime_types' => '',
        ),
        array(
            'key' => 'field_587be575569ec',
            'label' => __('Cover image' , 'king' ),
            'name' => 'cover_image',
            'type' => 'image',
            'instructions' => __('Upload cover image.', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'preview_size' => 'thumbnail',
            'library' => 'all',
            'return_format' => 'array',
            'min_width' => 0,
            'min_height' => 0,
            'min_size' => 0,
            'max_width' => 0,
            'max_height' => 0,
            'max_size' => 0,
            'mime_types' => '',
        ),
        array(
            'key' => 'field_587be5d811823',
            'label' => __('Profile Social Links' , 'king' ),
            'name' => '',
            'type' => 'message',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' <h1>Profile Social Links</h1>', 'king' ),
            'esc_html' => 0,
            'new_lines' => 'wpautop',
        ),
        array(
            'key' => 'field_587be5f411824',
            'label' => __('facebook' , 'king' ),
            'name' => 'profile_facebook',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'Facebook profile or page url',
            'prepend' => 'URL',
            'append' => '',
            'formatting' => 'none',
            'maxlength' => 140,
        ),
        array(
            'key' => 'field_587be62b11825',
            'label' => __('twitter' , 'king' ),
            'name' => 'profile_twitter',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'twitter profile url',
            'prepend' => 'URL',
            'append' => '',
            'formatting' => 'none',
            'maxlength' => 140,
        ),
        array(
            'key' => 'field_587be65111826',
            'label' => __('Linkedin' , 'king' ),
            'name' => 'profile_linkedin',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'linkedin profile',
            'prepend' => 'URL',
            'append' => '',
            'formatting' => 'none',
            'maxlength' => 140,
        ),
        array(
            'key' => 'field_5b5f73a37030e',
            'label' => __('Instagram' , 'king' ),
            'name' => 'profile_instagram',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'Instagram profile url',
            'prepend' => 'URL',
            'append' => '',
            'maxlength' => 140,
        ),
        array(
            'key' => 'field_5b5f73c17030f',
            'label' => __('Pinterest' , 'king' ),
            'name' => 'profile_pinterest',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'Pinterest profile url',
            'prepend' => 'URL',
            'append' => '',
            'maxlength' => 140,
        ),
        array(
            'key' => 'field_5a132d05c424b',
            'label' => __('Add Url' , 'king' ),
            'name' => 'profile_add_url',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'add custom url',
            'prepend' => 'URL',
            'append' => '',
            'maxlength' => 140,
        ),
        array(
            'key' => 'field_587be6a663208',
            'label' => __('Verified Accounts' , 'king' ),
            'name' => '',
            'type' => 'message',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' <h1>Verified Account</h1>', 'king' ),
            'esc_html' => 0,
            'new_lines' => 'wpautop',
        ),
        array(
            'key' => 'field_587be6cb63209',
            'label' => __('Verified Account' , 'king' ),
            'name' => 'verified_account',
            'type' => 'true_false',
            'instructions' => __('You can set extra permissions to verified users', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' verify this user account', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => 'Verified',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_59430297b0d37',
            'label' => __('Bonus Points' , 'king' ),
            'name' => 'bonus_points',
            'type' => 'number',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 0,
            'placeholder' => '',
            'prepend' => 'points',
            'append' => '',
            'min' => '',
            'max' => '',
            'step' => '',
        ),
    ),
    'location' => array(
        array(
            array(
                'param' => 'user_form',
                'operator' => '==',
                'value' => 'edit',
            ),
        ),
    ),
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'seamless',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => true,
    'description' => '',
    'show_in_rest' => false,
));

acf_add_local_field_group(array(
    'key' => 'group_58bddb03a9046',
    'title' => 'News List',
    'fields' => array(
        array(
            'key' => 'field_58bddb0df74fe',
            'label' => __('News list items' , 'king' ),
            'name' => 'news_list_items',
            'type' => 'repeater',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => 'king-repeater',
                'id' => '',
            ),
            'collapsed' => 'field_58bddb31f74ff',
            'min' => 1,
            'max' => 80,
            'layout' => 'block',
            'button_label' => '<i class="fas fa-plus"></i>',
            'sub_fields' => array(
                array(
                    'key' => 'field_58bddb31f74ff',
                    'label' => __('News list title' , 'king' ) ,
                    'name' => 'news_list_title',
                    'type' => 'text',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'maxlength' => '',
                ),
                array(
                    'key' => 'field_58bddb5ef7500',
                    'label' => __('Image or Video' , 'king' ) ,
                    'name' => 'news_image_or_video',
                    'type' => 'true_false',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                            'default_value' => 0,
                    'ui' => 1,
                    'ui_on_text' => 'Image',
                    'ui_off_text' => 'Video',
                ),
                array(
                    'key' => 'field_58bddb82f7501',
                    'label' => __('News list image' , 'king' ) ,
                    'name' => 'news_list_image',
                    'type' => 'image',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_58bddb5ef7500',
                                'operator' => '!=',
                                'value' => '1',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'return_format' => 'array',
                    'preview_size' => 'medium',
                    'library' => 'uploadedTo',
                    'min_width' => '',
                    'min_height' => '',
                    'min_size' => '',
                    'max_width' => '',
                    'max_height' => '',
                    'max_size' => 5,
                    'mime_types' => 'jpg, jpeg, png, gif, webp',
                ),
                array(
                    'key' => 'field_58bddbb9f7502',
                    'label' => __('News list media' , 'king' ) ,
                    'name' => 'news_list_media',
                    'type' => 'oembed',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_58bddb5ef7500',
                                'operator' => '==',
                                'value' => '1',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'width' => '',
                    'height' => '',
                ),
                array(
                    'key' => 'field_58bddbd2f7503',
                    'label' => __('News list content' , 'king' ) ,
                    'name' => 'news_list_content',
                    'type' => 'textarea',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'placeholder' => '',
                    'maxlength' => '',
                    'rows' => '',
                    'new_lines' => '',
                ),
            ),
        ),
    ),
    'location' => array(
        array(
            array(
                'param' => 'post_type',
                'operator' => '==',
                'value' => 'list',
            ),
        ),
    ),
    'menu_order' => 1,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => true,
    'description' => '',
    'show_in_rest' => 0,
));

acf_add_local_field_group(array(
    'key' => 'group_58bc8b2c4a3e8',
    'title' => 'video url',
    'fields' => array(
        array(
            'key' => 'field_58f533f201eee',
            'label' => __('url or upload' , 'king' ),
            'name' => 'video_tab',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => 'upload',
            'ui_off_text' => 'url',
        ),
        array(
            'key' => 'field_587be2665e807',
            'label' => __('url' , 'king' ),
            'name' => 'video-url',
            'type' => 'oembed',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_58f533f201eee',
                        'operator' => '!=',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'width' => '',
            'height' => '',
        ),
        array(
            'key' => 'field_58f5335001eed',
            'label' => __('upload' , 'king' ),
            'name' => 'video_upload',
            'type' => 'file',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_58f533f201eee',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'return_format' => 'array',
            'library' => 'uploadedTo',
            'min_size' => '',
            'max_size' => 500,
            'mime_types' => 'mp4, flv, mp3, mov',
        ),
        array(
            'key' => 'field_58f5594a975cb',
            'label' => __('media thumb' , 'king' ),
            'name' => '_thumbnail_id',
            'type' => 'image',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_58f533f201eee',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'return_format' => 'array',
            'preview_size' => 'medium',
            'library' => 'uploadedTo',
            'min_width' => '',
            'min_height' => '',
            'min_size' => '',
            'max_width' => '',
            'max_height' => '',
            'max_size' => 10,
            'mime_types' => 'jpg, png, gif, jpeg, webp',
        ),
        array(
            'key' => 'field_59c9812458fe6',
            'label' => __('media embed code' , 'king' ),
            'name' => 'media_embed_code',
            'type' => 'textarea',
            'instructions' => __('you can paste embed code of media here', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_58f533f201eee',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'maxlength' => '',
            'rows' => '',
            'new_lines' => '',
        ),
        array(
            'key' => 'field_5ee7d2907603a',
            'label' => __('Media Lists' , 'king' ),
            'name' => 'media_lists',
            'type' => 'repeater',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'collapsed' => '',
            'min' => 0,
            'max' => 80,
            'layout' => 'block',
            'button_label' => '<i class="fas fa-plus"></i>',
            'sub_fields' => array(
                array(
                    'key' => 'field_5ee7d35b7603b',
                    'label' => __('Media Title' , 'king' ) ,
                    'name' => 'media_title',
                    'type' => 'text',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'placeholder' => 'title',
                    'prepend' => '',
                    'append' => '',
                    'maxlength' => '',
                ),
                array(
                    'key' => 'field_5ee7d3c77603d',
                    'label' => __('Media Url or Upload' , 'king' ) ,
                    'name' => 'media_url_or_upload',
                    'type' => 'true_false',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                            'default_value' => 0,
                    'ui' => 1,
                    'ui_on_text' => 'Url',
                    'ui_off_text' => 'Upload',
                ),
                array(
                    'key' => 'field_5ee7d3987603c',
                    'label' => __('Media Url' , 'king' ) ,
                    'name' => 'media_url',
                    'type' => 'oembed',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_5ee7d3c77603d',
                                'operator' => '!=',
                                'value' => '1',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'width' => '',
                    'height' => '',
                ),
                array(
                    'key' => 'field_5ee7d4327603e',
                    'label' => __('Media upload' , 'king' ) ,
                    'name' => 'media_upload',
                    'type' => 'file',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_5ee7d3c77603d',
                                'operator' => '==',
                                'value' => '1',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'return_format' => 'array',
                    'library' => 'uploadedTo',
                    'min_size' => '',
                    'max_size' => 150,
                    'mime_types' => 'mp4, flv, mp3, mov',
                ),
                array(
                    'key' => 'field_5ee7d4f37603f',
                    'label' => __('Media Thumb' , 'king' ) ,
                    'name' => 'media_thumb',
                    'type' => 'image',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'return_format' => 'array',
                    'preview_size' => 'thumbnail',
                    'library' => 'uploadedTo',
                    'min_width' => '',
                    'min_height' => '',
                    'min_size' => '',
                    'max_width' => '',
                    'max_height' => '',
                    'max_size' => 10,
                    'mime_types' => 'jpg, png, gif, jpeg',
                ),
            ),
        ),
    ),
    'location' => array(
        array(
            array(
                'param' => 'post_format',
                'operator' => '==',
                'value' => 'video',
            ),
        ),
        array(
            array(
                'param' => 'post_format',
                'operator' => '==',
                'value' => 'audio',
            ),
        ),
    ),
    'menu_order' => 1,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => true,
    'description' => '',
    'show_in_rest' => 0,
));

acf_add_local_field_group(array(
    'key' => 'group_5ec929bd79ab3',
    'title' => 'Category Options',
    'fields' => array(
        array(
            'key' => 'field_6096ce9cb70e1',
            'label' => __('Category For' , 'king' ),
            'name' => 'category_for',
            'type' => 'checkbox',
            'instructions' => __('This category will be available only for selected post type', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array(
                'for_news' => 'News',
                'for_video' => 'Video',
                'for_image' => 'Image',
                'for_music' => 'Music',
                'for_list' => 'List',
                'for_poll' => 'Poll',
                'for_trivia' => 'Trivia Quiz',
            ),
            'allow_custom' => 0,
            'default_value' => array(
            ),
            'layout' => 'horizontal',
            'toggle' => 0,
            'return_format' => 'value',
            'save_custom' => 0,
        ),
        array(
            'key' => 'field_5fe71d5564615',
            'label' => __('Category Posts Free' , 'king' ),
            'name' => 'category_for_free',
            'type' => 'true_false',
            'instructions' => __('Enable this option if you like show posts in this category for <strong>Not Premium Users.</strong> ( This option only available if Membership enabled in Theme Settings )', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
    ),
    'location' => array(
        array(
            array(
                'param' => 'taxonomy',
                'operator' => '==',
                'value' => 'category',
            ),
        ),
    ),
    'menu_order' => 2,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => true,
    'description' => '',
    'show_in_rest' => false,
));

acf_add_local_field_group(array(
    'key' => 'group_5b5ce3de0940d',
    'title' => 'Image Templates',
    'fields' => array(
        array(
            'key' => 'field_5b5ce3de23ad5',
            'label' => __('Image Post Template' , 'king' ),
            'name' => 'image_template',
            'type' => 'radio',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array(
                'image-template-1' => '<img src="../wp-content/themes/king/layouts/imgs/templates/single/imagetemplate-v1.svg" height="150" width="150" />',
                'image-template-2' => '<img src="../wp-content/themes/king/layouts/imgs/templates/single/imagetemplate-v2.svg" height="150" width="150" />',
            ),
            'allow_null' => 1,
            'other_choice' => 0,
            'default_value' => '',
            'layout' => 'horizontal',
            'return_format' => 'value',
            'save_other_choice' => 0,
        ),
    ),
    'location' => array(
        array(
            array(
                'param' => 'post_format',
                'operator' => '==',
                'value' => 'image',
            ),
        ),
    ),
    'menu_order' => 2,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => true,
    'description' => '',
    'show_in_rest' => false,
));

acf_add_local_field_group(array(
    'key' => 'group_58bc8b2c6ed68',
    'title' => 'Post Options',
    'fields' => array(
        array(
            'key' => 'field_587be13bfc2f0',
            'label' => __('Featured Post' , 'king' ),
            'name' => 'featured-post',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' set this post as featured', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_587be15ffc2f1',
            'label' => __('Keep Trending' , 'king' ),
            'name' => 'keep_trending',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' set this post as trend', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_587be16ffc2f2',
            'label' => __('nsfw' , 'king' ),
            'name' => 'nsfw_post',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' This post is Not Safe for Work', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_5c9bda3ad6b0b',
            'label' => __('Editors\' Choice' , 'king' ),
            'name' => 'editors_choice',
            'type' => 'true_false',
            'instructions' => __('Select this post as Editors\' Choice', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Select this post as Editors\' Choice', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_5c9bda8ad6b0c',
            'label' => __('Editors\' Note' , 'king' ),
            'name' => 'editors_note',
            'type' => 'textarea',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5c9bda3ad6b0b',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'Editors\' Note',
            'maxlength' => '',
            'rows' => '',
            'new_lines' => '',
        ),
        array(
            'key' => 'field_592499e8bbd9a',
            'label' => __('Post Views' , 'king' ),
            'name' => '_post_views',
            'type' => 'number',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => 'Views',
            'append' => '',
            'min' => '',
            'max' => '',
            'step' => '',
        ),
        array(
            'key' => 'field_593098698a880',
            'label' => __('Post Likes' , 'king' ),
            'name' => 'king_like_count',
            'type' => 'number',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => 'Likes',
            'append' => '',
            'min' => '',
            'max' => '',
            'step' => '',
        ),
        array(
            'key' => 'field_5a568a7c056ca',
            'label' => __('Add Sponsor' , 'king' ),
            'name' => 'add_sponsor',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' You can add sponsor branding to your post', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_5a568b7e056cb',
            'label' => __('Post sponsor logo' , 'king' ),
            'name' => 'post_sponsor_logo',
            'type' => 'image',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5a568a7c056ca',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '30',
                'class' => '',
                'id' => '',
            ),
            'return_format' => 'url',
            'preview_size' => 'thumbnail',
            'library' => 'all',
            'min_width' => '',
            'min_height' => '',
            'min_size' => '',
            'max_width' => '',
            'max_height' => '',
            'max_size' => '',
            'mime_types' => '',
        ),
        array(
            'key' => 'field_5a568bbe056cc',
            'label' => __('Post sponsor link' , 'king' ),
            'name' => 'post_sponsor_link',
            'type' => 'url',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5a568a7c056ca',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '40',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'sponsor link',
        ),
        array(
            'key' => 'field_5a568be7056cd',
            'label' => __('Post sponsor description' , 'king' ),
            'name' => 'post_sponsor_description',
            'type' => 'textarea',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5a568a7c056ca',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '30',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'maxlength' => '',
            'rows' => 4,
            'new_lines' => '',
        ),
    ),
    'location' => array(
        array(
            array(
                'param' => 'post_type',
                'operator' => '==',
                'value' => 'post',
            ),
            array(
                'param' => 'post_format',
                'operator' => '!=',
                'value' => 'link',
            ),
        ),
        array(
            array(
                'param' => 'post_type',
                'operator' => '==',
                'value' => 'list',
            ),
        ),
        array(
            array(
                'param' => 'post_type',
                'operator' => '==',
                'value' => 'poll',
            ),
        ),
        array(
            array(
                'param' => 'post_type',
                'operator' => '==',
                'value' => 'trivia',
            ),
        ),
    ),
    'menu_order' => 2,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => true,
    'description' => '',
    'show_in_rest' => false,
));

acf_add_local_field_group(array(
    'key' => 'group_5b5b94e54f971',
    'title' => 'Post Templates',
    'fields' => array(
        array(
            'key' => 'field_5b5b94f0474bd',
            'label' => __('Post Template' , 'king' ),
            'name' => 'post_template',
            'type' => 'radio',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array(
                'template-1' => '<img src="../wp-content/themes/king/layouts/imgs/templates/single/template-v1.svg" height="150" width="150" />',
                'template-2' => '<img src="../wp-content/themes/king/layouts/imgs/templates/single/template-v2.svg" height="150" width="150" />',
                'template-3' => '<img src="../wp-content/themes/king/layouts/imgs/templates/single/template-v3.svg" height="150" width="150" />',
                'template-4' => '<img src="../wp-content/themes/king/layouts/imgs/templates/single/template-v4.svg" height="150" width="150" />',
                'template-5' => '<img src="../wp-content/themes/king/layouts/imgs/templates/single/template-v5.svg" height="150" width="150" />',
                'template-6' => '<img src="../wp-content/themes/king/layouts/imgs/templates/single/template-v6.svg" height="150" width="150" />',
            ),
            'allow_null' => 1,
            'other_choice' => 0,
            'default_value' => '',
            'layout' => 'horizontal',
            'return_format' => 'value',
            'save_other_choice' => 0,
        ),
    ),
    'location' => array(
        array(
            array(
                'param' => 'post_format',
                'operator' => '==',
                'value' => 'quote',
            ),
        ),
        array(
            array(
                'param' => 'post_format',
                'operator' => '==',
                'value' => 'standard',
            ),
        ),
    ),
    'menu_order' => 2,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => true,
    'description' => '',
    'show_in_rest' => false,
));

acf_add_local_field_group(array(
    'key' => 'group_5b5b932527a19',
    'title' => 'Video Templates',
    'fields' => array(
        array(
            'key' => 'field_5b5b932a71d23',
            'label' => __('Video Post Template' , 'king' ),
            'name' => 'video_template',
            'type' => 'radio',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array(
                'video-template-1' => '<img src="../wp-content/themes/king/layouts/imgs/templates/single/videotemplate-v1.svg" height="150" width="150" />',
                'video-template-2' => '<img src="../wp-content/themes/king/layouts/imgs/templates/single/videotemplate-v2.svg" height="150" width="150" />',
                'video-template-3' => '<img src="../wp-content/themes/king/layouts/imgs/templates/single/videotemplate-v3.svg" height="150" width="150" />',
            ),
            'allow_null' => 1,
            'other_choice' => 0,
            'default_value' => '',
            'layout' => 'horizontal',
            'return_format' => 'value',
            'save_other_choice' => 0,
        ),
    ),
    'location' => array(
        array(
            array(
                'param' => 'post_format',
                'operator' => '==',
                'value' => 'video',
            ),
        ),
    ),
    'menu_order' => 2,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => true,
    'description' => '',
    'show_in_rest' => false,
));

acf_add_local_field_group(array(
    'key' => 'group_5a56889e12163',
    'title' => 'Ad Post',
    'fields' => array(
        array(
            'key' => 'field_5a568932429f7',
            'label' => __('Ad link' , 'king' ),
            'name' => 'ad_link',
            'type' => 'url',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
        ),
        array(
            'key' => 'field_5a5688cf34274',
            'label' => __('Ad Button Value' , 'king' ),
            'name' => 'ad_button_value',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => 'Value',
            'append' => '',
            'maxlength' => 20,
        ),
        array(
            'key' => 'field_5a59195facec4',
            'label' => __('Ad Extra Field' , 'king' ),
            'name' => 'ad_extra_field',
            'type' => 'text',
            'instructions' => __('You can add extra information about ad , etc. price, name,', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => 'text',
            'append' => '',
            'maxlength' => '',
        ),
        array(
            'key' => 'field_5a5a7ec420b5a',
            'label' => __('Sponsored Text' , 'king' ),
            'name' => 'sponsored_text',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => 'Text',
            'append' => '',
            'maxlength' => 50,
        ),
    ),
    'location' => array(
        array(
            array(
                'param' => 'post_format',
                'operator' => '==',
                'value' => 'link',
            ),
        ),
    ),
    'menu_order' => 3,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => true,
    'description' => '',
    'show_in_rest' => false,
));

acf_add_local_field_group(array(
    'key' => 'group_58bc8b2cabdac',
    'title' => 'Layout',
    'fields' => array(
        array(
            'key' => 'field_585053862b024',
            'label' => __('Meta Head' , 'king' ),
            'name' => '',
            'type' => 'tab',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'left',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_58b04f09f9f53',
            'label' => __('Enable Meta Tags' , 'king' ),
            'name' => 'enable_meta_tags',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Enable Meta Tags for Facebook and Twitter Share', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_58617b1055b45',
            'label' => __('Facebook Share Description' , 'king' ),
            'name' => 'facebook_share_description',
            'type' => 'text',
            'instructions' => __('Custom description for Facebook Share.', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_58b04f09f9f53',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'e.g. click to watch',
            'prepend' => 'Text',
            'append' => '',
            'formatting' => 'none',
            'maxlength' => 140,
        ),
        array(
            'key' => 'field_58617f1602fc0',
            'label' => __('Twitter Share Description' , 'king' ),
            'name' => 'twitter_share_description',
            'type' => 'text',
            'instructions' => __('Custom description for Twitter Share.', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_58b04f09f9f53',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'e.g. click to see post',
            'prepend' => 'Text',
            'append' => '',
            'formatting' => 'none',
            'maxlength' => 140,
        ),
        array(
            'key' => 'field_5850544aeba32',
            'label' => __('Custom HTML in HEAD' , 'king' ),
            'name' => 'custom_html_head',
            'type' => 'textarea',
            'instructions' => __('add custom html in <head> </head> section of every page, (HTML Allowed)', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'ex: <link rel="shortcut icon" type="image/ico" href="favicon.ico" />',
            'maxlength' => '',
            'rows' => 6,
            'new_lines' => '',
        ),
        array(
            'key' => 'field_5850539d2b025',
            'label' => __('Advertising' , 'king' ),
            'name' => '',
            'type' => 'tab',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'left',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_57f5713fa06c8',
            'label' => __('Enable ad before videos load' , 'king' ),
            'name' => 'enable_ad_video',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Enable ad before videos load', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_57f57171a06c9',
            'label' => __('Ad Code' , 'king' ),
            'name' => 'video_load_ad',
            'type' => 'textarea',
            'instructions' => __('Display ad before video load', 'king' ) ,
            'required' => 1,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_57f5713fa06c8',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'maxlength' => '',
            'rows' => 4,
            'new_lines' => '',
        ),
        array(
            'key' => 'field_57f576023b604',
            'label' => __('Skip ad after (seconds)' , 'king' ),
            'name' => 'skip_ad_after',
            'type' => 'number',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_57f5713fa06c8',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 5,
            'placeholder' => '',
            'prepend' => 'second',
            'append' => '',
            'min' => '',
            'max' => 40,
            'step' => '',
        ),
        array(
            'key' => 'field_5807c89983906',
            'label' => __('Enable sticky ad in sidebar' , 'king' ),
            'name' => 'enable_sticky_ad',
            'type' => 'true_false',
            'instructions' => __('Display sticky ad in sidebar', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Enable sticky ad in sidebar', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_5807c8dd83907',
            'label' => __('Sidebar sticky ad' , 'king' ),
            'name' => 'sidebar_sticky_ad',
            'type' => 'textarea',
            
            'required' => 1,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5807c89983906',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'ad code ( HTML allowed )',
            'maxlength' => '',
            'rows' => 6,
            'new_lines' => '',
        ),
        array(
            'key' => 'field_5807cd1840d8e',
            'label' => __('Ad in Main Area - Top' , 'king' ),
            'name' => 'ad_main_area_top',
            'type' => 'textarea',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'ad code ( HTML allowed )',
            'maxlength' => '',
            'rows' => 6,
            'new_lines' => '',
        ),
        array(
            'key' => 'field_5807cf3989999',
            'label' => __('Ad in footer' , 'king' ),
            'name' => 'ad_in_footer',
            'type' => 'textarea',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'ad code ( HTML allowed )',
            'maxlength' => '',
            'rows' => 6,
            'new_lines' => '',
        ),
        array(
            'key' => 'field_58811d947aac1',
            'label' => __('Ads above content in post page' , 'king' ),
            'name' => 'ads_above_content',
            'type' => 'textarea',
            'instructions' => __('You can add ads above content in post page. max. width 750px', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'ad code ( HTML allowed )',
            'maxlength' => '',
            'rows' => 6,
            'new_lines' => '',
        ),
        array(
            'key' => 'field_58811eb07aac2',
            'label' => __('Ads below content in post page' , 'king' ),
            'name' => 'ads_below_content',
            'type' => 'textarea',
            'instructions' => __('You can add ads below content in post page. max. width 750px', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'ad code ( HTML allowed )',
            'maxlength' => '',
            'rows' => 6,
            'new_lines' => '',
        ),
        array(
            'key' => 'field_5850564fd3aef',
            'label' => __('Footer' , 'king' ),
            'name' => '',
            'type' => 'tab',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'left',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_5850565bd3af0',
            'label' => __('Footer copyright notice' , 'king' ),
            'name' => 'footer_copyright',
            'type' => 'text',
            'instructions' => __('html allowed', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '© yourpageurl.com 2021. All rights reserved.',
            'prepend' => 'Text',
            'append' => '',
            'maxlength' => '',
        ),
        array(
            'key' => 'field_58505697d3af1',
            'label' => __('Footer Facebook Link' , 'king' ),
            'name' => 'footer_facebook_link',
            'type' => 'text',
            'instructions' => __('Add your facebook page or profile url', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => 'Url',
            'append' => '',
            'formatting' => 'none',
            'maxlength' => '',
        ),
        array(
            'key' => 'field_585056b0d3af2',
            'label' => __('Footer Linkedin Link' , 'king' ),
            'name' => 'footer_linkedin_link',
            'type' => 'text',
            'instructions' => __('Add your Linkedin page url', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => 'Url',
            'append' => '',
            'formatting' => 'none',
            'maxlength' => '',
        ),
        array(
            'key' => 'field_585056c3d3af3',
            'label' => __('Footer Twitter Link' , 'king' ),
            'name' => 'footer_twitter_link',
            'type' => 'text',
            'instructions' => __('Add your Twitter page url', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => 'Url',
            'append' => '',
            'formatting' => 'none',
            'maxlength' => '',
        ),
        array(
            'key' => 'field_585056d6d3af4',
            'label' => __('Footer Instagram Link' , 'king' ),
            'name' => 'footer_instagram_link',
            'type' => 'text',
            'instructions' => __('Add your Instagram page url', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => 'Url',
            'append' => '',
            'maxlength' => '',
        ),
        array(
            'key' => 'field_585056e7d3af5',
            'label' => __('Add more custom Social Links' , 'king' ),
            'name' => 'footer_custom_link',
            'type' => 'textarea',
            'instructions' => __('Add custom social links , You can select icon <a href="https://fontawesome.com/v5.15/icons?d=gallery&p=2" target="_blank">Here </a>', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => 'ex: <li><a href="http://facebook.com/"><i class="fa fa-facebook"></i></a></li>',
            'maxlength' => '',
            'rows' => 6,
            'new_lines' => '',
        ),
        array(
            'key' => 'field_58505764c9b40',
            'label' => __('Custom Messages' , 'king' ),
            'name' => '',
            'type' => 'tab',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'left',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_58505770c9b41',
            'label' => __('Custom message on register page' , 'king' ),
            'name' => 'custom_message_register',
            'type' => 'textarea',
            'instructions' => __('Html Allowed', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'maxlength' => '',
            'rows' => '',
            'new_lines' => '',
        ),
        array(
            'key' => 'field_585057a5c9b42',
            'label' => __('Custom message on login page' , 'king' ),
            'name' => 'custom_message_login',
            'type' => 'textarea',
            'instructions' => __('Html Allowed', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'maxlength' => '',
            'rows' => '',
            'new_lines' => '',
        ),
        array(
            'key' => 'field_585057afc9b43',
            'label' => __('Custom message on News Submit Page' , 'king' ),
            'name' => 'custom_message_news',
            'type' => 'textarea',
            'instructions' => __('Html Allowed', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'maxlength' => '',
            'rows' => '',
            'new_lines' => '',
        ),
        array(
            'key' => 'field_585057c7c9b44',
            'label' => __('Custom message on Video Submit Page' , 'king' ),
            'name' => 'custom_message_video',
            'type' => 'textarea',
            'instructions' => __('Html Allowed', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'maxlength' => '',
            'rows' => '',
            'new_lines' => '',
        ),
        array(
            'key' => 'field_585057d5c9b45',
            'label' => __('Custom message on Image Submit Page' , 'king' ),
            'name' => 'custom_message_image',
            'type' => 'textarea',
            'instructions' => __('Html Allowed', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'maxlength' => '',
            'rows' => '',
            'new_lines' => '',
        ),
        array(
            'key' => 'field_5863f187660a0',
            'label' => __('Header' , 'king' ),
            'name' => '',
            'type' => 'tab',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'left',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_5f6f4d0f08a11',
            'label' => __('Enable Bookmarks' , 'king' ),
            'name' => 'enable_bookmarks',
            'type' => 'true_false',
            'instructions' => __('users can bookmark interesting posts and read it later.', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_5e592cc9d2207',
            'label' => __('Enable Live Search' , 'king' ),
            'name' => 'enable_live_search',
            'type' => 'true_false',
            'instructions' => __('You can enable live search', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_5e59312f8d5e7',
            'label' => __('Enable Live User Search' , 'king' ),
            'name' => 'enable_live_user_search',
            'type' => 'true_false',
            'instructions' => __('Enable user search in live search', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5e592cc9d2207',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_5c9bd420e2c12',
            'label' => __('Header menu layout' , 'king' ),
            'name' => 'header_menu_layout',
            'type' => 'radio',
            'instructions' => __('You can select header menu layout style', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array(
                'hmenu-template-1' => '<img src="../wp-content/themes/king/layouts/imgs/grid/hmenu.svg" height="175" width="175" />',
                'hmenu-template-2' => '<img src="../wp-content/themes/king/layouts/imgs/grid/hmenu2.svg" height="175" width="175" />',
            ),
            'allow_null' => 0,
            'other_choice' => 0,
            'default_value' => '',
            'layout' => 'horizontal',
            'return_format' => 'value',
            'save_other_choice' => 0,
        ),
        array(
            'key' => 'field_5c9bd485e2c13',
            'label' => __('Header Menu Columns' , 'king' ),
            'name' => 'header_menu_columns',
            'type' => 'select',
            'instructions' => __('Select header mega menu column size', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5c9bd420e2c12',
                        'operator' => '==',
                        'value' => 'hmenu-template-2',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array(
                'columns-1' => '1 Column',
                'columns-2' => '2 Columns',
                'columns-3' => '3 Columns',
                'columns-4' => '4 Columns',
                'columns-5' => '5 Columns',
            ),
            'default_value' => false,
            'allow_null' => 1,
            'multiple' => 0,
            'ui' => 0,
            'return_format' => 'value',
            'ajax' => 0,
            'placeholder' => '',
        ),
        array(
            'key' => 'field_586697832ea70',
            'label' => __('Hide Elements' , 'king' ),
            'name' => '',
            'type' => 'message',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' <h1>Hide Elements</h1>', 'king' ),
            'esc_html' => 0,
            'new_lines' => 'wpautop',
        ),
        array(
            'key' => 'field_5fa010391d306',
            'label' => __('Hide Navbar' , 'king' ),
            'name' => 'hide_navbar',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Hide nav bar under the header', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_5fa418cd09651',
            'label' => __('Hide submit button' , 'king' ),
            'name' => 'hide_submit_button',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' You can hide submit button in header', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_59921ec2859f1',
            'label' => __('Add Links' , 'king' ),
            'name' => '',
            'type' => 'message',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'new_lines' => '',
            'esc_html' => 0,
        ),
        array(
            'key' => 'field_5fa290c2cfe96',
            'label' => __('Add new icon and link in header' , 'king' ),
            'name' => 'add_new_icon_and_link_in_header',
            'type' => 'repeater',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'collapsed' => '',
            'min' => 0,
            'max' => 10,
            'layout' => 'block',
            'button_label' => 'Add Icon',
            'sub_fields' => array(
                array(
                    'key' => 'field_5fa290c2cfe98',
                    'label' => __('Header Icon URL' , 'king' ) ,
                    'name' => 'header_icon_url',
                    'type' => 'text',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'placeholder' => '',
                    'prepend' => 'URL',
                    'append' => '',
                    'maxlength' => '',
                ),
                array(
                    'key' => 'field_5fa290c2cfe99',
                    'label' => __('Header Icon' , 'king' ) ,
                    'name' => 'header_icon',
                    'type' => 'text',
                    'instructions' => __('Supporting FontAwesome icons, you can select the icons <a href="https://fontawesome.com/icons" target="_blank">Here</a>', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'placeholder' => '<i class="fas fa-crown"></i>',
                    'prepend' => 'icon',
                    'append' => '',
                    'maxlength' => '',
                ),
            ),
        ),
        array(
            'key' => 'field_5863f1a0660a1',
            'label' => __('Post Page' , 'king' ),
            'name' => '',
            'type' => 'tab',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'left',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_609d1b5da3f24',
            'label' => __('Post Page Buttons Style' , 'king' ),
            'name' => 'post_page_buttons_style',
            'type' => 'radio',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array(
                'badges-1' => '<img src="../wp-content/themes/king/layouts/imgs/grid/share-v1.svg" height="175" width="175" />',
                'badges-2' => '<img src="../wp-content/themes/king/layouts/imgs/grid/share-v2.svg" height="175" width="175" />',
            ),
            'allow_null' => 0,
            'other_choice' => 0,
            'default_value' => '',
            'layout' => 'horizontal',
            'return_format' => 'value',
            'save_other_choice' => 0,
        ),
        array(
            'key' => 'field_5fa5268bcadcd',
            'label' => __('Font Size in Post Page' , 'king' ),
            'name' => 'font_size_in_post_page',
            'type' => 'number',
            'instructions' => __('you can change the font size in post page', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => 'font-size',
            'append' => 'px',
            'min' => 9,
            'max' => 50,
            'step' => '',
        ),
        array(
            'key' => 'field_59c6e73fb5032',
            'label' => __('Enable floating video' , 'king' ),
            'name' => 'enable_floating_video',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' You can enable floating video options for video posts', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_597901fe706fc',
            'label' => __('Enable front-end post edit' , 'king' ),
            'name' => 'enable_post_edit',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Enable front-end post edit', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_5a61000ecc234',
            'label' => __('Allow users to delete their posts' , 'king' ),
            'name' => 'allow_users_to_delete_their_posts',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_597901fe706fc',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Allow users to delete their posts', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_59790f60e1564',
            'label' => __('Only verified users can edit posts' , 'king' ),
            'name' => 'verified_edit_posts',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_597901fe706fc',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Only verified users can edit posts', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_597a5fb1fd83c',
            'label' => __('Re-moderate posts after editing' , 'king' ),
            'name' => 'moderate_posts_edit',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_597901fe706fc',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Posts will be pending after editing', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_5c9bd5afa48b7',
            'label' => __('Display Editors’ Choice Note' , 'king' ),
            'name' => 'display_editors_choice_note',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Display notes for editors’ chose posts', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_5c9bd5dfa48b8',
            'label' => __('Editors’ Choice Title' , 'king' ),
            'name' => 'editors_choice_title',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5c9bd5afa48b7',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 'Editors’ Choice',
            'placeholder' => '',
            'prepend' => 'text',
            'append' => '',
            'maxlength' => '',
        ),
        array(
            'key' => 'field_5c9bd62ea48b9',
            'label' => __('Editors’ Choice Default Text' , 'king' ),
            'name' => 'editors_choice_default_text',
            'type' => 'textarea',
            'instructions' => __('if editors didn\'t write any note for posts this note will appear,', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5c9bd5afa48b7',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'maxlength' => '',
            'rows' => '',
            'new_lines' => '',
        ),
        array(
            'key' => 'field_586ea39dd21ec',
            'label' => __('Display Who Liked' , 'king' ),
            'name' => 'display_who_liked',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Display a list of users who liked a post to show in post page .', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_586ea439d21ed',
            'label' => __('Who liked box title' , 'king' ),
            'name' => 'who_liked_box_title',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_586ea39dd21ec',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 'Who liked ?',
            'placeholder' => '',
            'prepend' => 'text',
            'append' => '',
            'formatting' => 'none',
            'maxlength' => 100,
        ),
        array(
            'key' => 'field_5881228657b8b',
            'label' => __('Message if nobody liked' , 'king' ),
            'name' => 'if_nobody_liked_box_title',
            'type' => 'text',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_586ea39dd21ec',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 'Nobody liked ?',
            'placeholder' => '',
            'prepend' => 'text (HTML Allowed)',
            'append' => '',
            'formatting' => 'html',
            'maxlength' => 400,
        ),
        array(
            'key' => 'field_5866a70d36ee1',
            'label' => __('Related Posts' , 'king' ),
            'name' => '',
            'type' => 'message',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' <h1>Related Posts<h1>', 'king' ),
            'esc_html' => 0,
            'new_lines' => 'wpautop',
        ),
        array(
            'key' => 'field_5863f1ac660a2',
            'label' => __('Display Related Posts' , 'king' ),
            'name' => 'display_related',
            'type' => 'true_false',
            'instructions' => __('Display Related Posts in post page', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Display Related Posts', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_5866a171781a8',
            'label' => __('Related Posts Heading' , 'king' ),
            'name' => 'related_posts_heading',
            'type' => 'text',
            'instructions' => __('Related Entries Heading', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5863f1ac660a2',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 'Related Posts',
            'placeholder' => '',
            'prepend' => 'Text',
            'append' => '',
            'formatting' => 'none',
            'maxlength' => '',
        ),
        array(
            'key' => 'field_5866a29d8136d',
            'label' => __('Display related posts by' , 'king' ),
            'name' => 'display_related_posts_by',
            'type' => 'radio',
            'instructions' => __('Display related posts by Categories or Tags', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5863f1ac660a2',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array(
                'tags' => 'Tags',
                'categories' => 'Categories',
            ),
            'allow_null' => 0,
            'other_choice' => 0,
            'save_other_choice' => 0,
            'default_value' => '',
            'layout' => 'horizontal',
            'return_format' => 'value',
        ),
        array(
            'key' => 'field_5863f1d1660a3',
            'label' => __('Length of Related Posts' , 'king' ),
            'name' => 'related_length',
            'type' => 'number',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5863f1ac660a2',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 6,
            'placeholder' => '',
            'prepend' => 'Related Posts',
            'append' => '',
            'min' => 1,
            'max' => 20,
            'step' => '',
        ),
        array(
            'key' => 'field_586eae1483076',
            'label' => __('Hide Elements' , 'king' ),
            'name' => '',
            'type' => 'message',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' <h1>Hide Elements</h1>', 'king' ),
            'esc_html' => 0,
            'new_lines' => 'wpautop',
        ),
        array(
            'key' => 'field_586eae2d83077',
            'label' => __('Post Author Box' , 'king' ),
            'name' => 'hide_post_author_box',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Hide post author box in post page', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_586eae6583078',
            'label' => __('Hide author about text' , 'king' ),
            'name' => 'hide_author_about_text',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_586eae2d83077',
                        'operator' => '!=',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Hide post author about text in author box', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_5a132ee5ed76f',
            'label' => __('Hide author social links' , 'king' ),
            'name' => 'hide_author_social_links',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_586eae2d83077',
                        'operator' => '!=',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' Hide post author social links in author box', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_608acad212c2f',
            'label' => __('Comments' , 'king' ),
            'name' => '',
            'type' => 'tab',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'left',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_608acaeb12c30',
            'label' => __('Enable GIFs in comments' , 'king' ),
            'name' => 'enable_gifs_comments',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' You can enable or disable GIF submission in comment form', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_60aa9b3362c19',
            'label' => __('Giphy Api Key' , 'king' ),
            'name' => 'giphy_api_key',
            'type' => 'text',
            'instructions' => __('To load GIFs from GIPHY library, API access is required. You can get API Key <a href="https://developers.giphy.com/dashboard/" target="_blank">Here</a>', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_608acaeb12c30',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => 'api key',
            'append' => '',
            'maxlength' => '',
        ),
        array(
            'key' => 'field_608acb2c12c31',
            'label' => __('Enable Emoji in comments' , 'king' ),
            'name' => 'enable_emoji_comments',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' You can enable or disable adding emoji in comments', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_60aa92176159f',
            'label' => __('Hide default emojis' , 'king' ),
            'name' => 'hide_default_emojis',
            'type' => 'true_false',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_608acb2c12c31',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' You can hide default emojis', 'king' ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_60aa85f1d70a0',
            'label' => __('Add New Emoji' , 'king' ),
            'name' => 'add_new_emoji',
            'type' => 'repeater',
            'instructions' => __('You can copy and paste new emojis <a href="https://getemoji.com/" target="_blank">Here</a>', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_608acb2c12c31',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'collapsed' => '',
            'min' => 0,
            'max' => 0,
            'layout' => 'row',
            'button_label' => 'New Emoji',
            'sub_fields' => array(
                array(
                    'key' => 'field_60aa8a36be16a',
                    'label' => __('emoji' , 'king' ) ,
                    'name' => 'emoji',
                    'type' => 'text',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'placeholder' => 'paste emoji',
                    'prepend' => '🙂',
                    'append' => '',
                    'maxlength' => 2,
                ),
            ),
        ),
        array(
            'key' => 'field_5f885a659f167',
            'label' => __('Newsletter' , 'king' ),
            'name' => '',
            'type' => 'tab',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'left',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_5f8ad7504cf09',
            'label' => __('Download Newsletter Subscribed Emails' , 'king' ),
            'name' => '',
            'type' => 'message',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'message' => __( ' <a class="newsletter-download" href="./tools.php?download=subscribers.csv">Download</a>', 'king' ),
            'new_lines' => 'wpautop',
            'esc_html' => 0,
        ),
        array(
            'key' => 'field_5f88599405af7',
            'label' => __('Enable Newsletter Popup' , 'king' ),
            'name' => 'enable_newsletter_popup',
            'type' => 'true_false',
            'instructions' => __('Enable or disable the newsletter popup', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_5f8859b805af8',
            'label' => __('Newsletter Title' , 'king' ),
            'name' => 'newsletter_title',
            'type' => 'text',
            'instructions' => __('title for the newsletter popup', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5f88599405af7',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 'Stay Tuned',
            'placeholder' => '',
            'prepend' => 'Title',
            'append' => '',
            'maxlength' => '',
        ),
        array(
            'key' => 'field_5f885ccce1383',
            'label' => __('Newsletter Description' , 'king' ),
            'name' => 'newsletter_description',
            'type' => 'textarea',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5f88599405af7',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 'Subscribe our newsletter and never miss our latest news ...',
            'placeholder' => '',
            'maxlength' => '',
            'rows' => 4,
            'new_lines' => '',
        ),
        array(
            'key' => 'field_5f8863c48c9ae',
            'label' => __('Privacy Text' , 'king' ),
            'name' => 'privacy_text',
            'type' => 'text',
            'instructions' => __('Input privacy text for the newsletter popup form', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5f88599405af7',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 'By clicking, You are agreeing to our terms.',
            'placeholder' => '',
            'prepend' => '',
            'append' => '',
            'maxlength' => '',
        ),
        array(
            'key' => 'field_5f8866ee8c9af',
            'label' => __('Newsletter Submit Text' , 'king' ),
            'name' => 'newsletter_submit_text',
            'type' => 'text',
            'instructions' => __('Submit button text for the newsletter form', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5f88599405af7',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 'Subscribe',
            'placeholder' => '',
            'prepend' => '',
            'append' => '',
            'maxlength' => '',
        ),
        array(
            'key' => 'field_5f885da53139f',
            'label' => __('Newsletter Cover Image' , 'king' ),
            'name' => 'newsletter_cover_image',
            'type' => 'image',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5f88599405af7',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'return_format' => 'array',
            'preview_size' => 'thumbnail',
            'library' => 'all',
            'min_width' => '',
            'min_height' => '',
            'min_size' => '',
            'max_width' => '',
            'max_height' => '',
            'max_size' => '',
            'mime_types' => '',
        ),
        array(
            'key' => 'field_5f885e49889da',
            'label' => __('Newsletter Delay Time' , 'king' ),
            'name' => 'newsletter_delay_time',
            'type' => 'number',
            'instructions' => __('Input the delay time (ms) to show the popup after the site loaded.', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5f88599405af7',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 1000,
            'placeholder' => '',
            'prepend' => '',
            'append' => 'ms',
            'min' => 0,
            'max' => 30000,
            'step' => '',
        ),
        array(
            'key' => 'field_5f885e08889d9',
            'label' => __('Newsletter Popup Expired' , 'king' ),
            'name' => 'newsletter_expired',
            'type' => 'number',
            'instructions' => __('The period to redisplay the popup when visitors closed it.', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5f88599405af7',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 1,
            'placeholder' => '',
            'prepend' => '',
            'append' => 'Days',
            'min' => 0,
            'max' => 30,
            'step' => '',
        ),
        array(
            'key' => 'field_5f747acece5f3',
            'label' => __('Notifications' , 'king' ),
            'name' => '',
            'type' => 'tab',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'left',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_5ceac98602971',
            'label' => __('Enable User Notifications' , 'king' ),
            'name' => 'enable_notification',
            'type' => 'true_false',
            'instructions' => __('Users will get notifications from new comments, new likes, new followers etc...', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_5f885aa97a2c4',
            'label' => __('GDPR cookie' , 'king' ),
            'name' => '',
            'type' => 'message',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5f77448da710d',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'new_lines' => 'wpautop',
            'esc_html' => 0,
        ),
        array(
            'key' => 'field_5f77448da710d',
            'label' => __('Enable GDPR Cookie' , 'king' ),
            'name' => 'enable_gdpr_cookie',
            'type' => 'true_false',
            'instructions' => __('select options for cookie popup section.', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_5f7744a9a710e',
            'label' => __('Cookie Popup Content' , 'king' ),
            'name' => 'cookie_popup_content',
            'type' => 'textarea',
            'instructions' => __('Input content for the cookie popup section, allow raw HTML.', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5f77448da710d',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 'Our website uses cookies to improve your experience. Learn more about: <a href="#">Cookie Policy</a>',
            'placeholder' => '',
            'maxlength' => '',
            'rows' => 4,
            'new_lines' => '',
        ),
        array(
            'key' => 'field_5f7744eea710f',
            'label' => __('Cookie Button Text' , 'king' ),
            'name' => 'cookie_button_text',
            'type' => 'text',
            'instructions' => __('accept button text.', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5f77448da710d',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 'Accept',
            'placeholder' => '',
            'prepend' => 'text',
            'append' => '',
            'maxlength' => '',
        ),
        array(
            'key' => 'field_5f884501f33de',
            'label' => __('Headerstrip' , 'king' ),
            'name' => '',
            'type' => 'message',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5f73250316b5b',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'new_lines' => 'wpautop',
            'esc_html' => 0,
        ),
        array(
            'key' => 'field_5f73250316b5b',
            'label' => __('Enable Headerstrip' , 'king' ),
            'name' => 'enable_headerstrip',
            'type' => 'true_false',
            'instructions' => __('You can show informations at header for visitors or logged users', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_5f75f3434aceb',
            'label' => __('Show only for logged users' , 'king' ),
            'name' => 'show_only_logged_users',
            'type' => 'true_false',
            'instructions' => __('display message at top only for logged users', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5f73250316b5b',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_5f7325f5abaff',
            'label' => __('Headerstrip Text' , 'king' ),
            'name' => 'headerstrip_text',
            'type' => 'textarea',
            'instructions' => __('Text to show on header strip ( Html Allowed )', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5f73250316b5b',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'maxlength' => '',
            'rows' => 4,
            'new_lines' => '',
        ),
        array(
            'key' => 'field_5f732669abb00',
            'label' => __('Headerstrip Button Text' , 'king' ),
            'name' => 'headerstrip_button_text',
            'type' => 'text',
            'instructions' => __('add button in header strip', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5f73250316b5b',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
            'prepend' => 'text',
            'append' => '',
            'maxlength' => '',
        ),
        array(
            'key' => 'field_5f7326b3abb01',
            'label' => __('Headerstrip Button Url' , 'king' ),
            'name' => 'headerstrip_button_url',
            'type' => 'url',
            'instructions' => __('header strip button url', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5f73250316b5b',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '',
        ),
        array(
            'key' => 'field_5f7603c969a9a',
            'label' => __('Expired Time' , 'king' ),
            'name' => 'hs_expired_time',
            'type' => 'number',
            'instructions' => __('select expire time for header strip when visitors hide it. If you leave it empty it will appear after browser close', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5f73250316b5b',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 1,
            'placeholder' => '',
            'prepend' => 'Days',
            'append' => '',
            'min' => '',
            'max' => 999,
            'step' => '',
        ),
        array(
            'key' => 'field_5f75fee9e1b1a',
            'label' => __('Headerstrip Background' , 'king' ),
            'name' => 'headerstrip_background',
            'type' => 'color_picker',
            'instructions' => __('Headerstrip Background Color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5f73250316b5b',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5f75ff0ae1b1b',
            'label' => __('Headerstrip Text' , 'king' ),
            'name' => 'headerstrip_text_color',
            'type' => 'color_picker',
            'instructions' => __('Headerstrip Text Color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5f73250316b5b',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_5f75ff18e1b1c',
            'label' => __('Headerstrip Button' , 'king' ),
            'name' => 'headerstrip_button_color',
            'type' => 'color_picker',
            'instructions' => __('Headerstrip Button Color', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_5f73250316b5b',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'enable_opacity' => false,
            'return_format' => 'string',
        ),
        array(
            'key' => 'field_60b907cefd392',
            'label' => __('Votes' , 'king' ),
            'name' => '',
            'type' => 'tab',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'left',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_60b92a04cd8e1',
            'label' => __('Up Vote Custom Icon' , 'king' ),
            'name' => 'up_vote_custom_icon',
            'type' => 'text',
            'instructions' => __('Add custom up vote icon , You can select <a href="https://fontawesome.com/v5.15/icons?d=gallery&p=2" target="_blank">Here </a>', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '<i class="far fa-thumbs-up"></i>',
            'prepend' => '<i class="fas fa-chevron-up"></i>',
            'append' => '',
            'maxlength' => '',
        ),
        array(
            'key' => 'field_60b92a67cd8e2',
            'label' => __('Down Vote Custom Icon' , 'king' ),
            'name' => 'down_vote_custom_icon',
            'type' => 'text',
            'instructions' => __('Add custom down vote icon , You can select <a href="https://fontawesome.com/v5.15/icons?d=gallery&p=2" target="_blank">Here </a>', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'default_value' => '',
            'placeholder' => '<i class="far fa-thumbs-down"></i>',
            'prepend' => '<i class="fas fa-chevron-down"></i>',
            'append' => '',
            'maxlength' => '',
        ),
        array(
            'key' => 'field_60cb3c87e6d24',
            'label' => __('Disable Post Votes' , 'king' ),
            'name' => 'disable_post_votes',
            'type' => 'true_false',
            'instructions' => __('You can disable votes in posts', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_60b9082cfd394',
            'label' => __('Disable Down Vote in Posts' , 'king' ),
            'name' => 'disable_down_vote_in_posts',
            'type' => 'true_false',
            'instructions' => __('You can disable Down Votes in Posts', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_60b90800fd393',
            'label' => __('Disable Comment Votes' , 'king' ),
            'name' => 'disable_comment_votes',
            'type' => 'true_false',
            'instructions' => __('You can disable votes in comments', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_60b9088efd395',
            'label' => __('Disable Down Vote in Comments' , 'king' ),
            'name' => 'disable_down_vote_in_comments',
            'type' => 'true_false',
            'instructions' => __('You can disable down votes for comments', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_60b90800fd393',
                        'operator' => '!=',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_60e992b6aa87f',
            'label' => __('Homepage Login' , 'king' ),
            'name' => '',
            'type' => 'tab',
            
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'placement' => 'left',
            'endpoint' => 0,
        ),
        array(
            'key' => 'field_60e992d6aa880',
            'label' => __('Enable homepage login' , 'king' ),
            'name' => 'enable_homepage_login',
            'type' => 'true_false',
            'instructions' => __('you can make login and register page as homepage and lock content for visitors', 'king' ) ,
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => 0,
            'ui' => 1,
            'ui_on_text' => '',
            'ui_off_text' => '',
        ),
        array(
            'key' => 'field_60e993ebaa881',
            'label' => __('Homepage Login layout' , 'king' ),
            'name' => 'homepage_login_layout',
            'type' => 'radio',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_60e992d6aa880',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array(
                'login-1' => '<img src="../wp-content/themes/king/layouts/imgs/grid/hlogin-1.svg" height="175" width="230" />',
                'login-2' => '<img src="../wp-content/themes/king/layouts/imgs/grid/hlogin-2.svg" height="175" width="230" />',
                'login-3' => '<img src="../wp-content/themes/king/layouts/imgs/grid/hlogin-3.svg" height="175" width="230" />',
            ),
            'allow_null' => 0,
            'other_choice' => 0,
            'default_value' => '',
            'layout' => 'horizontal',
            'return_format' => 'value',
            'save_other_choice' => 0,
        ),
        array(
            'key' => 'field_60ec8794f6ff8',
            'label' => __('Page logo in Homepage Login' , 'king' ),
            'name' => 'logo_homepage_login',
            'type' => 'image',
            'instructions' => __('select your logo to show at homepage login and register', 'king' ) ,
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_60e992d6aa880',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'return_format' => 'id',
            'preview_size' => 'medium',
            'library' => 'all',
            'min_width' => '',
            'min_height' => '',
            'min_size' => '',
            'max_width' => '',
            'max_height' => '',
            'max_size' => '',
            'mime_types' => '',
        ),
        array(
            'key' => 'field_60e995a1aa884',
            'label' => __('Login page' , 'king' ),
            'name' => 'homelogin_page',
            'type' => 'group',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_60e992d6aa880',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'layout' => 'block',
            'sub_fields' => array(
                array(
                    'key' => 'field_60e995dbaa885',
                    'label' => __('Background Image' , 'king' ) ,
                    'name' => 'background_image',
                    'type' => 'image',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'return_format' => 'url',
                    'preview_size' => 'medium',
                    'library' => 'all',
                    'min_width' => '',
                    'min_height' => '',
                    'min_size' => '',
                    'max_width' => '',
                    'max_height' => '',
                    'max_size' => '',
                    'mime_types' => '',
                ),
                array(
                    'key' => 'field_60ed7eb45e9a7',
                    'label' => __('OR' , 'king' ) ,
                    'name' => '',
                    'type' => 'message',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                            'new_lines' => 'wpautop',
                    'esc_html' => 0,
                ),
                array(
                    'key' => 'field_60e995fbaa886',
                    'label' => __('Background color' , 'king' ) ,
                    'name' => 'background_color',
                    'type' => 'color_picker',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'enable_opacity' => false,
                    'return_format' => 'string',
                ),
                array(
                    'key' => 'field_60e997478249f',
                    'label' => __('Image on left' , 'king' ) ,
                    'name' => 'image_on_left',
                    'type' => 'image',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_60e993ebaa881',
                                'operator' => '==',
                                'value' => 'login-3',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'return_format' => 'url',
                    'preview_size' => 'medium',
                    'library' => 'all',
                    'min_width' => '',
                    'min_height' => '',
                    'min_size' => '',
                    'max_width' => '',
                    'max_height' => '',
                    'max_size' => '',
                    'mime_types' => '',
                ),
                array(
                    'key' => 'field_60e994d5aa882',
                    'label' => __('Login page message' , 'king' ) ,
                    'name' => 'message',
                    'type' => 'textarea',
                    'instructions' => __('You can add message on left of login form . ( HTML allowed ) ( not required )', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'placeholder' => '',
                    'maxlength' => '',
                    'rows' => 6,
                    'new_lines' => '',
                ),
            ),
        ),
        array(
            'key' => 'field_60e9966eaa887',
            'label' => __('Register page' , 'king' ),
            'name' => 'homeregister_page',
            'type' => 'group',
            
            'required' => 0,
            'conditional_logic' => array(
                array(
                    array(
                        'field' => 'field_60e992d6aa880',
                        'operator' => '==',
                        'value' => '1',
                    ),
                ),
            ),
            'wrapper' => array(
                'width' => '50',
                'class' => '',
                'id' => '',
            ),
            'layout' => 'block',
            'sub_fields' => array(
                array(
                    'key' => 'field_60e9966eaa888',
                    'label' => __('Background Image' , 'king' ) ,
                    'name' => 'background_image',
                    'type' => 'image',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'return_format' => 'url',
                    'preview_size' => 'medium',
                    'library' => 'all',
                    'min_width' => '',
                    'min_height' => '',
                    'min_size' => '',
                    'max_width' => '',
                    'max_height' => '',
                    'max_size' => '',
                    'mime_types' => '',
                ),
                array(
                    'key' => 'field_60ed7eec9c0e2',
                    'label' => __('OR' , 'king' ) ,
                    'name' => '',
                    'type' => 'message',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                            'new_lines' => 'wpautop',
                    'esc_html' => 0,
                ),
                array(
                    'key' => 'field_60e9966eaa889',
                    'label' => __('Background color' , 'king' ) ,
                    'name' => 'background_color',
                    'type' => 'color_picker',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'enable_opacity' => false,
                    'return_format' => 'string',
                ),
                array(
                    'key' => 'field_60e99799824a0',
                    'label' => __('Image on left' , 'king' ) ,
                    'name' => 'image_on_left',
                    'type' => 'image',
                    'instructions' => __('', 'king') , 
                    'required' => 0,
                    'conditional_logic' => array(
                        array(
                            array(
                                'field' => 'field_60e993ebaa881',
                                'operator' => '==',
                                'value' => 'login-3',
                            ),
                        ),
                    ),
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'return_format' => 'url',
                    'preview_size' => 'medium',
                    'library' => 'all',
                    'min_width' => '',
                    'min_height' => '',
                    'min_size' => '',
                    'max_width' => '',
                    'max_height' => '',
                    'max_size' => '',
                    'mime_types' => '',
                ),
                array(
                    'key' => 'field_60e9966eaa88a',
                    'label' => __('Register page message' , 'king' ) ,
                    'name' => 'message',
                    'type' => 'textarea',
                    'instructions' => __('You can add message on left of register form . ( HTML allowed ) ( not required )', 'king') , 
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'placeholder' => '',
                    'maxlength' => '',
                    'rows' => 6,
                    'new_lines' => '',
                ),
            ),
        ),
    ),
    'location' => array(
        array(
            array(
                'param' => 'options_page',
                'operator' => '==',
                'value' => 'acf-options-layout',
            ),
        ),
    ),
    'menu_order' => 3,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => true,
    'description' => '',
    'show_in_rest' => 0,
));

endif;      
?>
